/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;

public final class OutputFileNameMappingResolver {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("@\\{(.+?)\\}@");

    @NotNull
    public static String resolveOutputFileNameMapping(String text, MavenArtifact artifact) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = PROPERTY_PATTERN.matcher(text);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("groupId", artifact.getGroupId());
        properties.put("artifactId", artifact.getArtifactId());
        properties.put("version", artifact.getVersion());
        properties.put("baseVersion", artifact.getBaseVersion());
        properties.put("extension", artifact.getExtension());
        String classifier = artifact.getClassifier();
        properties.put("classifier", classifier);
        Object dashClassifier = StringUtil.isEmptyOrSpaces((String)classifier) ? "" : "-" + classifier;
        properties.put("dashClassifier?", dashClassifier);
        properties.put("dashClassifier", dashClassifier);
        int end = 0;
        while (matcher.find()) {
            result.append(text, end, matcher.start());
            end = matcher.end();
            String propertyName = matcher.group(1);
            String value = (String)properties.get(propertyName);
            if (value == null) continue;
            result.append(value);
        }
        result.append(text, end, text.length());
        String string = result.toString();
        if (string == null) {
            OutputFileNameMappingResolver.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String resolveLegacyFileNameMapping(@NotNull String mappingName, @NotNull MavenArtifact artifact, @NotNull boolean withConflict) {
        if (mappingName == null) {
            OutputFileNameMappingResolver.$$$reportNull$$$0(1);
        }
        if (artifact == null) {
            OutputFileNameMappingResolver.$$$reportNull$$$0(2);
        }
        return switch (mappingName) {
            case "full" -> {
                String dashedGroupId = artifact.getGroupId().replace('.', '-');
                yield dashedGroupId + "-" + OutputFileNameMappingResolver.generateLegacyFileName(artifact, true, false);
            }
            case "no-version" -> OutputFileNameMappingResolver.generateLegacyFileName(artifact, false, withConflict);
            case "no-version-for-ejb" -> {
                boolean isEjb = "ejb".equals(artifact.getType());
                yield OutputFileNameMappingResolver.generateLegacyFileName(artifact, !isEjb, withConflict);
            }
            default -> OutputFileNameMappingResolver.generateLegacyFileName(artifact, true, withConflict);
        };
    }

    @NotNull
    private static String generateLegacyFileName(MavenArtifact a, boolean addVersion, boolean addGroupId) {
        String extension = a.getExtension();
        StringBuilder buffer = new StringBuilder(128);
        if (addGroupId && StringUtil.isNotEmpty((String)a.getGroupId())) {
            buffer.append(a.getGroupId()).append("-");
        }
        buffer.append(a.getArtifactId());
        if (addVersion) {
            buffer.append('-').append(a.getBaseVersion());
        }
        if (!StringUtil.isEmpty((String)a.getClassifier())) {
            buffer.append('-').append(a.getClassifier());
        }
        if (!StringUtil.isEmpty((String)extension)) {
            buffer.append('.').append(extension);
        }
        String string = buffer.toString();
        if (string == null) {
            OutputFileNameMappingResolver.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/maven/OutputFileNameMappingResolver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOutputFileNameMapping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/maven/OutputFileNameMappingResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveLegacyFileNameMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

