/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.gradle;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.appServers.facet.AppServerWebFacetSettingsService;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.project.PackagingModifiableModel;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.javaee.JavaeeProjectDataService;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
final class WebModuleGradleDataService
extends JavaeeProjectDataService<WebConfigurationModelData, WebFacet, WebFacetConfiguration, WebFacetType> {
    private static final com.intellij.openapi.util.Key<Set<WebFacet>> NEW_FACETS = com.intellij.openapi.util.Key.create((String)"NEW_FACETS");
    private static final String WEB_INF_DIR_NAME = "WEB-INF";
    private static final com.intellij.openapi.util.Key<List<VirtualFile>> CONTENT_ROOTS_KEY = com.intellij.openapi.util.Key.create((String)"CONTENT_ROOTS");
    private static final com.intellij.openapi.util.Key<List<VirtualFile>> EXCLUDED_ROOTS_KEY = com.intellij.openapi.util.Key.create((String)"EXCLUDED_ROOTS");

    WebModuleGradleDataService() {
        super((JavaeeFacetType)WebFacetType.getInstance());
    }

    @NotNull
    public Key<WebConfigurationModelData> getTargetDataKey() {
        Key key = WebConfigurationModelData.KEY;
        if (key == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(@NotNull Collection<? extends DataNode<WebConfigurationModelData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module[] modules;
        if (toImport == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(3);
        }
        if (toImport.isEmpty()) {
            return;
        }
        SmartList contentRoots = new SmartList();
        SmartList excludedRoots = new SmartList();
        for (Module module : modules = projectData == null ? modelsProvider.getModules() : modelsProvider.getModules(projectData)) {
            ModifiableRootModel model = modelsProvider.getModifiableRootModel(module);
            ContainerUtil.addAll((Collection)contentRoots, (Object[])model.getContentRoots());
            ContainerUtil.addAll((Collection)excludedRoots, (Object[])model.getExcludeRoots());
        }
        modelsProvider.putUserData(CONTENT_ROOTS_KEY, (Object)contentRoots);
        modelsProvider.putUserData(EXCLUDED_ROOTS_KEY, (Object)excludedRoots);
        try {
            super.importData(toImport, projectData, project, modelsProvider);
        }
        finally {
            modelsProvider.putUserData(CONTENT_ROOTS_KEY, null);
            modelsProvider.putUserData(EXCLUDED_ROOTS_KEY, null);
        }
    }

    public void onSuccessImport(@NotNull Collection<DataNode<WebConfigurationModelData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Set newFacets;
        if (imported == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(4);
        }
        if (project == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(5);
        }
        if (modelsProvider == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(6);
        }
        if (!ContainerUtil.isEmpty((Collection)(newFacets = (Set)project.getUserData(NEW_FACETS)))) {
            for (WebFacet newFacet : newFacets) {
                Module facetModule = newFacet.getModule();
                HashSet sourceRoots = ContainerUtil.newHashSet((Object[])ModuleRootManager.getInstance((Module)facetModule).getSourceRootUrls(false));
                List roots = newFacet.getWebSourceRootUrls();
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    for (String sourceRoot : sourceRoots) {
                        if (roots.contains(sourceRoot)) continue;
                        newFacet.addWebSourceRoot(sourceRoot);
                    }
                });
            }
            project.putUserData(NEW_FACETS, null);
        }
    }

    public void onFailureImport(Project project) {
        project.putUserData(NEW_FACETS, null);
    }

    protected void configureJavaeeModule(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData javaeeData, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module;
        if (moduleData == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(7);
        }
        if (javaeeData == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(9);
        }
        if ((module = modelsProvider.findIdeModule(moduleData)) != null) {
            if (DetectionExcludesConfiguration.getInstance((Project)module.getProject()).isExcludedFromDetection((FrameworkType)WebFrameworkType.getInstance())) {
                return;
            }
            WebFacetType webFacetType = (WebFacetType)this.getJavaeeFacetType();
            HashSet<String> outputDirs = new HashSet<String>();
            ContainerUtil.addIfNotNull(outputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            String facetNamePrefix = this.getFacetNamePrefix((FacetType)webFacetType);
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
            Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
            for (WebFacet webFacet : webFacets) {
                if (!webFacet.getName().startsWith(facetNamePrefix)) continue;
                ApplicationManager.getApplication().invokeAndWait(() -> facetModel.removeFacet((Facet)webFacet));
            }
            List addedContentRoots = (List)modelsProvider.getUserData(CONTENT_ROOTS_KEY);
            List excludedRoots = (List)modelsProvider.getUserData(EXCLUDED_ROOTS_KEY);
            assert (addedContentRoots != null);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
            for (War war : javaeeData.getArtifacts()) {
                String facetName = this.adjustName(facetNamePrefix, war.getName());
                WebFacet webFacet = WebModuleGradleDataService.createOrReplaceWebFacet(facetModel, module, facetName, webFacetType, war);
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    VirtualFile webRootFile = webRoot.getFile();
                    if (webRootFile == null || WebModuleGradleDataService.isInContent(modifiableRootModel, webRootFile) || WebModuleGradleDataService.isDescendant(excludedRoots, webRootFile) || addedContentRoots.contains(webRootFile)) continue;
                    modifiableRootModel.addContentEntry(webRootFile, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
                    addedContentRoots.add(webRootFile);
                }
                String explodedArtifactName = this.resolveArtifactName(moduleData, war.getName(), true);
                ModifiableArtifact explodedArtifact = this.createOrUpdateArtifact(modelsProvider, module, explodedArtifactName, webFacetType, webFacet, war, webFacetType.getExplodedArtifactType(), outputDirs);
                String artifactName = this.resolveArtifactName(moduleData, war.getName(), false);
                ModifiableArtifact archiveArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)war, webFacetType.getArchiveArtifactType());
                PackagingElement artifactElement = PackagingElementFactory.getInstance().createArtifactElement((Artifact)explodedArtifact, module.getProject());
                archiveArtifact.getRootElement().addOrFindChild(artifactElement);
            }
            AppServerWebFacetSettingsService appServerSettingsService = AppServerWebFacetSettingsService.getInstance();
            if (appServerSettingsService != null) {
                Project project = module.getProject();
                ModifiableArtifactModel artifactModel = ((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getModifiableArtifactModel();
                String moduleExternalSystemId = ExternalSystemModulePropertyManager.getInstance((Module)module).getExternalSystemId();
                appServerSettingsService.setupAdditionalSettings(project, moduleExternalSystemId, artifactModel);
            }
        }
    }

    private static boolean isInContent(@NotNull ModifiableRootModel rootModel, @NotNull VirtualFile file) {
        if (rootModel == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(10);
        }
        if (file == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(11);
        }
        return WebModuleGradleDataService.isDescendant(Arrays.asList(rootModel.getContentRoots()), file);
    }

    private static boolean isDescendant(@Nullable List<VirtualFile> parents, @NotNull VirtualFile file) {
        if (file == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(12);
        }
        if (parents == null) {
            return false;
        }
        for (VirtualFile contentRoot : parents) {
            if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? WebArtifactUtil.getInstance().getExplodedWarArtifactType() : WebArtifactUtil.getInstance().getWarArtifactType();
    }

    protected Collection<String> resolveArtifactNames(@NotNull ModuleData moduleData, @NotNull WebConfigurationModelData data) {
        if (moduleData == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(13);
        }
        if (data == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(14);
        }
        SmartList names = new SmartList();
        for (War war : data.getArtifacts()) {
            names.add(this.resolveArtifactName(moduleData, war.getName(), false));
            names.add(this.resolveArtifactName(moduleData, war.getName(), true));
        }
        return names;
    }

    private static WebFacet createOrReplaceWebFacet(@NotNull ModifiableFacetModel facetModel, @NotNull Module module, @NotNull String facetName, @NotNull WebFacetType webFacetType, @NotNull War war) {
        File webXml;
        if (facetModel == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(15);
        }
        if (module == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(16);
        }
        if (facetName == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(17);
        }
        if (webFacetType == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(18);
        }
        if (war == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(19);
        }
        Collection webFacets = facetModel.getFacetsByType(webFacetType.getId());
        for (WebFacet webFacet : webFacets) {
            if (!facetName.equals(webFacet.getName())) continue;
            facetModel.removeFacet((Facet)webFacet);
            break;
        }
        WebFacet webFacet = webFacetType.createFacet(module, facetName, webFacetType.createDefaultConfiguration(), null);
        facetModel.addFacet((Facet)webFacet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)GradleConstants.SYSTEM_ID));
        WebModuleGradleDataService.addWebRoot(webFacet, war.getWebAppDir().getAbsolutePath(), "/");
        HashSet<String> added = new HashSet<String>();
        for (WebResource webResource : war.getWebResources()) {
            String relativePath;
            String dir;
            WarDirectory warDirectory = webResource.getWarDirectory();
            if (!WarDirectory.WAR_ROOT.equals((Object)warDirectory) && !WarDirectory.WEB_INF.equals((Object)warDirectory) && !warDirectory.isCustomDirectory()) continue;
            if (webResource.getFile().isFile()) {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getParent());
                relativePath = WebModuleGradleDataService.normalizeRelativePath(warDirectory.getRelativePath(), StringUtil.trimEnd((String)webResource.getWarRelativePath(), (String)webResource.getFile().getName()));
            } else {
                dir = FileUtil.toCanonicalPath((String)webResource.getFile().getPath());
                relativePath = WebModuleGradleDataService.normalizeRelativePath(warDirectory.getRelativePath(), webResource.getWarRelativePath());
            }
            if (!added.add(dir) || FileUtil.isAncestor((File)war.getWebAppDir(), (File)new File(dir), (boolean)false)) continue;
            WebModuleGradleDataService.addWebRoot(webFacet, dir, relativePath);
        }
        LinkedHashSet<WebFacet> newFacets = (LinkedHashSet<WebFacet>)module.getProject().getUserData(NEW_FACETS);
        if (newFacets == null) {
            newFacets = new LinkedHashSet<WebFacet>();
            module.getProject().putUserData(NEW_FACETS, newFacets);
        }
        newFacets.add(webFacet);
        File file = webXml = war.getWebXml() != null ? war.getWebXml() : new File(war.getWebAppDir(), "WEB-INF/web.xml");
        if (webXml.isFile()) {
            ConfigFileInfoSet descriptors = webFacet.getDescriptorsContainer().getConfiguration();
            ApplicationManager.getApplication().invokeAndWait(() -> descriptors.addConfigFile(DeploymentDescriptorsConstants.WEB_XML_META_DATA, VfsUtilCore.pathToUrl((String)webXml.getPath())));
        }
        return webFacet;
    }

    private static void addWebRoot(@NotNull WebFacet webFacet, @NotNull String dir, @NotNull String relativePath) {
        if (webFacet == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(21);
        }
        if (relativePath == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(22);
        }
        String url = VfsUtilCore.pathToUrl((String)dir);
        if (!WebModuleGradleDataService.isInsideWebRoots(dir, webFacet.getWebRoots())) {
            webFacet.addWebRootNoFire(url, relativePath);
        }
    }

    private static boolean isInsideWebRoots(String path, List<WebRoot> webRoots) {
        for (WebRoot webRoot : webRoots) {
            VirtualFile resDir = webRoot.getFile();
            if (resDir == null || !resDir.isValid() || !FileUtil.isAncestor((String)resDir.getPath(), (String)path, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static String normalizeRelativePath(String ... paths) {
        String relativePath = StringUtil.trimEnd((String)FileUtil.normalize((String)FileUtil.toSystemIndependentName((String)StringUtil.join((String[])paths, (String)"/"))), (String)"/");
        return relativePath.startsWith("//") ? relativePath.substring(1) : relativePath;
    }

    private ModifiableArtifact createOrUpdateArtifact(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Module module, @NotNull String artifactName, @NotNull WebFacetType webFacetType, @NotNull WebFacet webFacet, @NotNull War war, @NotNull ArtifactType artifactType, @NotNull Set<String> outputDirs) {
        if (modelsProvider == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(23);
        }
        if (module == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(24);
        }
        if (artifactName == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(25);
        }
        if (webFacetType == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(26);
        }
        if (webFacet == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(27);
        }
        if (war == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(28);
        }
        if (artifactType == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(29);
        }
        if (outputDirs == null) {
            WebModuleGradleDataService.$$$reportNull$$$0(30);
        }
        ModifiableArtifact modifiableArtifact = this.prepareArtifact(modelsProvider, module, artifactName, (Jar)war, artifactType);
        PackagingElementFactory packagingElementFactory = PackagingElementFactory.getInstance();
        CompositePackagingElement rootElement = modifiableArtifact.getRootElement();
        rootElement.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement((JavaeeFacet)webFacet));
        CompositePackagingElement moduleOutputPackagingElement = packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForDirectory());
        moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createModuleOutput(module));
        for (String outputDir : outputDirs) {
            moduleOutputPackagingElement.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
        }
        List warClasspath = ContainerUtil.mapNotNull((Collection)war.getClasspath(), file -> !file.exists() ? null : FileUtil.toSystemIndependentName((String)file.getAbsolutePath()));
        ArrayList<String> additionalGradleWarClasspath = new ArrayList<String>(warClasspath);
        this.addModuleDependencies(module, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, new HashSet<String>(), new HashSet<String>());
        for (String path : additionalGradleWarClasspath) {
            if (!new File(path).isFile()) continue;
            FileCopyPackagingElement element = new FileCopyPackagingElement(path);
            packagingElementFactory.getOrCreateDirectory(rootElement, webFacetType.getDefaultUriForJar()).addOrFindChildren(Collections.singletonList(element));
        }
        return modifiableArtifact;
    }

    private void addModuleDependencies(Module module, List<String> warClasspath, List<String> additionalGradleWarClasspath, PackagingElementFactory packagingElementFactory, IdeModifiableModelsProvider modelsProvider, WebFacetType webFacetType, ModifiableArtifact modifiableArtifact, HashSet<String> processedModules, HashSet<String> processedLibraries) {
        if (processedModules.contains(module.getName())) {
            return;
        }
        processedModules.add(module.getName());
        for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
            String moduleArchiveName;
            ExportableOrderEntry exportableOrderEntry;
            if (entry instanceof ExportableOrderEntry && (exportableOrderEntry = (ExportableOrderEntry)entry).getScope() != DependencyScope.COMPILE && exportableOrderEntry.getScope() != DependencyScope.RUNTIME) continue;
            if (entry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
                boolean onGradleWarClasspathLibrary = false;
                for (VirtualFile virtualFile : libraryOrderEntry.getRootFiles(OrderRootType.CLASSES)) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)virtualFile.getPresentableUrl());
                    onGradleWarClasspathLibrary = onGradleWarClasspathLibrary || warClasspath.contains(systemIndependentName);
                    additionalGradleWarClasspath.remove(systemIndependentName);
                }
                Library library = libraryOrderEntry.getLibrary();
                if (!onGradleWarClasspathLibrary || library == null || library.getName() != null && !processedLibraries.add(library.getName())) continue;
                List elements = packagingElementFactory.createLibraryElements(library);
                for (PackagingElement element : elements) {
                    String relativePath = WebModuleGradleDataService.getRelativePath(modelsProvider, webFacetType, element);
                    packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), relativePath).addOrFindChildren(Collections.singletonList(element));
                }
                continue;
            }
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
            Module moduleOrderEntryModule = moduleOrderEntry.getModule();
            HashSet moduleResourceOutputDirs = new HashSet();
            if (moduleOrderEntryModule == null) continue;
            ModuleData moduleData = (ModuleData)moduleOrderEntryModule.getUserData(AbstractModuleDataService.MODULE_DATA_KEY);
            if (moduleData != null) {
                PackagingElement element;
                moduleArchiveName = this.formatModuleArchiveFileName(moduleData);
                element = moduleData.getArtifacts().iterator();
                while (element.hasNext()) {
                    File gradleArtifact = (File)element.next();
                    additionalGradleWarClasspath.remove(FileUtil.toSystemIndependentName((String)gradleArtifact.getAbsolutePath()));
                }
                ContainerUtil.addIfNotNull(moduleResourceOutputDirs, (Object)moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE));
            } else {
                moduleArchiveName = moduleOrderEntry.getModuleName();
            }
            if (!processedModules.contains(moduleOrderEntryModule.getName())) {
                CompositePackagingElement moduleArchive = packagingElementFactory.createArchive(moduleArchiveName);
                moduleArchive.addOrFindChild(packagingElementFactory.createModuleOutput(moduleOrderEntryModule));
                for (String outputDir : moduleResourceOutputDirs) {
                    moduleArchive.addOrFindChild(packagingElementFactory.createDirectoryCopyWithParentDirectories(outputDir, "/"));
                }
                packagingElementFactory.getOrCreateDirectory(modifiableArtifact.getRootElement(), webFacetType.getDefaultUriForJar()).addOrFindChild((PackagingElement)moduleArchive);
            }
            this.addModuleDependencies(moduleOrderEntryModule, warClasspath, additionalGradleWarClasspath, packagingElementFactory, modelsProvider, webFacetType, modifiableArtifact, processedModules, processedLibraries);
        }
    }

    private static String getRelativePath(IdeModifiableModelsProvider modelsProvider, WebFacetType webFacetType, PackagingElement<?> element) {
        if (element instanceof DirectoryCopyPackagingElement) {
            return webFacetType.getDefaultUriForDirectory();
        }
        return element.getFilesKind(((PackagingModifiableModel)modelsProvider.getModifiableModel(PackagingModifiableModel.class)).getPackagingElementResolvingContext()).containsJarFiles() ? webFacetType.getDefaultUriForJar() : webFacetType.getDefaultUriForDirectory();
    }

    protected String getArtifactTaskName(boolean exploded) {
        return exploded ? "war_exploded" : "war";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/gradle/WebModuleGradleDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetModel";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetName";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacetType";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "war";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/gradle/WebModuleGradleDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onSuccessImport";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureJavaeeModule";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDescendant";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactNames";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createOrReplaceWebFacet";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addWebRoot";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateArtifact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalArgumentException(string);
        };
    }
}

