/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Triple;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolvedTypeIdCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, Map<Pair<PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSRecordType>>> myCachedRecordTypes = CollectionFactory.createConcurrentWeakKeySoftValueMap();
    private static final JSComplexityAwareRecursionGuard<Object> ourRecordTypesGuard = new JSComplexityAwareRecursionGuard("js.record.type.guard");
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, Map<?, ?>> myCachedValues = CollectionFactory.createConcurrentWeakKeySoftValueMap();
    private static final JSComplexityAwareRecursionGuard<Pair<JSResolvedTypeId, Key<?>>> ourValuesGuard = new JSComplexityAwareRecursionGuard("js.values.guard");
    private static final ThreadLocal<IntRef> CACHE_GET_DEPTH = ThreadLocal.withInitial(() -> new IntRef(0));

    @Nullable
    public <T> T getLocalCachedValue(@NotNull JSResolvedTypeId id, @NotNull Key<T> key, @NotNull Supplier<? extends @Nullable T> supplier) {
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(1);
        }
        if (supplier == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(2);
        }
        Map finalMap = this.getMapForTypeId(id);
        Triple mapKey = new Triple(key, (Object)JSTypeEvaluationLocationProvider.getTypeEvaluationConfigFile(), (Object)JSBuiltInTypeEngineEvaluation.isBuiltInTypeEngineForced());
        Supplier getValueFromCache = () -> (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)finalMap.get(mapKey);
        Consumer<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue> cacheNewValue = result -> {
            if (result != null) {
                finalMap.put((Triple)mapKey, (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)result);
            }
        };
        JSType owner = id.getOwnerType();
        Object value = ourValuesGuard.getCachedValue(Pair.create((Object)id, key), getValueFromCache, cacheNewValue, it -> {
            Object fromSupplier = supplier.get();
            return fromSupplier == owner ? JSTypeBaseImpl.getSelfNoTransformationType() : fromSupplier;
        });
        return (T)(value == JSTypeBaseImpl.getSelfNoTransformationType() ? owner : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T> Map<Triple<Key<T>, PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> getMapForTypeId(@NotNull JSResolvedTypeId id) {
        Map oldMap;
        Map<Object, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<Object>> map;
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(3);
        }
        IntRef depth = CACHE_GET_DEPTH.get();
        try {
            depth.inc();
            map = (ConcurrentHashMap<Triple<Key<T>, PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>>)this.myCachedValues.get(id);
        }
        finally {
            depth.set(depth.get() - 1);
        }
        if (map != null) {
            ConcurrentHashMap<Triple<Key<T>, PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> concurrentHashMap = map;
            if (concurrentHashMap == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(4);
            }
            return concurrentHashMap;
        }
        map = new ConcurrentHashMap<Triple<Key<T>, PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>>();
        if (depth.get() == 0 && (oldMap = (Map)this.myCachedValues.put(id, map)) != null) {
            map = oldMap;
        }
        ConcurrentHashMap<Triple<Key<T>, PsiFile, Boolean>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> concurrentHashMap = map;
        if (concurrentHashMap == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(5);
        }
        return concurrentHashMap;
    }

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(6);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(7);
        }
        Map cache = this.myCachedRecordTypes.computeIfAbsent(type.getResolvedTypeId(), __ -> new ConcurrentHashMap());
        Pair key = new Pair((Object)JSTypeEvaluationLocationProvider.getTypeEvaluationConfigFile(), (Object)JSBuiltInTypeEngineEvaluation.isBuiltInTypeEngineForced());
        Supplier getValueFromCache = () -> (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)cache.get(key);
        Consumer<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue> cacheNewValue = it -> {
            if (it != null) {
                cache.put(key, it);
            }
        };
        Object idForPreventingRecursion = JSResolvedTypeIdCache.getIdForPreventingRecursion(type);
        JSRecordType candidate = ourRecordTypesGuard.getCachedValue(idForPreventingRecursion, getValueFromCache, cacheNewValue, it -> (JSRecordType)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(sourceElement, () -> JSResolvedTypeIdCache.buildRecordTypeNoCache(type, sourceElement)));
        if (candidate == null) {
            return type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSNotARecordType(type.getSource());
        }
        return JSResolvedTypeIdCache.copyWithStrict(type, candidate);
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(8);
        }
        if (type instanceof JSGenericTypeImpl) {
            Set sources = (Set)StreamEx.of(((JSGenericTypeImpl)type).getArguments()).map(JSType::getSourceElement).nonNull().collect(Collectors.toSet());
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), (Object)sources);
            if (pair == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(9);
            }
            return pair;
        }
        if (type instanceof TypeScriptConditionalTypeJSTypeImpl) {
            TypeScriptConditionalTypeJSTypeImpl conditionalType = (TypeScriptConditionalTypeJSTypeImpl)type;
            Set set = StreamEx.of((Object[])new JSType[]{conditionalType, conditionalType.getCheckedType(), conditionalType.getTestType(), conditionalType.getTypeIfFalse(), conditionalType.getTypeIfTrue()}).map(el -> el.getSourceElement()).nonNull().toSet();
            if (set == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(10);
            }
            return set;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(11);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static JSRecordType copyWithStrict(@NotNull JSType original, @NotNull JSRecordType recordType) {
        if (original == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(12);
        }
        if (recordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(13);
        }
        if (recordType instanceof JSNotARecordType) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(14);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = (JSRecordType)recordType.copyWithStrict(original.isSourceStrict());
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(15);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(16);
        }
        if (element == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(17);
        }
        JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely(type);
        ProgressManager.checkCanceled();
        if (substitute != type) {
            JSRecordType jSRecordType = substitute.asRecordType();
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(18);
            }
            return jSRecordType;
        }
        Collection<? extends PsiElement> resolvedElements = JSResolvedTypeIdCache.resolveElementsForRecordType(type, element);
        if (type.isJavaScript() && (type instanceof JSObjectType || resolvedElements.isEmpty() || (type instanceof JSTypeImpl || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSTypeImpl) && ContainerUtil.and(resolvedElements, el -> el instanceof JSFunction || el instanceof JSVariable || el instanceof JSDefinitionExpression || el instanceof JSImplicitElement || el instanceof JSProperty))) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(19);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(20);
        }
        return jSRecordType;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(21);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(22);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(23);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9, 10, 11, 14, 15, 18, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 6: 
            case 8: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapForTypeId";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordTypeNoCache";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMapForTypeId";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyWithStrict";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9, 10, 11, 14, 15, 18, 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

