/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamCommonModelElement;
import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.model.annotations.mapping.EntityBaseImpl;
import com.intellij.jpa.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerBinding;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethod;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.GenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityListenerImpl
extends JamCommonModelElement<PsiClass>
implements EntityListener,
JamElement {
    public static final JamClassAttributeMeta.Collection ENTITY_LISTENERS_CLASSES = JamClassAttributeMeta.Collection.CLASS_COLLECTION_VALUE_META;
    public static final JamClassMeta<EntityListenerImpl> ENTITY_LISTENER_META = new JamClassMeta(null, EntityListenerImpl.class, EntityListenerImpl::new);

    private EntityListenerImpl(PsiElementRef<?> psiRef) {
        super(psiRef);
    }

    public boolean isValid() {
        return super.isValid() && Comparing.equal((Object)((EntityListenerImpl)ENTITY_LISTENER_META.getJamElement((PsiModifierListOwner)((PsiClass)this.getPsiElement()))), (Object)this);
    }

    @Override
    public GenericValue<PsiClass> getClazz() {
        return AnnotationGenericValue.getInstance((Object)((PsiClass)this.getPsiElement()), null, null);
    }

    @Override
    public void processEntityListenerBindings(Processor<EntityListenerBinding> processor) {
        PsiClass psiClass = (PsiClass)this.getPsiElement();
        if (!psiClass.isValid()) {
            return;
        }
        ReferencesSearch.search((PsiElement)psiClass).forEach(t -> {
            final PsiClassObjectAccessExpression classAccessExpression = (PsiClassObjectAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)t.getElement(), PsiClassObjectAccessExpression.class);
            if (classAccessExpression != null) {
                PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                final PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiMember.class);
                if (psiMember instanceof PsiClass && psiAnnotation != null && JpaAnnotationConstants.ENTITY_LISTENERS_ANNO.isFqn(psiAnnotation.getQualifiedName()) && !processor.process((Object)new EntityListenerBinding(){

                    @Override
                    public String getEntityBaseClassName() {
                        return ((PsiClass)psiMember).getQualifiedName();
                    }

                    @Override
                    @NotNull
                    public PersistentEntityBase getTargetObject() {
                        PersistentEntityBase persistentEntityBase = JpaUtil.getFirstPersistentObjectOfClass((PsiClass)psiMember, EntityBaseImpl.class);
                        if (persistentEntityBase == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return persistentEntityBase;
                    }

                    @Override
                    public void delete() {
                        try {
                            PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)classAccessExpression, PsiAnnotation.class);
                            if (psiAnnotation != null && AnnotationModelUtil.getPsiClassArrayValue((PsiAnnotation)psiAnnotation, (String)"value").size() == 1) {
                                psiAnnotation.delete();
                            } else {
                                classAccessExpression.delete();
                            }
                        }
                        catch (IncorrectOperationException e) {
                            Logger.getInstance(EntityListenerImpl.class).error((Throwable)e);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/annotations/mapping/EntityListenerImpl$1", "getTargetObject"));
                    }
                })) {
                    return false;
                }
            }
            return true;
        });
    }

    @Override
    public void processEntityListenerMethods(@Nullable PsiClass currentClass, Processor<EntityListenerMethod> processor) {
        boolean processDeep;
        PsiClass topClass = (PsiClass)this.getPsiElement();
        boolean bl = processDeep = currentClass == null;
        if (!processDeep && topClass != currentClass && !topClass.isInheritor(currentClass, true)) {
            return;
        }
        EntityListenerImpl.processEntityListenerMethodsImpl(processDeep ? topClass : currentClass, processor, processDeep);
    }

    static void processEntityListenerMethodsImpl(PsiClass interceptorClass, Processor<? super EntityListenerMethod> processor, boolean processDeep) {
        JavaeeType javaeeType = JavaeeType.discover((PsiElement)interceptorClass, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
        block0: for (EntityListenerMethodType type : EntityListenerMethodType.values()) {
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)interceptorClass.getProject()).findClass(type.getMethodAnnotation().fqn(javaeeType), interceptorClass.getResolveScope());
            if (annotationClass == null) continue;
            for (PsiClass currentClass : JamCommonUtil.getSuperClassList((PsiClass)interceptorClass)) {
                AnnotatedMembersSearch.search((PsiClass)annotationClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)currentClass.getContainingFile())).forEach(t -> !(t instanceof PsiMethod) || t.getContainingClass() != currentClass || processor.process((Object)new MyEntityListenerMethod((PsiMember)t, type)));
                if (processDeep) continue;
                continue block0;
            }
        }
    }

    private static class MyEntityListenerMethod
    implements EntityListenerMethod {
        private final PsiMember myT;
        private final EntityListenerMethodType myType;

        MyEntityListenerMethod(PsiMember t, EntityListenerMethodType type) {
            this.myT = t;
            this.myType = type;
        }

        @Override
        @Nullable
        public PsiMethod getMethod() {
            return (PsiMethod)this.myT;
        }

        @Override
        public EntityListenerMethodType getType() {
            return this.myType;
        }

        @Override
        public void delete() throws IncorrectOperationException {
            PsiAnnotation psiAnnotation = this.getDefiningElement();
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }

        public PsiAnnotation getDefiningElement() {
            return this.myT.getModifierList().findAnnotation(this.myType.getMethodAnnotation().fqnFromAnnotated((PsiModifierListOwner)this.myT));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntityListenerMethod that = (MyEntityListenerMethod)o;
            if (this.myT != null ? !this.myT.equals((Object)that.myT) : that.myT != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myT != null ? this.myT.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            return result;
        }
    }
}

