/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.common.persistence.mapping;

import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.JavaeeIcons;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttributeType
implements PersistentAttributeType {
    private final Class<?> myAttributeClass;
    @NotNull
    @Nls
    private final String myTypeName;
    private final JamMemberMeta<PsiMember, ? extends JamAttributeBase>[] myJamMeta;
    private final JavaeeClass myAnnotation;

    protected AttributeType(Class<?> attributeClass, @Nls @NotNull String typeName, @Nullable JavaeeClass javaeeClass, JamMemberMeta<PsiMember, ? extends JamAttributeBase> ... jamMetas) {
        if (typeName == null) {
            AttributeType.$$$reportNull$$$0(0);
        }
        this.myAnnotation = javaeeClass;
        assert (attributeClass != null) : "null attribute class";
        this.myAttributeClass = attributeClass;
        this.myTypeName = typeName;
        this.myJamMeta = jamMetas;
    }

    @NotNull
    @Nls
    public String getTypeName() {
        String string = this.myTypeName;
        if (string == null) {
            AttributeType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Class<?> getAttributeClass() {
        return this.myAttributeClass;
    }

    public JamMemberMeta<PsiMember, ? extends JamAttributeBase>[] getJamMetas() {
        return this.myJamMeta;
    }

    @Nullable
    public JavaeeClass getAttributeAnnotation() {
        return this.myAnnotation;
    }

    @Nullable
    public RelationshipType getRelationshipType() {
        return null;
    }

    @NotNull
    public static AttributeType getAttributeType(@NotNull PersistentAttribute attribute) {
        if (attribute == null) {
            AttributeType.$$$reportNull$$$0(2);
        }
        boolean container = attribute.getAttributeModelHelper().isContainer();
        List list = ModelMergerUtil.getImplementations((Object)attribute);
        int size = list.size();
        for (int i = size - 1; i > -1; --i) {
            PersistentAttribute attr = (PersistentAttribute)list.get(i);
            for (AttributeType type : PersistenceAttributesProvider.values()) {
                if (!type.accepts(attr) || type.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY) != container) continue;
                AttributeType attributeType = type;
                if (attributeType == null) {
                    AttributeType.$$$reportNull$$$0(3);
                }
                return attributeType;
            }
        }
        throw new AssertionError(attribute);
    }

    protected boolean accepts(PersistentAttribute attribute) {
        return this.getAttributeClass().isInstance(attribute);
    }

    @NotNull
    public static AttributeType getAttributeType(@NotNull RelationshipType relationshipType) {
        if (relationshipType == null) {
            AttributeType.$$$reportNull$$$0(4);
        }
        for (AttributeType type : PersistenceAttributesProvider.values()) {
            if (type.getRelationshipType() != relationshipType) continue;
            AttributeType attributeType = type;
            if (attributeType == null) {
                AttributeType.$$$reportNull$$$0(5);
            }
            return attributeType;
        }
        throw new AssertionError(relationshipType);
    }

    public boolean isIdAttribute() {
        return false;
    }

    public boolean isVersionAttribute() {
        return false;
    }

    public Icon getIcon() {
        boolean id = this.isIdAttribute();
        if (this.getRelationshipType() != null) {
            return id ? JavaeeIcons.ID_RELATIONSHIP_ICON : JavaeeIcons.RELATIONSHIP_ICON;
        }
        return id ? JavaeeIcons.ID_ATTRIBUTE_ICON : JavaeeIcons.ATTRIBUTE_ICON;
    }

    public String toString() {
        return "[" + this.getTypeName() + "]";
    }

    @NotNull
    public PsiType getDefaultPsiType(PersistentAttribute attribute) {
        PsiType psiType = this.getDefaultElementPsiType(attribute);
        if (this.accepts(PersistentAttributeType.AttributeComponent.COLLECTION_VALUE, PersistentAttributeType.ComponentType.ANY)) {
            PsiType psiType2;
            try {
                psiType2 = JavaContainerType.COLLECTION.createCollectionType(attribute.getIdentifyingPsiElement(), psiType, null);
            }
            catch (IncorrectOperationException e) {
                throw new AssertionError((Object)e);
            }
            if (psiType2 == null) {
                AttributeType.$$$reportNull$$$0(6);
            }
            return psiType2;
        }
        PsiType psiType3 = psiType;
        if (psiType3 == null) {
            AttributeType.$$$reportNull$$$0(7);
        }
        return psiType3;
    }

    @NotNull
    protected PsiType getDefaultElementPsiType(PersistentAttribute attribute) {
        PersistentRelationshipAttribute relationAttributeBase;
        PsiClass aClass;
        PsiManager psiManager = attribute.getPsiManager();
        PsiClassType psiType = null;
        if (attribute instanceof PersistentEmbeddedAttribute) {
            PsiClass aClass2 = (PsiClass)((PersistentEmbeddedAttribute)attribute).getTargetEmbeddableClass().getValue();
            psiType = aClass2 == null ? PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)ProjectScope.getAllScope((Project)psiManager.getProject())) : JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(aClass2);
        } else if (attribute instanceof PersistentRelationshipAttribute && (aClass = (PsiClass)(relationAttributeBase = (PersistentRelationshipAttribute)attribute).getTargetEntityClass().getValue()) != null) {
            psiType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(aClass);
        }
        if (psiType == null) {
            psiType = PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)ProjectScope.getAllScope((Project)psiManager.getProject()));
        }
        PsiClassType psiClassType = psiType;
        if (psiClassType == null) {
            AttributeType.$$$reportNull$$$0(8);
        }
        return psiClassType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/common/persistence/mapping/AttributeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationshipType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/common/persistence/mapping/AttributeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPsiType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultElementPsiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

