/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.config;

import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaBasePathFinder {
    private static final String BASE_PATH_VAR_NAME = "basePath";
    private static final KarmaBasePathFinder INSTANCE = new KarmaBasePathFinder();
    private final Key<CachedValue<String>> myTestFileStructureRegistryKey = Key.create((String)KarmaBasePathFinder.class.getSimpleName());

    @NotNull
    public static KarmaBasePathFinder getInstance() {
        KarmaBasePathFinder karmaBasePathFinder = INSTANCE;
        if (karmaBasePathFinder == null) {
            KarmaBasePathFinder.$$$reportNull$$$0(0);
        }
        return karmaBasePathFinder;
    }

    public String fetchBasePath(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            KarmaBasePathFinder.$$$reportNull$$$0(1);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        return (String)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, this.myTestFileStructureRegistryKey, () -> {
            String basePath = KarmaBasePathFinder.buildBasePath(jsFile);
            return CachedValueProvider.Result.create((Object)basePath, (Object[])new Object[]{jsFile});
        }, false);
    }

    @Nullable
    private static String buildBasePath(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            KarmaBasePathFinder.$$$reportNull$$$0(2);
        }
        final Ref basePathRef = Ref.create(null);
        JSElementVisitor visitor = new JSElementVisitor(){

            public void visitJSProperty(@NotNull JSProperty property) {
                JSLiteralExpression value;
                String name;
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (KarmaBasePathFinder.BASE_PATH_VAR_NAME.equals(name = JsPsiUtils.getPropertyName((JSProperty)property)) && (value = (JSLiteralExpression)ObjectUtils.tryCast((Object)property.getValue(), JSLiteralExpression.class)) != null && value.isQuotedLiteral()) {
                    basePathRef.set((Object)StringUtil.unquoteString((String)value.getText()));
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProgressIndicatorProvider.checkCanceled();
                if (basePathRef.isNull()) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/karma/config/KarmaBasePathFinder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSProperty";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        visitor.visitJSFile(jsFile);
        return (String)basePathRef.get();
    }

    public static boolean isBasePathStringLiteral(@NotNull JSLiteralExpression literalExpression) {
        JSProperty property;
        if (literalExpression == null) {
            KarmaBasePathFinder.$$$reportNull$$$0(3);
        }
        if (literalExpression.isQuotedLiteral() && (property = (JSProperty)ObjectUtils.tryCast((Object)literalExpression.getParent(), JSProperty.class)) != null) {
            String name = JsPsiUtils.getPropertyName((JSProperty)property);
            return BASE_PATH_VAR_NAME.equals(name);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/config/KarmaBasePathFinder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/config/KarmaBasePathFinder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fetchBasePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildBasePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBasePathStringLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

