/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.karma.execution.KarmaDetector;
import com.intellij.javascript.testFramework.JsTestSelector;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectionUtilsKt;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaTestLocationProvider
implements SMTestLocator {
    private static final String PROTOCOL_ID__CONFIG_FILE = "config";
    private static final String PROTOCOL_ID__TEST_SUITE = "suite";
    private static final String PROTOCOL_ID__TEST = "test";
    public static final KarmaTestLocationProvider INSTANCE = new KarmaTestLocationProvider();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(3);
        }
        Location location = switch (protocol) {
            case PROTOCOL_ID__CONFIG_FILE -> KarmaTestLocationProvider.getConfigLocation(project, path);
            case PROTOCOL_ID__TEST_SUITE -> KarmaTestLocationProvider.getTestLocation(project, path, true);
            case PROTOCOL_ID__TEST -> KarmaTestLocationProvider.getTestLocation(project, path, false);
            default -> null;
        };
        List list = ContainerUtil.createMaybeSingletonList((Object)location);
        if (list == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private static Location<PsiFile> getConfigLocation(Project project, @NotNull String locationData) {
        PsiFile psiFile;
        Path location;
        VirtualFile virtualFile;
        if (locationData == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile2 = virtualFile = (location = NioFiles.toPath((String)locationData)) != null ? LocalFileSystem.getInstance().findFileByNioFile(location) : null;
        if (virtualFile != null && virtualFile.isValid() && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && psiFile.isValid()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        return null;
    }

    @Nullable
    private static Location getTestLocation(Project project, @NotNull String locationData, boolean isSuite) {
        String testName;
        List suiteNames;
        List path;
        if (locationData == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(6);
        }
        if ((path = EscapeUtils.split((String)locationData, (char)'.')).isEmpty()) {
            return null;
        }
        if (isSuite) {
            suiteNames = path;
            testName = null;
        } else {
            suiteNames = path.subList(0, path.size() - 1);
            testName = (String)path.get(path.size() - 1);
        }
        JsTestSelector testSelector = new JsTestSelector(suiteNames, testName);
        PsiElement psiElement = JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestNamesIndexes((Project)project, (JsTestFrameworkDetector)KarmaTestLocationProvider.getKarmaDetector(), (JsTestSelector)testSelector);
        if (psiElement == null) {
            String moduleName = null;
            if (suiteNames.isEmpty()) {
                moduleName = "Default Module";
            } else if (suiteNames.size() == 1) {
                moduleName = (String)suiteNames.get(0);
            }
            if (moduleName != null) {
                JsTestSelector specialQunitSelector = new JsTestSelector(List.of(moduleName), testName);
                psiElement = JsTestFrameworkDetectionUtilsKt.findPsiElementInJsTestNamesIndexes((Project)project, (JsTestFrameworkDetector)KarmaTestLocationProvider.getKarmaDetector(), (JsTestSelector)specialQunitSelector);
            }
        }
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    @NotNull
    public static KarmaDetector getKarmaDetector() {
        KarmaDetector karmaDetector = KarmaDetector.Companion.getInstance();
        if (karmaDetector == null) {
            KarmaTestLocationProvider.$$$reportNull$$$0(7);
        }
        return karmaDetector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaTestLocationProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaTestLocationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigLocation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

