/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.DataGridBundle;
import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseFastConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PgBaseUrlCheckingInterceptor
extends DatabaseFastConnectionInterceptor {
    public boolean interceptConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        if (proto == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(0);
        }
        return proto.getConnectionPoint().getDbms().isPostgres();
    }

    public boolean handleNullConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, int attempt, @NotNull Project project) {
        if (proto == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(2);
        }
        if (PgBaseUrlCheckingInterceptor.canFixUrl(proto.getConnectionPoint())) {
            throw new KnownDatabaseException((ErrorInfo)new UrlMissingSlashInfo(proto.getConnectionPoint().getDataSource(), project));
        }
        return false;
    }

    @NotNull
    public static String fixUrl(@NotNull String url, @NotNull LocalDataSource dataSource) {
        String fixed;
        if (url == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(4);
        }
        if (PgBaseUrlCheckingInterceptor.isValidUrl(dataSource, url)) {
            String string = url;
            if (string == null) {
                PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(5);
            }
            return string;
        }
        int qIdx = url.indexOf("?");
        if (qIdx == -1) {
            if (url.endsWith("/")) {
                String string = url;
                if (string == null) {
                    PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(6);
                }
                return string;
            }
            fixed = url + "/";
        } else {
            if (qIdx == 0 || url.charAt(qIdx - 1) == '/') {
                String string = url;
                if (string == null) {
                    PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(7);
                }
                return string;
            }
            fixed = url.substring(0, qIdx) + "/" + url.substring(qIdx);
        }
        if (PgBaseUrlCheckingInterceptor.isValidUrl(dataSource, fixed)) {
            String string = fixed;
            if (string == null) {
                PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isValidUrl(@NotNull LocalDataSource dataSource, @NotNull String url) {
        if (dataSource == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(10);
        }
        if (url == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(11);
        }
        return JdbcUrlParserUtil.select((RawConnectionConfig)dataSource, (String)url) != null;
    }

    public static boolean canFixUrl(@NotNull DatabaseConnectionPoint point) {
        String url;
        if (point == null) {
            PgBaseUrlCheckingInterceptor.$$$reportNull$$$0(12);
        }
        if ((url = point.getUrl()) == null) {
            return false;
        }
        String fixed = PgBaseUrlCheckingInterceptor.fixUrl(url, point.getDataSource());
        return !url.equals(fixed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fixUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "interceptConnectionFast";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleNullConnectionFast";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fixUrl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidUrl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canFixUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class UrlMissingSlashInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        public UrlMissingSlashInfo(@Nullable LocalDataSource dataSource, @NotNull Project project) {
            if (project == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(0);
            }
            this(dataSource, new Throwable(), project);
        }

        private UrlMissingSlashInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Project project) {
            if (original == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(1);
            }
            if (project == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(2);
            }
            this(dataSource, original, original, project);
        }

        public UrlMissingSlashInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull Project project) {
            if (original == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(3);
            }
            if (cause == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(4);
            }
            if (project == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(5);
            }
            super(dataSource, original, cause);
        }

        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            String url;
            if (sb == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(6);
            }
            if (fixes == null) {
                UrlMissingSlashInfo.$$$reportNull$$$0(7);
            }
            sb.append(DataGridBundle.message((String)"looks.like.the.connection.string.is.missing", (Object[])new Object[0]));
            LocalDataSource dataSource = this.getDataSource();
            DatabaseFixFactory ff = DatabaseFixFactory.getInstance();
            String string = url = dataSource == null ? null : dataSource.getUrl();
            if (ff != null && url != null) {
                fixes.add(ff.setUrl(dataSource, DataGridBundle.message((String)"add.to.connection.string", (Object[])new Object[0]), PgBaseUrlCheckingInterceptor.fixUrl(url, dataSource)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/postgresbase/PgBaseUrlCheckingInterceptor$UrlMissingSlashInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

