/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ComponentModel;
import com.jgoodies.binding.value.ComponentValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractWrappedValueModel
extends AbstractValueModel
implements ComponentValueModel {
    private final ValueModel wrappee;
    private final ComponentModel componentPropertyProvider;
    private final PropertyChangeListener valueChangeHandler;
    private final PropertyChangeListener componentPropertyChangeHandler;

    public AbstractWrappedValueModel(ValueModel wrappee) {
        this.wrappee = (ValueModel)Preconditions.checkNotNull((Object)wrappee, (String)"The wrapped model must not be null.");
        this.componentPropertyProvider = wrappee instanceof ComponentModel ? (ComponentModel)((Object)wrappee) : new SimpleComponentModel();
        this.valueChangeHandler = this.createValueChangeHandler();
        this.componentPropertyChangeHandler = new ComponentPropertyChangeHandler();
        wrappee.addValueChangeListener(this.valueChangeHandler);
        this.componentPropertyProvider.addPropertyChangeListener(this.componentPropertyChangeHandler);
    }

    @Override
    public boolean isEnabled() {
        return this.componentPropertyProvider.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.componentPropertyProvider.setEnabled(b);
    }

    @Override
    public boolean isVisible() {
        return this.componentPropertyProvider.isVisible();
    }

    @Override
    public void setVisible(boolean b) {
        this.componentPropertyProvider.setVisible(b);
    }

    @Override
    public boolean isEditable() {
        return this.componentPropertyProvider.isEditable();
    }

    @Override
    public void setEditable(boolean b) {
        this.componentPropertyProvider.setEditable(b);
    }

    public void release() {
        this.wrappee.removeValueChangeListener(this.valueChangeHandler);
        this.componentPropertyProvider.removePropertyChangeListener(this.componentPropertyChangeHandler);
    }

    protected abstract PropertyChangeListener createValueChangeHandler();

    protected final ValueModel getWrappee() {
        return this.wrappee;
    }

    private static final class SimpleComponentModel
    extends Bean
    implements ComponentModel {
        private boolean enabled = true;
        private boolean visible = true;
        private boolean editable = true;

        SimpleComponentModel() {
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean b) {
            boolean oldEnabled = this.isEnabled();
            this.enabled = b;
            this.firePropertyChange("enabled", oldEnabled, b);
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void setVisible(boolean b) {
            boolean oldVisible = this.isVisible();
            this.visible = b;
            this.firePropertyChange("visible", oldVisible, b);
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public void setEditable(boolean b) {
            boolean oldEditable = this.isEditable();
            this.editable = b;
            this.firePropertyChange("editable", oldEditable, b);
        }
    }

    private final class ComponentPropertyChangeHandler
    implements PropertyChangeListener {
        private ComponentPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == null || propertyName.equals("enabled") || propertyName.equals("visible") || propertyName.equals("editable")) {
                AbstractWrappedValueModel.this.firePropertyChange(propertyName, evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

