/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdviceType;
import com.intellij.aop.AopBundle;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class AroundAdviceStyleInspection
extends AbstractAopInspection {
    @Override
    protected void checkAopMethod(final PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator == null || manipulator.getAdviceType() != AopAdviceType.AROUND) {
            return;
        }
        final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)pointcutMethod.getProject()).getElementFactory();
        if (PsiTypes.voidType().equals((Object)pointcutMethod.getReturnType()) && pointcutMethod.getReturnTypeElement() != null) {
            holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("around.advice.should.return.something", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!pointcutMethod.isValid()) {
                        return;
                    }
                    try {
                        PsiClassType object = PsiType.getJavaLangObject((PsiManager)pointcutMethod.getManager(), (GlobalSearchScope)pointcutMethod.getResolveScope());
                        pointcutMethod.getReturnTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)object));
                    }
                    catch (IncorrectOperationException e) {
                        Logger.getInstance(AroundAdviceStyleInspection.class).error((Throwable)e);
                    }
                }

                @NotNull
                public String getFamilyName() {
                    String string = AopBundle.message("change.return.type.to.Object", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/aop/jam/AroundAdviceStyleInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/aop/jam/AroundAdviceStyleInspection$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            }});
            return;
        }
        PsiParameter[] parameters = pointcutMethod.getParameterList().getParameters();
        if (parameters.length == 0 || !parameters[0].getType().equalsToText("org.aspectj.lang.ProceedingJoinPoint")) {
            holder.registerProblem(manipulator.getCommonProblemElement(), AopBundle.message("around.advice.call.cannot.proceed", new Object[0]), new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = AopBundle.message("add.pjp.parameter", new Object[0]);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (!pointcutMethod.isValid()) {
                        return;
                    }
                    try {
                        PsiParameter newParameter = factory.createParameter("pjp", factory.createTypeFromText("org.aspectj.lang.ProceedingJoinPoint", (PsiElement)pointcutMethod));
                        PsiParameterList list = pointcutMethod.getParameterList();
                        PsiParameter parameter = list.getParameter(0);
                        if (parameter == null) {
                            list.add((PsiElement)newParameter);
                        } else {
                            list.addBefore((PsiElement)newParameter, (PsiElement)parameter);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Logger.getInstance(AroundAdviceStyleInspection.class).error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/aop/jam/AroundAdviceStyleInspection$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/aop/jam/AroundAdviceStyleInspection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2 -> new IllegalArgumentException(string);
                    };
                }
            }});
        }
    }
}

