/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlDeleteStatement;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlFromClause;
import com.intellij.jpa.ql.psi.QlInsertClause;
import com.intellij.jpa.ql.psi.QlInsertStatement;
import com.intellij.jpa.ql.psi.QlJoinExpression;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlUpdateStatement;
import com.intellij.jpa.ql.psi.impl.QlPsiImplUtil;
import com.intellij.jpa.ql.psi.impl.QlReferenceImpl;
import com.intellij.jpa.ql.types.QlClassType;
import com.intellij.jpa.ql.types.QlIndexedCollectionType;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlCompositeElementImpl
extends ASTWrapperPsiElement
implements QlCompositeElement {
    @NonNls
    private static final Set<String> STRING_DATATYPES = Set.of("java.lang.String");
    @NonNls
    private static final Set<String> NUMBER_DATATYPES = Set.of("java.lang.Long", "long", "java.lang.Integer", "int", "java.math.BigInteger", "java.math.BigDecimal", "java.lang.Short", "short", "java.lang.Byte", "byte", "java.lang.Float", "float", "java.lang.Double", "double");
    @NonNls
    private static final Set<String> BOOLEAN_DATATYPES = Set.of("java.lang.Boolean", "boolean");
    @NonNls
    private static final Set<String> DATETIME_DATATYPES = Set.of("java.util.Date", "java.util.Calendar", "java.sql.Date", "java.sql.Timestamp", "java.sql.Time", "org.joda.time.DateTime", "java.time.LocalTime", "java.time.LocalDate", "java.time.LocalDateTime", "java.time.Instant", "java.time.OffsetDateTime", "java.time.ZonedDateTime");

    public QlCompositeElementImpl(@NotNull ASTNode node) {
        if (node == null) {
            QlCompositeElementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            QlCompositeElementImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            QlCompositeElementImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            QlCompositeElementImpl.$$$reportNull$$$0(3);
        }
        if (this instanceof QlQueryExpression) {
            QlSelectClause select = ((QlQueryExpression)((Object)this)).getSelectClause();
            QlFromClause fromClause = ((QlQueryExpression)((Object)this)).getFromClause();
            if (lastParent != fromClause && fromClause != null) {
                if (!fromClause.processDeclarations(processor, state, lastParent, place)) {
                    return false;
                }
                if (select != null && !select.processDeclarations(processor, state, lastParent, place)) {
                    return false;
                }
                if (!QlCompositeElementImpl.processClauseTypeVariables(fromClause, processor, state, place)) {
                    return false;
                }
            }
            return true;
        }
        if (this instanceof QlUpdateStatement || this instanceof QlDeleteStatement || this instanceof QlInsertStatement) {
            PsiElement clause = this.getFirstChild();
            if (clause != null && clause != lastParent && !QlCompositeElementImpl.processClauseTypeVariables(clause, processor, state, place)) {
                return false;
            }
        } else if (this instanceof QlInsertClause) {
            QlReferenceExpression expression = ((QlInsertClause)((Object)this)).getReferenceExpression();
            if (expression != lastParent && !QlReferenceImpl.processQualifierExpression(this.getProject(), expression, processor, state, place)) {
                return false;
            }
        } else {
            if (lastParent.getParent() != this && this instanceof PsiNamedElement && !processor.execute((PsiElement)this, state)) {
                return false;
            }
            if (!(this instanceof QlExpression) || this instanceof QlJoinExpression) {
                for (PsiElement cur = this.getFirstChild(); cur != null && cur != lastParent; cur = cur.getNextSibling()) {
                    if (cur.processDeclarations(processor, state, lastParent, place)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClauseTypeVariables(PsiElement clause, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        PsiFile file = place.getContainingFile();
        Language language = file.getLanguage();
        Project project = file.getProject();
        for (PsiElement cur = clause.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            QlReferenceExpression expression = null;
            if (cur instanceof QlReferenceExpression) {
                expression = (QlReferenceExpression)cur;
            } else if (cur instanceof QlAliasDefinition) {
                QlAliasDefinition aliasDefinition = (QlAliasDefinition)cur;
                if (!processor.execute((PsiElement)aliasDefinition, state)) {
                    return false;
                }
                if (language != JpqlLanguage.HQL) {
                    return true;
                }
                QlExpression aliasedExpression = aliasDefinition.getExpression();
                QlReferenceExpression qlReferenceExpression = expression = aliasedExpression instanceof QlReferenceExpression ? (QlReferenceExpression)aliasedExpression : null;
            }
            if (expression == null || QlReferenceImpl.processQualifierExpression(project, expression, processor, state, place)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getNode().getElementType().toString();
    }

    public static IElementType getFirstElementType(QlCompositeElement o) {
        return o.getFirstChild().getNode().getElementType();
    }

    @Nullable
    public static QlType getQlTypeByPsiType(@Nullable PsiType type) {
        PsiClassType classType;
        PsiClass psiClass;
        QlType componentType;
        if (type == null) {
            return null;
        }
        if (type == QlPsiImplUtil.PACKAGE_TYPE) {
            return QlType.PACKAGE;
        }
        String text = type.getCanonicalText();
        if (STRING_DATATYPES.contains(text)) {
            return QlType.STRING;
        }
        if (NUMBER_DATATYPES.contains(text)) {
            return QlType.NUMBER;
        }
        if (BOOLEAN_DATATYPES.contains(text)) {
            return QlType.BOOLEAN;
        }
        if (DATETIME_DATATYPES.contains(text)) {
            return QlType.DATETIME;
        }
        if (type instanceof PsiArrayType && (componentType = QlCompositeElementImpl.getQlTypeByPsiType(((PsiArrayType)type).getComponentType())) != null) {
            return new QlIndexedCollectionType(QlType.NUMBER, componentType);
        }
        if (type instanceof PsiClassType && (psiClass = (classType = (PsiClassType)type).resolve()) != null) {
            QlType componentType2;
            QlType indexType;
            PsiTypeParameter[] typeParameters;
            QlType qlType;
            PsiTypeParameter[] typeParameters2;
            PsiManager manager = psiClass.getManager();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            PsiClass enumClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Enum", scope);
            if (enumClass != null && psiClass.isInheritor(enumClass, false)) {
                return new QlClassType(psiClass);
            }
            PsiClass listClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", scope);
            PsiSubstitutor substitutor = classType.resolveGenerics().getSubstitutor();
            if (listClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)listClass, (boolean)true) && (typeParameters2 = listClass.getTypeParameters()).length == 1 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)listClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor)) != null && (qlType = QlCompositeElementImpl.getQlTypeByPsiType(substitutor.substitute(typeParameters2[0]))) != null) {
                return new QlIndexedCollectionType(QlType.NUMBER, qlType);
            }
            PsiClass collectionClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Collection", scope);
            if (collectionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)collectionClass, (boolean)true)) {
                QlType qlType2;
                PsiTypeParameter[] typeParameters3 = collectionClass.getTypeParameters();
                if (typeParameters3.length == 1 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor)) != null && (qlType2 = QlCompositeElementImpl.getQlTypeByPsiType(substitutor.substitute(typeParameters3[0]))) != null) {
                    return new QlIndexedCollectionType(QlType.NUMBER, qlType2);
                }
                return QlType.COLLECTION;
            }
            PsiClass mapClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", scope);
            if (mapClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)mapClass, (boolean)true) && (typeParameters = mapClass.getTypeParameters()).length == 2 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)mapClass, (PsiClass)psiClass, (PsiSubstitutor)substitutor)) != null && (indexType = QlCompositeElementImpl.getQlTypeByPsiType(substitutor.substitute(typeParameters[0]))) != null && (componentType2 = QlCompositeElementImpl.getQlTypeByPsiType(substitutor.substitute(typeParameters[1]))) != null) {
                return new QlIndexedCollectionType(indexType, componentType2);
            }
            return new QlClassType(psiClass);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/ql/psi/impl/QlCompositeElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

