package com.intellij.thymeleaf.spring.security.springSecurity3;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.beans.AbstractThymeleafDialect;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import org.jetbrains.annotations.NotNull;

final class ThymeleafSpringSecurityDialect3 extends AbstractThymeleafDialect {
  ThymeleafSpringSecurityDialect3() {
    super(ThymeleafSpringSecurityDialect3.class.getResource("Spring-Security-Dialect.xml"));
  }

  @Override
  public boolean isSupported(@NotNull Project project) {
    return JavaPsiFacade.getInstance(project).findPackage("org.thymeleaf.extras.springsecurity3") != null;
  }

  @Override
  public String[] getNamespaces() {
    return ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_3_URIS;
  }

  @Override
  public ThymeleafLanguage getLanguage() {
    return ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS;
  }
}
