PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE `migrations` (`id` text,PRIMARY KEY (`id`));
INSERT INTO migrations VALUES('202312101416');
INSERT INTO migrations VALUES('202312101430');
INSERT INTO migrations VALUES('202402151347');
INSERT INTO migrations VALUES('2024041121742');
INSERT INTO migrations VALUES('202406021630');
CREATE TABLE `users` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`name` text,CONSTRAINT `uni_users_name` UNIQUE (`name`));
INSERT INTO users VALUES(1,'2024-09-27 14:12:26.861201+02:00','2024-09-27 14:12:26.861201+02:00',NULL,'kratest');
INSERT INTO users VALUES(2,'2024-09-27 14:12:33.550973+02:00','2024-09-27 14:12:33.550973+02:00',NULL,'testkra');
CREATE TABLE `pre_auth_keys` (`id` integer PRIMARY KEY AUTOINCREMENT,`key` text,`user_id` integer,`reusable` numeric,`ephemeral` numeric DEFAULT false,`used` numeric DEFAULT false,`created_at` datetime,`expiration` datetime,CONSTRAINT `fk_pre_auth_keys_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE);
INSERT INTO pre_auth_keys VALUES(1,'09b28f8c3351984874d46dace0a70177a8721933a950b663',1,0,0,0,'2024-09-27 12:12:38.242797+00:00','2024-09-27 13:12:38.241063+00:00');
INSERT INTO pre_auth_keys VALUES(2,'3112b953cb344191b2d5aec1b891250125bf7b437eac5d26',1,0,0,0,'2024-09-27 12:12:55.365396+00:00','2024-09-27 13:12:55.363595+00:00');
INSERT INTO pre_auth_keys VALUES(3,'7c23b9f215961e7609527aef78bf82fb19064b002d78c36f',1,0,0,0,'2024-09-27 12:13:32.99926+00:00','2024-09-27 13:13:32.997848+00:00');
INSERT INTO pre_auth_keys VALUES(4,'f2015583852b725220cc4b107fb288a4cf7ac259bd458a32',2,0,0,0,'2024-09-27 12:14:52.719795+00:00','2024-09-27 13:14:52.717783+00:00');
INSERT INTO pre_auth_keys VALUES(5,'b212b990165e897944dd3772786544402729fb349da50f57',2,0,0,0,'2024-09-27 12:15:06.869006+00:00','2024-09-27 13:15:06.86619+00:00');
CREATE TABLE `routes` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`node_id` integer,`prefix` text,`advertised` numeric,`enabled` numeric,`is_primary` numeric,CONSTRAINT `fk_nodes_routes` FOREIGN KEY (`node_id`) REFERENCES `nodes`(`id`) ON DELETE CASCADE);
CREATE TABLE `pre_auth_key_acl_tags` (`id` integer PRIMARY KEY AUTOINCREMENT,`pre_auth_key_id` integer,`tag` text,CONSTRAINT `fk_pre_auth_keys_acl_tags` FOREIGN KEY (`pre_auth_key_id`) REFERENCES `pre_auth_keys`(`id`) ON DELETE CASCADE);
INSERT INTO pre_auth_key_acl_tags VALUES(1,1,'tag:derp');
INSERT INTO pre_auth_key_acl_tags VALUES(2,2,'tag:derp');
INSERT INTO pre_auth_key_acl_tags VALUES(3,3,'tag:derp');
INSERT INTO pre_auth_key_acl_tags VALUES(4,3,'tag:merp');
INSERT INTO pre_auth_key_acl_tags VALUES(5,4,'tag:test');
INSERT INTO pre_auth_key_acl_tags VALUES(6,5,'tag:test');
INSERT INTO pre_auth_key_acl_tags VALUES(7,5,'tag:woop');
INSERT INTO pre_auth_key_acl_tags VALUES(8,5,'tag:dedu');
CREATE TABLE `api_keys` (`id` integer PRIMARY KEY AUTOINCREMENT,`prefix` text,`hash` blob,`created_at` datetime,`expiration` datetime,`last_seen` datetime);
CREATE TABLE IF NOT EXISTS "nodes"  (`id` integer PRIMARY KEY AUTOINCREMENT,`machine_key` text,`node_key` text,`disco_key` text,`endpoints` text,`host_info` text,`ipv4` text,`ipv6` text,`hostname` text,`given_name` varchar(63),`user_id` integer,`register_method` text,`forced_tags` text,`auth_key_id` integer,`last_seen` datetime,`expiry` datetime,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,CONSTRAINT `fk_nodes_user` FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,CONSTRAINT `fk_nodes_auth_key` FOREIGN KEY (`auth_key_id`) REFERENCES `pre_auth_keys`(`id`) ON DELETE SET NULL);
CREATE TABLE `policies` (`id` integer PRIMARY KEY AUTOINCREMENT,`created_at` datetime,`updated_at` datetime,`deleted_at` datetime,`data` text);
DELETE FROM sqlite_sequence;
INSERT INTO sqlite_sequence VALUES('nodes',0);
INSERT INTO sqlite_sequence VALUES('users',2);
INSERT INTO sqlite_sequence VALUES('pre_auth_keys',5);
INSERT INTO sqlite_sequence VALUES('pre_auth_key_acl_tags',8);
CREATE INDEX `idx_users_deleted_at` ON `users`(`deleted_at`);
CREATE INDEX `idx_routes_deleted_at` ON `routes`(`deleted_at`);
CREATE UNIQUE INDEX `idx_api_keys_prefix` ON `api_keys`(`prefix`);
CREATE INDEX `idx_policies_deleted_at` ON `policies`(`deleted_at`);
COMMIT;
