/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config.gpg;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import git4idea.config.HasGitRootsPredicate;
import git4idea.config.gpg.GitGpgConfigDialog;
import git4idea.config.gpg.GitGpgMultiRootConfigDialog;
import git4idea.config.gpg.GpgKey;
import git4idea.config.gpg.RepoConfig;
import git4idea.config.gpg.RepoConfigValue;
import git4idea.config.gpg.SecretKeys;
import git4idea.config.gpg.SecretKeysValue;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitConfigListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u001eH\u0002J\r\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgit4idea/config/gpg/GpgSignConfigurableRow;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "statusLabel", "Ljavax/swing/JLabel;", "errorLabel", "alarm", "Lcom/intellij/util/Alarm;", "uiDispatcher", "Lkotlin/coroutines/CoroutineContext;", "getUiDispatcher", "()Lkotlin/coroutines/CoroutineContext;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "secretKeys", "Lgit4idea/config/gpg/SecretKeysValue;", "repoConfigs", "", "Lgit4idea/repo/GitRepository;", "Lgit4idea/config/gpg/RepoConfigValue;", "createRow", "", "Lcom/intellij/ui/dsl/builder/Panel;", "updatePresentation", "scheduleUpdate", "updateRepoList", "reloadConfigs", "reloadSecretKeys", "openGpgConfigureDialog", "getStatusLabelText", "", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGpgSignConfigurableRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpgSignConfigurableRow.kt\ngit4idea/config/gpg/GpgSignConfigurableRow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1#2:188\n1#2:199\n1617#3,9:189\n1869#3:198\n1870#3:200\n1626#3:201\n1563#3:202\n1634#3,3:203\n774#3:206\n865#3,2:207\n1563#3:209\n1634#3,3:210\n1761#3,3:213\n*S KotlinDebug\n*F\n+ 1 GpgSignConfigurableRow.kt\ngit4idea/config/gpg/GpgSignConfigurableRow\n*L\n92#1:199\n92#1:189,9\n92#1:198\n92#1:200\n92#1:201\n153#1:202\n153#1:203,3\n160#1:206\n160#1:207,2\n161#1:209\n161#1:210,3\n162#1:213,3\n*E\n"})
public final class GpgSignConfigurableRow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JLabel statusLabel;
    @NotNull
    private final JLabel errorLabel;
    @NotNull
    private final Alarm alarm;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SecretKeysValue secretKeys;
    @NotNull
    private final Map<GitRepository, RepoConfigValue> repoConfigs;

    /*
     * WARNING - void declaration
     */
    public GpgSignConfigurableRow(@NotNull Project project, @NotNull Disposable disposable) {
        void it;
        JBLabel $this$errorLabel_u24lambda_u241;
        JBLabel $this$statusLabel_u24lambda_u240;
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.disposable = disposable;
        JBLabel jBLabel2 = jBLabel = new JBLabel();
        GpgSignConfigurableRow gpgSignConfigurableRow = this;
        boolean bl = false;
        $this$statusLabel_u24lambda_u240.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        $this$statusLabel_u24lambda_u240.putClientProperty((Object)SearchUtil.SEARCH_SKIP_COMPONENT_KEY, (Object)true);
        gpgSignConfigurableRow.statusLabel = (JLabel)jBLabel;
        $this$statusLabel_u24lambda_u240 = jBLabel = new JBLabel();
        gpgSignConfigurableRow = this;
        boolean bl2 = false;
        $this$errorLabel_u24lambda_u241.setForeground(NamedColorUtil.getErrorForeground());
        gpgSignConfigurableRow.errorLabel = (JLabel)jBLabel;
        this.alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, this.disposable);
        $this$errorLabel_u24lambda_u241 = jBLabel = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        gpgSignConfigurableRow = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this.disposable, () -> GpgSignConfigurableRow.scope$lambda$3$lambda$2((CoroutineScope)it));
        gpgSignConfigurableRow.scope = jBLabel;
        this.secretKeys = new SecretKeysValue(this.project);
        this.repoConfigs = new LinkedHashMap();
        this.secretKeys.addListener((Function0<Unit>)((Function0)() -> GpgSignConfigurableRow._init_$lambda$4(this)));
        this.updatePresentation();
        MessageBusConnection connection = this.project.getMessageBus().connect(this.disposable);
        connection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> GpgSignConfigurableRow._init_$lambda$5(this));
        connection.subscribe(GitConfigListener.TOPIC, (Object)new GitConfigListener(){

            @Override
            public void notifyConfigChanged(GitRepository repository2) {
                Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
                this.scheduleUpdate();
            }
        });
        MessageBusConnection messageBusConnection2 = ApplicationKt.getApplication().getMessageBus().connect(this.disposable);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection2.subscribe(topic, () -> GpgSignConfigurableRow._init_$lambda$6(this));
        this.updateRepoList();
        this.reloadConfigs();
        this.reloadSecretKeys();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    private final CoroutineContext getUiDispatcher() {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        return coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
    }

    private final void createRow(Panel $this$createRow) {
        Panel.row$default((Panel)$this$createRow, null, arg_0 -> GpgSignConfigurableRow.createRow$lambda$8(this, arg_0), (int)1, null);
        $this$createRow.indent(arg_0 -> GpgSignConfigurableRow.createRow$lambda$10(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePresentation() {
        void $this$mapNotNullTo$iv$iv;
        this.statusLabel.setText(this.getStatusLabelText());
        Iterable $this$mapNotNull$iv = this.repoConfigs.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VcsException it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RepoConfigValue it = (RepoConfigValue)element$iv$iv;
            boolean bl2 = false;
            if (it.getError() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        VcsException vcsException = (VcsException)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        String error = vcsException != null ? vcsException.getMessage() : null;
        this.errorLabel.setVisible(error != null);
        this.errorLabel.setText(error);
    }

    private final void scheduleUpdate() {
        if (this.alarm.isDisposed()) {
            return;
        }
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(() -> GpgSignConfigurableRow.scheduleUpdate$lambda$12(this), 500, ModalityState.any());
    }

    private final void updateRepoList() {
        List<GitRepository> list = GitRepositoryManager.getInstance(this.project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        Set repositories = CollectionsKt.toSet((Iterable)list);
        Set toRemove = SetsKt.minus(this.repoConfigs.keySet(), (Iterable)repositories);
        for (GitRepository repo : toRemove) {
            this.repoConfigs.remove(repo);
        }
        for (GitRepository repository2 : repositories) {
            this.repoConfigs.computeIfAbsent(repository2, arg_0 -> GpgSignConfigurableRow.updateRepoList$lambda$16(arg_0 -> GpgSignConfigurableRow.updateRepoList$lambda$15(repository2, this, arg_0), arg_0));
        }
    }

    private final void reloadConfigs() {
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)this.getUiDispatcher().plus((CoroutineContext)new CoroutineName("GpgSignRowPanel - reload configs")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ GpgSignConfigurableRow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        repoConfigs = GpgSignConfigurableRow.access$getRepoConfigs$p(this.this$0).values();
                        var3_4 = repoConfigs.iterator();
lbl7:
                        // 3 sources

                        while (var3_4.hasNext()) {
                            config = (RepoConfigValue)var3_4.next();
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)repoConfigs);
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)config);
                            this.label = 1;
                            v0 = config.tryReload((Continuation)this);
                            if (v0 != var5_2) continue;
                            return var5_2;
                        }
                        break;
                    }
                    case 1: {
                        config = (RepoConfigValue)this.L$2;
                        var3_4 = (Iterator<V>)this.L$1;
                        repoConfigs = (Collection)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void reloadSecretKeys() {
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)this.getUiDispatcher().plus((CoroutineContext)new CoroutineName("GpgSignRowPanel - reload secret keys")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GpgSignConfigurableRow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GpgSignConfigurableRow.access$getSecretKeys$p(this.this$0).tryReload((Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void openGpgConfigureDialog() {
        List<GitRepository> list = GitRepositoryManager.getInstance(this.project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        List<GitRepository> repositories = list;
        if (repositories.isEmpty()) {
            return;
        }
        if (repositories.size() == 1) {
            GitRepository repository2 = (GitRepository)CollectionsKt.single(repositories);
            RepoConfigValue repoConfigValue = this.repoConfigs.get(repository2);
            if (repoConfigValue == null) {
                Intrinsics.checkNotNull((Object)repository2);
                repoConfigValue = new RepoConfigValue(repository2);
            }
            RepoConfigValue repoConfig = repoConfigValue;
            Intrinsics.checkNotNull((Object)repository2);
            new GitGpgConfigDialog(repository2, this.secretKeys, repoConfig).show();
        } else {
            new GitGpgMultiRootConfigDialog(this.project, this.secretKeys, this.repoConfigs).show();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStatusLabelText() {
        boolean bl;
        Set configuredKeys;
        List configuredRepos;
        int totalRepos;
        block11: {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this.repoConfigs.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                RepoConfigValue repoConfigValue = (RepoConfigValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add((RepoConfig)it.getValue());
            }
            List keys = (List)destination$iv$iv;
            if (keys.isEmpty()) {
                String string = GitBundle.message((String)"settings.label.sign.gpg.commits.no.roots.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            List loadedKeys = CollectionsKt.filterNotNull((Iterable)keys);
            if (loadedKeys.size() != keys.size()) {
                return "";
            }
            totalRepos = ((Collection)loadedKeys).size();
            Iterable $this$filter$iv = loadedKeys;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RepoConfig it = (RepoConfig)element$iv$iv;
                boolean bl3 = false;
                if (!(it.getKey() != null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            configuredRepos = (List)destination$iv$iv2;
            Iterable $this$map$iv2 = configuredRepos;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RepoConfig bl3 = (RepoConfig)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                GpgKey gpgKey = it.getKey();
                Intrinsics.checkNotNull((Object)gpgKey);
                collection.add(gpgKey);
            }
            configuredKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            Iterable $this$any$iv = loadedKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RepoConfig it = (RepoConfig)element$iv;
                    boolean bl5 = false;
                    if (!(it.getKey() == null)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        boolean hasNotConfigured = bl;
        if (configuredKeys.isEmpty()) {
            String string = GitBundle.message((String)"settings.label.sign.gpg.commits.not.configured.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (hasNotConfigured) {
            Object[] $i$f$any = new Object[]{configuredRepos.size(), totalRepos};
            String string = GitBundle.message((String)"settings.label.sign.gpg.commits.enabled.n.roots.of.m.text", (Object[])$i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (configuredKeys.size() > 1) {
            String string = GitBundle.message((String)"settings.label.sign.gpg.commits.enabled.different.keys.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        GpgKey key = (GpgKey)CollectionsKt.single((Iterable)configuredKeys);
        Object object = (SecretKeys)this.secretKeys.getValue();
        String description = object != null && (object = ((SecretKeys)object).getDescriptions()) != null ? (String)object.get(key) : null;
        String string = description;
        Object keyPresentation = string != null ? string + " (" + key.getId() + ")" : key.getId();
        Object[] objectArray = new Object[]{keyPresentation};
        String string2 = GitBundle.message((String)"settings.label.sign.gpg.commits.enabled.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private static final void scope$lambda$3$lambda$2(CoroutineScope $it) {
        CoroutineScopeKt.cancel$default((CoroutineScope)$it, null, (int)1, null);
    }

    private static final Unit _init_$lambda$4(GpgSignConfigurableRow this$0) {
        this$0.updatePresentation();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$5(GpgSignConfigurableRow this$0) {
        this$0.scheduleUpdate();
    }

    private static final void _init_$lambda$6(GpgSignConfigurableRow this$0) {
        this$0.scheduleUpdate();
    }

    private static final Unit createRow$lambda$8$lambda$7(GpgSignConfigurableRow this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.openGpgConfigureDialog();
        return Unit.INSTANCE;
    }

    private static final Unit createRow$lambda$8(GpgSignConfigurableRow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GitBundle.message((String)"settings.sign.gpg.configure.link.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> GpgSignConfigurableRow.createRow$lambda$8$lambda$7(this$0, arg_0)).enabledIf((ComponentPredicate)new HasGitRootsPredicate(this$0.project, this$0.disposable));
        $this$row.cell((JComponent)this$0.statusLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createRow$lambda$10$lambda$9(GpgSignConfigurableRow this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.errorLabel);
        return Unit.INSTANCE;
    }

    private static final Unit createRow$lambda$10(GpgSignConfigurableRow this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> GpgSignConfigurableRow.createRow$lambda$10$lambda$9(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void scheduleUpdate$lambda$12(GpgSignConfigurableRow this$0) {
        this$0.updateRepoList();
        this$0.reloadConfigs();
        this$0.reloadSecretKeys();
    }

    private static final Unit updateRepoList$lambda$15$lambda$14$lambda$13(GpgSignConfigurableRow this$0) {
        this$0.updatePresentation();
        return Unit.INSTANCE;
    }

    private static final RepoConfigValue updateRepoList$lambda$15(GitRepository $repository, GpgSignConfigurableRow this$0, GitRepository it) {
        RepoConfigValue repoConfigValue;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$repository);
        RepoConfigValue it2 = repoConfigValue = new RepoConfigValue($repository);
        boolean bl = false;
        it2.addListener((Function0<Unit>)((Function0)() -> GpgSignConfigurableRow.updateRepoList$lambda$15$lambda$14$lambda$13(this$0)));
        return repoConfigValue;
    }

    private static final RepoConfigValue updateRepoList$lambda$16(Function1 $tmp0, Object p0) {
        return (RepoConfigValue)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getRepoConfigs$p(GpgSignConfigurableRow $this) {
        return $this.repoConfigs;
    }

    public static final /* synthetic */ SecretKeysValue access$getSecretKeys$p(GpgSignConfigurableRow $this) {
        return $this.secretKeys;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/config/gpg/GpgSignConfigurableRow$Companion;", "", "<init>", "()V", "createGpgSignRow", "", "Lcom/intellij/ui/dsl/builder/Panel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public final void createGpgSignRow(@NotNull Panel $this$createGpgSignRow, @NotNull Project project, @NotNull Disposable disposable) {
            GpgSignConfigurableRow panel2;
            Intrinsics.checkNotNullParameter((Object)$this$createGpgSignRow, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            GpgSignConfigurableRow $this$createGpgSignRow_u24lambda_u240 = panel2 = new GpgSignConfigurableRow(project, disposable);
            boolean bl = false;
            $this$createGpgSignRow_u24lambda_u240.createRow($this$createGpgSignRow);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

