/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.util;

import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.jupyter.diff.util.JupyterDiffDrawUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil;", "", "<init>", "()V", "paintPolygons", "", "gg", "Ljava/awt/Graphics2D;", "width", "", "editor1", "Lcom/intellij/openapi/editor/Editor;", "editor2", "paintable", "Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable;", "curved", "", "jupyterCreateVisiblePolygons", "", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon;", "paintedArea", "Ljava/awt/Rectangle;", "JupyterDividerPaintable", "JupyterDividerPaintableHandlerImpl", "intellij.jupyter.diff"})
public final class JupyterDiffDividerDrawUtil {
    @NotNull
    public static final JupyterDiffDividerDrawUtil INSTANCE = new JupyterDiffDividerDrawUtil();

    private JupyterDiffDividerDrawUtil() {
    }

    public final void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull JupyterDividerPaintable paintable) {
        Intrinsics.checkNotNullParameter((Object)gg, (String)"gg");
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter((Object)paintable, (String)"paintable");
        this.paintPolygons(gg, width, true, editor1, editor2, paintable);
    }

    private final void paintPolygons(Graphics2D gg, int width, boolean curved, Editor editor1, Editor editor2, JupyterDividerPaintable paintable) {
        ReadAction.run(() -> JupyterDiffDividerDrawUtil.paintPolygons$lambda$0(editor1, editor2, paintable, gg, width, curved));
    }

    private final List<DiffDividerDrawUtil.DividerPolygon> jupyterCreateVisiblePolygons(Editor editor1, Editor editor2, JupyterDividerPaintable paintable, Rectangle paintedArea) {
        if (editor1.isDisposed() || editor2.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        JupyterDividerPaintableHandlerImpl handler = new JupyterDividerPaintableHandlerImpl(editor1, editor2, paintedArea);
        paintable.process(handler);
        return handler.getPolygons();
    }

    private static final void paintPolygons$lambda$0(Editor $editor1, Editor $editor2, JupyterDividerPaintable $paintable, Graphics2D $gg, int $width, boolean $curved) {
        Rectangle rectangle = $gg.getClipBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getClipBounds(...)");
        List<DiffDividerDrawUtil.DividerPolygon> polygons = INSTANCE.jupyterCreateVisiblePolygons($editor1, $editor2, $paintable, rectangle);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)$gg);
        for (DiffDividerDrawUtil.DividerPolygon polygon : polygons) {
            polygon.paint($gg, $width, $curved);
        }
        config.restore();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable;", "", "process", "", "handler", "Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable$Handler;", "Handler", "intellij.jupyter.diff"})
    public static interface JupyterDividerPaintable {
        public void process(@NotNull Handler var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&J8\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H&J@\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H&J0\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable$Handler;", "", "process", "", "startLine1", "", "endLine1", "startLine2", "endLine2", "type", "Lcom/intellij/diff/util/TextDiffType;", "processResolvable", "resolved", "processExcludable", "excluded", "skipped", "processAligned", "intellij.jupyter.diff"})
        public static interface Handler {
            public boolean process(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5);

            public boolean processResolvable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6);

            public boolean processExcludable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6, boolean var7);

            public boolean processAligned(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J8\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J@\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0016J0\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J>\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\n\u0010\"\u001a\u00060#j\u0002`$2\b\b\u0002\u0010%\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintableHandlerImpl;", "Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintable$Handler;", "myEditor1", "Lcom/intellij/openapi/editor/Editor;", "myEditor2", "paintedArea", "Ljava/awt/Rectangle;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/editor/Editor;Ljava/awt/Rectangle;)V", "paintedYRange", "Lcom/intellij/util/IntPair;", "myLeftInterval", "Lcom/intellij/diff/util/LineRange;", "myRightInterval", "polygons", "", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon;", "getPolygons", "()Ljava/util/List;", "process", "", "startLine1", "", "endLine1", "startLine2", "endLine2", "type", "Lcom/intellij/diff/util/TextDiffType;", "processResolvable", "resolved", "processExcludable", "excluded", "skipped", "processAligned", "painter", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$Painter;", "Lcom/intellij/jupyter/diff/util/PainterAlias;", "withAlignedHeight", "Companion", "intellij.jupyter.diff"})
    public static final class JupyterDividerPaintableHandlerImpl
    implements JupyterDividerPaintable.Handler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Editor myEditor1;
        @NotNull
        private final Editor myEditor2;
        @NotNull
        private final IntPair paintedYRange;
        @NotNull
        private final LineRange myLeftInterval;
        @NotNull
        private final LineRange myRightInterval;
        @NotNull
        private final List<DiffDividerDrawUtil.DividerPolygon> polygons;

        public JupyterDividerPaintableHandlerImpl(@NotNull Editor myEditor1, @NotNull Editor myEditor2, @NotNull Rectangle paintedArea) {
            Intrinsics.checkNotNullParameter((Object)myEditor1, (String)"myEditor1");
            Intrinsics.checkNotNullParameter((Object)myEditor2, (String)"myEditor2");
            Intrinsics.checkNotNullParameter((Object)paintedArea, (String)"paintedArea");
            this.myEditor1 = myEditor1;
            this.myEditor2 = myEditor2;
            this.paintedYRange = new IntPair(paintedArea.y, paintedArea.y + paintedArea.height);
            LineRange lineRange = DiffDividerDrawUtil.getPaintedInterval((Editor)this.myEditor1, (IntPair)this.paintedYRange);
            Intrinsics.checkNotNullExpressionValue((Object)lineRange, (String)"getPaintedInterval(...)");
            this.myLeftInterval = lineRange;
            LineRange lineRange2 = DiffDividerDrawUtil.getPaintedInterval((Editor)this.myEditor2, (IntPair)this.paintedYRange);
            Intrinsics.checkNotNullExpressionValue((Object)lineRange2, (String)"getPaintedInterval(...)");
            this.myRightInterval = lineRange2;
            this.polygons = new ArrayList();
        }

        @NotNull
        public final List<DiffDividerDrawUtil.DividerPolygon> getPolygons() {
            return this.polygons;
        }

        @Override
        public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            DiffDividerDrawUtil.DividerPaintableHandlerImpl.DefaultPainter defaultPainter = new DiffDividerDrawUtil.DividerPaintableHandlerImpl.DefaultPainter(type);
            return JupyterDividerPaintableHandlerImpl.process$default(this, startLine1, endLine1, startLine2, endLine2, (DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter)defaultPainter, false, 32, null);
        }

        @Override
        public boolean processResolvable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean resolved) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            DiffDividerDrawUtil.DividerPaintableHandlerImpl.ResolvablePainter resolvablePainter = new DiffDividerDrawUtil.DividerPaintableHandlerImpl.ResolvablePainter(type, resolved);
            return JupyterDividerPaintableHandlerImpl.process$default(this, startLine1, endLine1, startLine2, endLine2, (DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter)resolvablePainter, false, 32, null);
        }

        @Override
        public boolean processExcludable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean excluded, boolean skipped) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            DiffDividerDrawUtil.DividerPaintableHandlerImpl.ExcludablePainter excludablePainter = new DiffDividerDrawUtil.DividerPaintableHandlerImpl.ExcludablePainter(type, excluded, skipped);
            return JupyterDividerPaintableHandlerImpl.process$default(this, startLine1, endLine1, startLine2, endLine2, (DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter)excludablePainter, false, 32, null);
        }

        @Override
        public boolean processAligned(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (type == TextDiffType.INSERTED || type == TextDiffType.DELETED) {
                DiffDividerDrawUtil.DividerPaintableHandlerImpl.DefaultPainter defaultPainter = new DiffDividerDrawUtil.DividerPaintableHandlerImpl.DefaultPainter(type);
                bl = this.process(startLine1, endLine1, startLine2, endLine2, (DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter)defaultPainter, true);
            } else {
                bl = this.process(startLine1, endLine1, startLine2, endLine2, type);
            }
            return bl;
        }

        private final boolean process(int startLine1, int endLine1, int startLine2, int endLine2, DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter painter, boolean withAlignedHeight) {
            if (this.myLeftInterval.start > endLine1 && this.myRightInterval.start > endLine2) {
                return true;
            }
            if (this.myLeftInterval.end < startLine1 && this.myRightInterval.end < startLine2) {
                return false;
            }
            DiffDividerDrawUtil.DividerPolygon polygon = JupyterDividerPaintableHandlerImpl.Companion.createPolygon(this.myEditor1, this.myEditor2, startLine1, endLine1, startLine2, endLine2, painter);
            if (withAlignedHeight && polygon != null) {
                polygon = polygon.withAlignedHeight();
            }
            ContainerUtil.addIfNotNull((Collection)this.polygons, (Object)polygon);
            return true;
        }

        static /* synthetic */ boolean process$default(JupyterDividerPaintableHandlerImpl jupyterDividerPaintableHandlerImpl, int n, int n2, int n3, int n4, DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter painter, boolean bl, int n5, Object object) {
            if ((n5 & 0x20) != 0) {
                bl = false;
            }
            return jupyterDividerPaintableHandlerImpl.process(n, n2, n3, n4, painter, bl);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/diff/util/JupyterDiffDividerDrawUtil$JupyterDividerPaintableHandlerImpl$Companion;", "", "<init>", "()V", "createPolygon", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon;", "editor1", "Lcom/intellij/openapi/editor/Editor;", "editor2", "startLine1", "", "endLine1", "startLine2", "endLine2", "painter", "Lcom/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$Painter;", "Lcom/intellij/jupyter/diff/util/PainterAlias;", "intellij.jupyter.diff"})
        public static final class Companion {
            private Companion() {
            }

            private final DiffDividerDrawUtil.DividerPolygon createPolygon(Editor editor1, Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, DiffDividerDrawUtil.DividerPaintableHandlerImpl.Painter painter) {
                boolean isFolded;
                int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset((Editor)editor1);
                int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset((Editor)editor2);
                boolean isFolded1 = DiffDividerDrawUtil.isIntervalFolded((Editor)editor1, (int)startLine1, (int)endLine1);
                boolean isFolded2 = DiffDividerDrawUtil.isIntervalFolded((Editor)editor2, (int)startLine2, (int)endLine2);
                boolean bl = isFolded = isFolded1 && isFolded2;
                if (isFolded && !painter.isAlwaysVisible()) {
                    return null;
                }
                DiffDrawUtil.MarkerRange range1 = JupyterDiffDrawUtil.INSTANCE.getGutterMarkerPaintRange(editor1, startLine1, endLine1);
                DiffDrawUtil.MarkerRange range2 = JupyterDiffDrawUtil.INSTANCE.getGutterMarkerPaintRange(editor2, startLine2, endLine2);
                return new DiffDividerDrawUtil.DividerPolygon(range1.y1 + topOffset1, range2.y1 + topOffset2, range1.y2 + topOffset1, range2.y2 + topOffset2, painter.getFillColor(editor2, isFolded), painter.getBorderColor(editor2, isFolded), painter.isDottedBorder());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

