/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.completion.PyStringFormatCompletionContributor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLiteralPattern;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyFStringLikeCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final PsiElementPattern.Capture<PyPlainStringElement> APPLICABLE_STRING_ELEMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyPlainStringElement.class).withParent(PyStringLiteralExpression.class)).andNot((ElementPattern)PlatformPatterns.psiElement().withSuperParent(2, PyLiteralPattern.class))).andNot((ElementPattern)PlatformPatterns.psiElement().inside(PyStringFormatCompletionContributor.FORMAT_STRING_CAPTURE));

    public PyFStringLikeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)APPLICABLE_STRING_ELEMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                boolean prefixCannotStartReference;
                boolean autoPopupAfterOpeningBrace;
                int stringElemStart;
                int offset;
                int relOffset;
                PyPlainStringElement stringElem;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((stringElem = PyUtil.as(parameters.getPosition(), PyPlainStringElement.class)) == null || stringElem.isBytes() || stringElem.isUnicode()) {
                    return;
                }
                if (LanguageLevel.forElement((PsiElement)stringElem).isOlderThan(LanguageLevel.PYTHON36)) {
                    return;
                }
                PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)stringElem.getParent();
                boolean templateStringExpected = PyFStringLikeCompletionContributor.isTemplateStringExpected(stringLiteral);
                if (templateStringExpected && LanguageLevel.forElement((PsiElement)stringElem).isOlderThan(LanguageLevel.PYTHON314)) {
                    return;
                }
                final String newPrefixChar = templateStringExpected ? "t" : "f";
                String stringElemText = stringElem.getText();
                int braceOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)stringElemText, (int)((relOffset = (offset = parameters.getOffset()) - (stringElemStart = stringElem.getTextRange().getStartOffset())) - 1), (String)"{");
                if (braceOffset < 0) {
                    return;
                }
                String completionPrefix = stringElemText.substring(braceOffset + 1, relOffset);
                boolean bl = autoPopupAfterOpeningBrace = completionPrefix.isEmpty() && parameters.isAutoPopup();
                if (autoPopupAfterOpeningBrace) {
                    return;
                }
                boolean bl2 = prefixCannotStartReference = !completionPrefix.isEmpty() && !PyNames.isIdentifier((String)completionPrefix);
                if (prefixCannotStartReference) {
                    return;
                }
                String fStringText = new StringBuilder().append(newPrefixChar).append(stringElemText).insert(relOffset + 1 + "IntellijIdeaRulezzz ".length(), "} ").toString();
                PyExpression fString = PyUtil.createExpressionFromFragment(fStringText, stringLiteral.getParent());
                assert (fString != null);
                PsiReference reference = fString.findReferenceAt(relOffset + 1);
                if (reference == null) {
                    return;
                }
                @NotNull List fStringVariants = ContainerUtil.mapNotNull((Object[])reference.getVariants(), v -> PyUtil.as(v, LookupElement.class));
                if (fStringVariants.isEmpty()) {
                    return;
                }
                CompletionResultSet prefixPatchedResultSet = result2.withPrefixMatcher(completionPrefix);
                for (LookupElement variant : fStringVariants) {
                    prefixPatchedResultSet.addElement((LookupElement)new LookupElementDecorator<LookupElement>(variant){

                        public void handleInsert(@NotNull InsertionContext context) {
                            String stringElemPrefix;
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.handleInsert(context);
                            Document document = context.getDocument();
                            CharSequence docChars = document.getCharsSequence();
                            int tailOffset = context.getTailOffset();
                            if (tailOffset >= document.getTextLength() || docChars.charAt(tailOffset) != '}') {
                                document.insertString(tailOffset, (CharSequence)"}");
                            }
                            if (!StringUtil.containsIgnoreCase((String)(stringElemPrefix = PyStringLiteralCoreUtil.getPrefix((CharSequence)docChars, (int)stringElemStart)), (String)newPrefixChar)) {
                                document.insertString(stringElemStart, (CharSequence)newPrefixChar);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor$1$1", "handleInsert"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isTemplateStringExpected(@NotNull PyStringLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(0);
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(stringLiteral.getProject(), stringLiteral.getContainingFile());
        PyPsiFacade psiFacade = PyPsiFacade.getInstance(stringLiteral.getProject());
        PyClass templateClass = psiFacade.createClassByQName("string.templatelib.Template", (PsiElement)stringLiteral);
        if (templateClass == null) {
            return false;
        }
        PyClassType templateType = psiFacade.createClassType(templateClass, false);
        return PyFStringLikeCompletionContributor.isArgumentOfFunctionExpectingTemplateString(stringLiteral, templateType, typeEvalContext) || PyFStringLikeCompletionContributor.isAssignedToVariableExpectingTemplateString(stringLiteral, templateType, typeEvalContext);
    }

    private static boolean isAssignedToVariableExpectingTemplateString(@NotNull PyStringLiteralExpression literal, @NotNull PyClassType templateType, @NotNull TypeEvalContext typeEvalContext) {
        Object object;
        PsiElement unpackedValueParent;
        if (literal == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(1);
        }
        if (templateType == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(2);
        }
        if (typeEvalContext == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(3);
        }
        if (!((unpackedValueParent = PsiTreeUtil.skipParentsOfType((PsiElement)literal, (Class[])new Class[]{PyParenthesizedExpression.class, PyTupleExpression.class})) instanceof PyAssignmentStatement)) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)unpackedValueParent;
        List<Pair<PyExpression, PyExpression>> mapping = assignment.getTargetsToValuesMapping();
        Pair matchingPair = (Pair)ContainerUtil.find(mapping, pair -> pair.getSecond() == literal);
        if (matchingPair == null || !((object = matchingPair.getFirst()) instanceof PyTargetExpression)) {
            return false;
        }
        PyTargetExpression target = (PyTargetExpression)object;
        return templateType.equals(typeEvalContext.getType(target));
    }

    private static boolean isArgumentOfFunctionExpectingTemplateString(@NotNull PyStringLiteralExpression stringLiteral, @NotNull PyClassType templateType, @NotNull TypeEvalContext typeEvalContext) {
        PyArgumentList argumentList;
        PyExpression pyExpression;
        PsiElement psiElement;
        if (stringLiteral == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(4);
        }
        if (templateType == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(5);
        }
        if (typeEvalContext == null) {
            PyFStringLikeCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((psiElement = stringLiteral.getParent()) instanceof PyKeywordArgument) {
            PyKeywordArgument kwArg = (PyKeywordArgument)psiElement;
            pyExpression = kwArg;
        } else {
            pyExpression = stringLiteral;
        }
        PyStringLiteralExpression callArgument = pyExpression;
        PsiElement psiElement2 = callArgument.getParent();
        if (!(psiElement2 instanceof PyArgumentList) || !((psiElement2 = (argumentList = (PyArgumentList)psiElement2).getParent()) instanceof PyCallExpression)) {
            return false;
        }
        PyCallExpression call = (PyCallExpression)psiElement2;
        return ContainerUtil.all(call.multiMapArguments(PyResolveContext.defaultContext(typeEvalContext)), arg_0 -> PyFStringLikeCompletionContributor.lambda$isArgumentOfFunctionExpectingTemplateString$1((PsiElement)callArgument, typeEvalContext, templateType, arg_0));
    }

    private static /* synthetic */ boolean lambda$isArgumentOfFunctionExpectingTemplateString$1(PsiElement callArgument, TypeEvalContext typeEvalContext, PyClassType templateType, PyCallExpression.PyArgumentsMapping mapping) {
        PyCollectionType dictType;
        PyTupleType tupleType;
        PyCallableParameter param = mapping.getMappedParameters().get(callArgument);
        if (param == null) {
            return false;
        }
        PyType paramType = param.getType(typeEvalContext);
        if (param.isPositionalContainer() && paramType instanceof PyTupleType && (tupleType = (PyTupleType)paramType).isHomogeneous()) {
            paramType = tupleType.getElementTypes().get(0);
        } else if (param.isKeywordContainer() && paramType instanceof PyCollectionType && "dict".equals((dictType = (PyCollectionType)paramType).getPyClass().getName())) {
            paramType = (PyType)ContainerUtil.getOrElse(dictType.getElementTypes(), (int)1, null);
        }
        return templateType.equals(paramType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyFStringLikeCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTemplateStringExpected";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignedToVariableExpectingTemplateString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isArgumentOfFunctionExpectingTemplateString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

