#
# This file is licensed under the Affero General Public License (AGPL) version 3.
#
#  Copyright 2022 The Matrix.org Foundation C.I.C.
# Copyright (C) 2023 New Vector, Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# See the GNU Affero General Public License for more details:
# <https://www.gnu.org/licenses/agpl-3.0.html>.
#
# Originally licensed under the Apache License, Version 2.0:
# <http://www.apache.org/licenses/LICENSE-2.0>.
#
# [This file includes modifications made by New Vector Limited]
#
#
from typing import Iterable, Mapping

# the type of the query params, to be passed into `urlencode` with `doseq=True`.
QueryParamValue = str | bytes | Iterable[str | bytes]
QueryParams = Mapping[str, QueryParamValue] | Mapping[bytes, QueryParamValue]

__all__ = ["QueryParams"]
