/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CompileTask
extends VMObject {
    private static AddressField methodField;
    private static CIntField osrBciField;
    private static CIntField compLevelField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CompileTask");
        methodField = type.getAddressField("_method");
        osrBciField = new CIntField(type.getCIntegerField("_osr_bci"), 0L);
        compLevelField = new CIntField(type.getCIntegerField("_comp_level"), 0L);
    }

    public CompileTask(Address addr) {
        super(addr);
    }

    public Method method() {
        Address oh = methodField.getValue(this.getAddress());
        return (Method)Metadata.instantiateWrapperFor(oh);
    }

    public int osrBci() {
        return (int)osrBciField.getValue(this.getAddress());
    }

    public int compLevel() {
        return (int)compLevelField.getValue(this.getAddress());
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CompileTask.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

