/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.selection;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.execution.ProjectSelectionException;
import org.gradle.execution.TaskSelection;
import org.gradle.execution.TaskSelectionException;
import org.gradle.execution.TaskSelector;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.util.Path;
import org.gradle.util.internal.NameMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildTaskSelector
implements BuildTaskSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildTaskSelector.class);
    private final BuildStateRegistry buildRegistry;
    private final TaskSelector taskSelector;
    private final List<BuiltInCommand> commands;
    private final InternalProblems problemsService;

    @Inject
    public DefaultBuildTaskSelector(BuildStateRegistry buildRegistry, TaskSelector taskSelector, List<BuiltInCommand> commands, InternalProblems problemsService) {
        this.buildRegistry = buildRegistry;
        this.taskSelector = taskSelector;
        this.commands = commands;
        this.problemsService = problemsService;
    }

    @Override
    public BuildTaskSelector.Filter resolveExcludedTaskName(BuildState defaultBuild, String taskName) {
        if (!defaultBuild.isProjectsCreated()) {
            return new BuildTaskSelector.Filter(defaultBuild, (Spec<Task>)Specs.satisfyNone());
        }
        TaskSelector.SelectionContext selection = this.sanityCheckPath(taskName, "excluded tasks");
        ProjectResolutionResult resolutionResult = this.resolveProject(selection, selection.getOriginalPath(), defaultBuild);
        return new BuildTaskSelector.Filter(resolutionResult.build, new LazyFilter(selection, resolutionResult));
    }

    @Override
    public TaskSelection resolveTaskName(@Nullable File rootDir, @Nullable String projectPath, BuildState targetBuild, String taskName) {
        TaskSelector.SelectionContext selection = this.sanityCheckPath(taskName, "tasks");
        BuildState defaultBuild = targetBuild;
        if (rootDir != null) {
            RootBuildState rootBuild = this.buildRegistry.getRootBuild();
            if (rootDir.equals(rootBuild.getBuildRootDir())) {
                defaultBuild = rootBuild;
            } else {
                BuildState build = this.findIncludedBuild(rootDir);
                if (build == null) {
                    throw new TaskSelectionException(String.format("Could not find included build with root directory '%s'.", rootDir));
                }
                defaultBuild = build;
            }
            if (projectPath != null) {
                ProjectState project = defaultBuild.getProjects().getProject(Path.path((String)projectPath));
                return this.getSelectorForBuild(defaultBuild).getSelection(selection, project, selection.getOriginalPath().getName(), true);
            }
            Path projectPrefix = selection.getOriginalPath().getParent();
            ProjectState project = defaultBuild.getProjects().getProject(projectPrefix);
            return this.getSelectorForBuild(defaultBuild).getSelection(selection, project, selection.getOriginalPath().getName(), false);
        }
        ProjectResolutionResult resolutionResult = this.resolveProject(selection, selection.getOriginalPath(), defaultBuild);
        return this.getSelectorForBuild(resolutionResult.build).getSelection(selection, resolutionResult.project, resolutionResult.taskName, resolutionResult.includeSubprojects);
    }

    @Override
    public BuildTaskSelector.BuildSpecificSelector relativeToBuild(BuildState target) {
        return taskName -> this.resolveTaskName(null, null, target, taskName);
    }

    private ProjectResolutionResult resolveProject(TaskSelector.SelectionContext context, Path path, BuildState targetBuild) {
        if (!path.isAbsolute() && path.segmentCount() == 1) {
            return new ProjectResolutionResult(targetBuild, targetBuild.getMutableModel().getDefaultProject().getOwner(), true, path.getName());
        }
        Path projectPath = path.getParent();
        ProjectState matchingProject = projectPath.isAbsolute() ? this.buildRegistry.getRootBuild().getProjects().getRootProject() : targetBuild.getMutableModel().getDefaultProject().getOwner();
        while (projectPath.segmentCount() > 0) {
            String next = projectPath.segment(0);
            matchingProject = this.selectProject(context, matchingProject, next);
            if (projectPath.segmentCount() == 1) {
                projectPath = Path.ROOT;
                continue;
            }
            projectPath = projectPath.removeFirstSegments(1);
        }
        LOGGER.info("Task path '{}' matched project '{}'", (Object)context.getOriginalPath(), (Object)matchingProject.getIdentityPath());
        return new ProjectResolutionResult(matchingProject.getOwner(), matchingProject, false, path.getName());
    }

    private ProjectState selectProject(TaskSelector.SelectionContext context, ProjectState project, String childName) {
        LinkedHashMap<String, ProjectState> candidates = new LinkedHashMap<String, ProjectState>();
        if (project.getProjectPath().equals((Object)Path.ROOT)) {
            this.buildRegistry.visitBuilds(build -> {
                ProjectState rootProject;
                Path rootProjectIdentityPath;
                Path buildIdentityPath;
                if (build.isImportableBuild() && build.isProjectsLoaded() && Objects.equals(buildIdentityPath = (rootProjectIdentityPath = (rootProject = build.getProjects().getRootProject()).getIdentityPath()).getParent(), project.getIdentityPath())) {
                    candidates.put(rootProjectIdentityPath.getName(), rootProject);
                }
            });
        }
        for (ProjectState child : project.getChildProjects()) {
            ProjectState previous = candidates.put(child.getIdentityPath().getName(), child);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate child project names for " + project.getDisplayName());
        }
        ProjectState child = (ProjectState)candidates.get(childName);
        if (child != null) {
            return child;
        }
        NameMatcher nameMatcher = new NameMatcher();
        child = (ProjectState)nameMatcher.find(childName, candidates);
        if (child != null) {
            return child;
        }
        throw this.problemsService.getInternalReporter().throwing(spec -> {
            nameMatcher.configureProblemId((ProblemSpec)spec);
            String message = String.format("Cannot locate %s that match '%s' as %s", context.getType(), context.getOriginalPath(), nameMatcher.formatErrorMessage("project", project.getDisplayName()));
            DefaultBuildTaskSelector.configureProblem(spec, message, context.getOriginalPath().getPath(), (RuntimeException)((Object)new ProjectSelectionException(message)));
        });
    }

    private static void configureProblem(ProblemSpec spec, String message, String requestedPath, RuntimeException e) {
        spec.contextualLabel(message);
        spec.severity(Severity.ERROR);
        ((InternalProblemSpec)spec).additionalData(GeneralDataSpec.class, data -> data.put("requestedPath", Objects.requireNonNull(requestedPath)));
        spec.withException((Throwable)e);
    }

    private TaskSelector.SelectionContext sanityCheckPath(String name, String type) {
        if (name.isEmpty() || StringUtils.isBlank((String)name)) {
            throw this.problemsService.getInternalReporter().throwing(spec -> {
                spec.id("empty-path", "Empty path", GradleCoreProblemGroup.taskSelection());
                String message = String.format("Cannot locate matching %s for an empty path. The path should include a task name (for example %s).", type, this.examplePaths());
                DefaultBuildTaskSelector.configureProblem(spec, message, name, (RuntimeException)((Object)new TaskSelectionException(message)));
            });
        }
        Path path = Path.path((String)name);
        Pattern root = Pattern.compile("\\s*:(\\s*:)*\\s*");
        if (root.matcher(name).matches()) {
            throw this.problemsService.getInternalReporter().throwing(spec -> {
                spec.id("missing-task-name", "Missing task name", GradleCoreProblemGroup.taskSelection());
                String message = String.format("Cannot locate %s that match '%s'. The path should include a task name (for example %s).", type, name, this.examplePaths());
                DefaultBuildTaskSelector.configureProblem(spec, message, name, (RuntimeException)((Object)new TaskSelectionException(message)));
            });
        }
        Pattern emptySegment = Pattern.compile("(:\\s*:)|(^\\s+:)|(:\\s*$)");
        if (emptySegment.matcher(name).find()) {
            Pattern emptyFirstSegment = Pattern.compile("^\\s*:");
            boolean isAbsolute = emptyFirstSegment.matcher(name).find();
            StringBuilder normalized = new StringBuilder();
            for (int i = 0; i < path.segmentCount(); ++i) {
                if (StringUtils.isBlank((String)path.segment(i))) continue;
                if (isAbsolute || normalized.length() > 0) {
                    normalized.append(":");
                }
                normalized.append(path.segment(i));
            }
            throw this.problemsService.getInternalReporter().throwing(spec -> {
                spec.id("empty-segments", "Empty segments", GradleCoreProblemGroup.taskSelection());
                String message = String.format("Cannot locate %s that match '%s'. The path should not include an empty segment (try '%s' instead).", type, name, normalized);
                DefaultBuildTaskSelector.configureProblem(spec, message, name, (RuntimeException)((Object)new TaskSelectionException(message)));
            });
        }
        return new TaskSelector.SelectionContext(path, type);
    }

    private String examplePaths() {
        for (BuiltInCommand command : this.commands) {
            if (command.asDefaultTask().isEmpty()) continue;
            String task = command.asDefaultTask().get(0);
            return String.format("':%s' or '%s'", task, task);
        }
        throw new IllegalStateException("No built-in tasks available.");
    }

    private BuildState findIncludedBuild(File rootDir) {
        for (IncludedBuildState includedBuildState : this.buildRegistry.getIncludedBuilds()) {
            if (!includedBuildState.getRootDirectory().equals(rootDir)) continue;
            return includedBuildState;
        }
        return null;
    }

    private TaskSelector getSelectorForBuild(BuildState target) {
        if (!(target instanceof RootBuildState)) {
            target.ensureProjectsConfigured();
        }
        return this.taskSelector;
    }

    private static class ProjectResolutionResult {
        final BuildState build;
        final ProjectState project;
        final boolean includeSubprojects;
        final String taskName;

        public ProjectResolutionResult(BuildState build, ProjectState project, boolean includeSubprojects, String taskName) {
            this.build = build;
            this.project = project;
            this.includeSubprojects = includeSubprojects;
            this.taskName = taskName;
        }
    }

    private class LazyFilter
    implements Spec<Task> {
        private final TaskSelector.SelectionContext selection;
        private final ProjectResolutionResult resolutionResult;
        private Spec<Task> spec;

        public LazyFilter(TaskSelector.SelectionContext selection, ProjectResolutionResult resolutionResult) {
            this.selection = selection;
            this.resolutionResult = resolutionResult;
        }

        public boolean isSatisfiedBy(Task element) {
            if (this.spec == null) {
                this.spec = DefaultBuildTaskSelector.this.getSelectorForBuild(this.resolutionResult.build).getFilter(this.selection, this.resolutionResult.project, this.resolutionResult.taskName, this.resolutionResult.includeSubprojects);
            }
            return this.spec.isSatisfiedBy((Object)element);
        }
    }
}

