/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.problems.internal.rendering.ProblemRenderer;

public class CompilationFailedException
extends RuntimeException
implements CompilationFailedIndicator {
    public static final String RESOLUTION_MESSAGE = "Check your code and dependencies to fix the compilation error(s)";
    public static final String COMPILATION_FAILED_DETAILS_ABOVE = "Compilation failed; see the compiler error output for details.";
    public static final String COMPILATION_FAILED_DETAILS_BELOW = "Compilation failed; see the compiler output below.";
    private final ApiCompilerResult compilerPartialResult;
    private final String diagnosticCounts;
    private final String shortMessage;

    public CompilationFailedException() {
        this((ApiCompilerResult)null);
    }

    public CompilationFailedException(int exitCode) {
        super(String.format("Compilation failed with exit code %d; see the compiler error output for details.", exitCode));
        this.compilerPartialResult = null;
        this.diagnosticCounts = null;
        this.shortMessage = this.getMessage();
    }

    public CompilationFailedException(Throwable cause) {
        super(cause);
        this.compilerPartialResult = null;
        this.diagnosticCounts = null;
        this.shortMessage = this.getMessage();
    }

    public CompilationFailedException(@Nullable ApiCompilerResult result) {
        super(COMPILATION_FAILED_DETAILS_ABOVE);
        this.compilerPartialResult = result;
        this.diagnosticCounts = null;
        this.shortMessage = this.getMessage();
    }

    CompilationFailedException(ApiCompilerResult result, List<Problem> reportedProblems, String diagnosticCounts) {
        super(CompilationFailedException.exceptionMessage(COMPILATION_FAILED_DETAILS_BELOW + System.lineSeparator(), reportedProblems, diagnosticCounts));
        this.compilerPartialResult = result;
        this.diagnosticCounts = diagnosticCounts;
        this.shortMessage = COMPILATION_FAILED_DETAILS_BELOW;
    }

    private static String exceptionMessage(String prefix, List<Problem> problems, String diagnosticCounts) {
        StringWriter result = new StringWriter();
        result.append(prefix);
        new ProblemRenderer((Writer)result).render(problems);
        result.append(System.lineSeparator());
        result.append(diagnosticCounts);
        return result.toString();
    }

    public Optional<ApiCompilerResult> getCompilerPartialResult() {
        return Optional.ofNullable(this.compilerPartialResult);
    }

    @Nullable
    public String getDiagnosticCounts() {
        return this.diagnosticCounts;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }
}

