/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.internal.preferences.IPropertyMapListener;

public final class PropertyListenerList {
    private Map<String, List<IPropertyMapListener>> listeners;
    private List<IPropertyMapListener> globalListeners;
    private static String[] singlePropertyDelta;
    private static Object mutex;

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String prefId) {
        String[] delta;
        Object object = mutex;
        synchronized (object) {
            if (singlePropertyDelta != null) {
                delta = singlePropertyDelta;
                singlePropertyDelta = null;
            } else {
                delta = new String[]{prefId};
            }
        }
        delta[0] = prefId;
        this.firePropertyChange(delta);
        if (singlePropertyDelta == null) {
            object = mutex;
            synchronized (object) {
                singlePropertyDelta = delta;
            }
        }
    }

    public void firePropertyChange(String[] propertyIds) {
        if (this.globalListeners != null) {
            for (IPropertyMapListener next : this.globalListeners) {
                next.propertyChanged(propertyIds);
            }
        }
        if (this.listeners != null) {
            Collection<Object> result = Collections.emptySet();
            HashSet union = null;
            String[] stringArray = propertyIds;
            int n = propertyIds.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                List<IPropertyMapListener> existingListeners = this.listeners.get(property);
                if (existingListeners != null) {
                    if (result.isEmpty()) {
                        result = existingListeners;
                    } else {
                        if (union == null) {
                            union = new HashSet();
                            union.addAll(result);
                            result = union;
                        }
                        union.addAll(existingListeners);
                    }
                }
                ++n2;
            }
            for (IPropertyMapListener next : result) {
                next.propertyChanged(propertyIds);
            }
        }
    }

    public void add(IPropertyMapListener newListener) {
        if (this.globalListeners == null) {
            this.globalListeners = new ArrayList<IPropertyMapListener>();
        }
        this.globalListeners.add(newListener);
        newListener.listenerAttached();
    }

    private void addInternal(String propertyId, IPropertyMapListener newListener) {
        List<IPropertyMapListener> listenerList;
        if (this.listeners == null) {
            this.listeners = new HashMap<String, List<IPropertyMapListener>>();
        }
        if ((listenerList = this.listeners.get(propertyId)) == null) {
            listenerList = new ArrayList<IPropertyMapListener>(1);
            this.listeners.put(propertyId, listenerList);
        }
        if (!listenerList.contains(newListener)) {
            listenerList.add(newListener);
        }
    }

    public void add(String[] propertyIds, IPropertyMapListener newListener) {
        String[] stringArray = propertyIds;
        int n = propertyIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.addInternal(id, newListener);
            ++n2;
        }
        newListener.listenerAttached();
    }

    public void remove(String propertyId, IPropertyMapListener toRemove) {
        if (this.listeners == null) {
            return;
        }
        List<IPropertyMapListener> listenerList = this.listeners.get(propertyId);
        if (listenerList != null) {
            listenerList.remove(toRemove);
            if (listenerList.isEmpty()) {
                this.listeners.remove(propertyId);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    public void removeAll() {
        this.globalListeners = null;
        this.listeners = null;
    }

    public void remove(IPropertyMapListener toRemove) {
        if (this.globalListeners != null) {
            this.globalListeners.remove(toRemove);
            if (this.globalListeners.isEmpty()) {
                this.globalListeners = null;
            }
        }
        if (this.listeners != null) {
            for (String key : this.listeners.keySet()) {
                this.remove(key, toRemove);
            }
        }
    }

    public boolean isEmpty() {
        return this.globalListeners == null && this.listeners == null;
    }
}

