// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbservice/node.proto

package pbservice

import (
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// IndexedCheckServiceNodes is used to return multiple instances for a given service.
type IndexedCheckServiceNodes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Index         uint64                 `protobuf:"varint,1,opt,name=Index,proto3" json:"Index,omitempty"`
	Nodes         []*CheckServiceNode    `protobuf:"bytes,2,rep,name=Nodes,proto3" json:"Nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IndexedCheckServiceNodes) Reset() {
	*x = IndexedCheckServiceNodes{}
	mi := &file_private_pbservice_node_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IndexedCheckServiceNodes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexedCheckServiceNodes) ProtoMessage() {}

func (x *IndexedCheckServiceNodes) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_node_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexedCheckServiceNodes.ProtoReflect.Descriptor instead.
func (*IndexedCheckServiceNodes) Descriptor() ([]byte, []int) {
	return file_private_pbservice_node_proto_rawDescGZIP(), []int{0}
}

func (x *IndexedCheckServiceNodes) GetIndex() uint64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *IndexedCheckServiceNodes) GetNodes() []*CheckServiceNode {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// CheckServiceNode is used to provide the node, its service
// definition, as well as a HealthCheck that is associated.
type CheckServiceNode struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Node          *Node                  `protobuf:"bytes,1,opt,name=Node,proto3" json:"Node,omitempty"`
	Service       *NodeService           `protobuf:"bytes,2,opt,name=Service,proto3" json:"Service,omitempty"`
	Checks        []*HealthCheck         `protobuf:"bytes,3,rep,name=Checks,proto3" json:"Checks,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckServiceNode) Reset() {
	*x = CheckServiceNode{}
	mi := &file_private_pbservice_node_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckServiceNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckServiceNode) ProtoMessage() {}

func (x *CheckServiceNode) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_node_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckServiceNode.ProtoReflect.Descriptor instead.
func (*CheckServiceNode) Descriptor() ([]byte, []int) {
	return file_private_pbservice_node_proto_rawDescGZIP(), []int{1}
}

func (x *CheckServiceNode) GetNode() *Node {
	if x != nil {
		return x.Node
	}
	return nil
}

func (x *CheckServiceNode) GetService() *NodeService {
	if x != nil {
		return x.Service
	}
	return nil
}

func (x *CheckServiceNode) GetChecks() []*HealthCheck {
	if x != nil {
		return x.Checks
	}
	return nil
}

// Node contains information about a node.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.Node
// output=node.gen.go
// name=Structs
type Node struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=NodeIDType func-from=string
	ID              string            `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Node            string            `protobuf:"bytes,2,opt,name=Node,proto3" json:"Node,omitempty"`
	Partition       string            `protobuf:"bytes,8,opt,name=Partition,proto3" json:"Partition,omitempty"`
	PeerName        string            `protobuf:"bytes,9,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	Address         string            `protobuf:"bytes,3,opt,name=Address,proto3" json:"Address,omitempty"`
	Datacenter      string            `protobuf:"bytes,4,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	TaggedAddresses map[string]string `protobuf:"bytes,5,rep,name=TaggedAddresses,proto3" json:"TaggedAddresses,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Meta            map[string]string `protobuf:"bytes,6,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// mog: func-to=RaftIndexToStructs func-from=NewRaftIndexFromStructs
	RaftIndex *pbcommon.RaftIndex `protobuf:"bytes,7,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	// Locality identifies where the node is running.
	// mog: func-to=LocalityToStructs func-from=LocalityFromStructs
	Locality      *pbcommon.Locality `protobuf:"bytes,10,opt,name=Locality,proto3" json:"Locality,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Node) Reset() {
	*x = Node{}
	mi := &file_private_pbservice_node_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_node_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_private_pbservice_node_proto_rawDescGZIP(), []int{2}
}

func (x *Node) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Node) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *Node) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *Node) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *Node) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Node) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *Node) GetTaggedAddresses() map[string]string {
	if x != nil {
		return x.TaggedAddresses
	}
	return nil
}

func (x *Node) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *Node) GetRaftIndex() *pbcommon.RaftIndex {
	if x != nil {
		return x.RaftIndex
	}
	return nil
}

func (x *Node) GetLocality() *pbcommon.Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

// NodeService is a service provided by a node
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.NodeService
// output=node.gen.go
// name=Structs
type NodeService struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Kind is the kind of service this is. Different kinds of services may
	// have differing validation, DNS behavior, etc. An empty kind will default
	// to the Default kind. See ServiceKind for the full list of kinds.
	// mog: func-to=structs.ServiceKind func-from=string
	Kind    string   `protobuf:"bytes,1,opt,name=Kind,proto3" json:"Kind,omitempty"`
	ID      string   `protobuf:"bytes,2,opt,name=ID,proto3" json:"ID,omitempty"`
	Service string   `protobuf:"bytes,3,opt,name=Service,proto3" json:"Service,omitempty"`
	Tags    []string `protobuf:"bytes,4,rep,name=Tags,proto3" json:"Tags,omitempty"`
	Address string   `protobuf:"bytes,5,opt,name=Address,proto3" json:"Address,omitempty"`
	// mog: func-to=MapStringServiceAddressToStructs func-from=NewMapStringServiceAddressFromStructs
	TaggedAddresses map[string]*ServiceAddress `protobuf:"bytes,15,rep,name=TaggedAddresses,proto3" json:"TaggedAddresses,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Meta            map[string]string          `protobuf:"bytes,6,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// mog: func-to=int func-from=int32
	Port       int32  `protobuf:"varint,7,opt,name=Port,proto3" json:"Port,omitempty"`
	SocketPath string `protobuf:"bytes,17,opt,name=SocketPath,proto3" json:"SocketPath,omitempty"`
	// mog: func-to=WeightsPtrToStructs func-from=NewWeightsPtrFromStructs
	Weights           *Weights `protobuf:"bytes,8,opt,name=Weights,proto3" json:"Weights,omitempty"`
	EnableTagOverride bool     `protobuf:"varint,9,opt,name=EnableTagOverride,proto3" json:"EnableTagOverride,omitempty"`
	// Proxy is the configuration set for Kind = connect-proxy. It is mandatory in
	// that case and an error to be set for any other kind. This config is part of
	// a proxy service definition and is distinct from but shares some fields with
	// the Connect.Proxy which configures a managed proxy as part of the actual
	// service's definition. This duplication is ugly but seemed better than the
	// alternative which was to re-use the same struct fields for both cases even
	// though the semantics are different and the non-shred fields make no sense
	// in the other case. ProxyConfig may be a more natural name here, but it's
	// confusing for the UX because one of the fields in ConnectProxyConfig is
	// also called just "Config"
	Proxy *ConnectProxyConfig `protobuf:"bytes,11,opt,name=Proxy,proto3" json:"Proxy,omitempty"`
	// Connect are the Connect settings for a service. This is purposely NOT
	// a pointer so that we never have to nil-check this.
	Connect *ServiceConnect `protobuf:"bytes,12,opt,name=Connect,proto3" json:"Connect,omitempty"`
	// LocallyRegisteredAsSidecar is private as it is only used by a local agent
	// state to track if the service was registered from a nested sidecar_service
	// block. We need to track that so we can know whether we need to deregister
	// it automatically too if it's removed from the service definition or if the
	// parent service is deregistered. Relying only on ID would cause us to
	// deregister regular services if they happen to be registered using the same
	// ID scheme as our sidecars do by default. We could use meta but that gets
	// unpleasant because we can't use the consul- prefix from an agent (reserved
	// for use internally but in practice that means within the state store or in
	// responses only), and it leaks the detail publicly which people might rely
	// on which is a bit unpleasant for something that is meant to be config-file
	// syntax sugar. Note this is not translated to ServiceNode and friends and
	// may not be set on a NodeService that isn't the one the agent registered and
	// keeps in it's local state. We never want this rendered in JSON as it's
	// internal only. Right now our agent endpoints return api structs which don't
	// include it but this is a safety net incase we change that or there is
	// somewhere this is used in API output.
	LocallyRegisteredAsSidecar bool `protobuf:"varint,13,opt,name=LocallyRegisteredAsSidecar,proto3" json:"LocallyRegisteredAsSidecar,omitempty"`
	// mog: func-to=EnterpriseMetaToStructs func-from=NewEnterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,16,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	PeerName       string                   `protobuf:"bytes,18,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	// mog: func-to=RaftIndexToStructs func-from=NewRaftIndexFromStructs
	RaftIndex *pbcommon.RaftIndex `protobuf:"bytes,14,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	// Locality identifies where the service is running.
	// mog: func-to=LocalityToStructs func-from=LocalityFromStructs
	Locality *pbcommon.Locality `protobuf:"bytes,19,opt,name=Locality,proto3" json:"Locality,omitempty"`
	// mog: func-to=PortsToStructs func-from=NewPortsFromStructs
	Ports         []*ServicePort `protobuf:"bytes,20,rep,name=Ports,proto3" json:"Ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodeService) Reset() {
	*x = NodeService{}
	mi := &file_private_pbservice_node_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeService) ProtoMessage() {}

func (x *NodeService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_node_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeService.ProtoReflect.Descriptor instead.
func (*NodeService) Descriptor() ([]byte, []int) {
	return file_private_pbservice_node_proto_rawDescGZIP(), []int{3}
}

func (x *NodeService) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *NodeService) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *NodeService) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *NodeService) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *NodeService) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *NodeService) GetTaggedAddresses() map[string]*ServiceAddress {
	if x != nil {
		return x.TaggedAddresses
	}
	return nil
}

func (x *NodeService) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *NodeService) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *NodeService) GetSocketPath() string {
	if x != nil {
		return x.SocketPath
	}
	return ""
}

func (x *NodeService) GetWeights() *Weights {
	if x != nil {
		return x.Weights
	}
	return nil
}

func (x *NodeService) GetEnableTagOverride() bool {
	if x != nil {
		return x.EnableTagOverride
	}
	return false
}

func (x *NodeService) GetProxy() *ConnectProxyConfig {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *NodeService) GetConnect() *ServiceConnect {
	if x != nil {
		return x.Connect
	}
	return nil
}

func (x *NodeService) GetLocallyRegisteredAsSidecar() bool {
	if x != nil {
		return x.LocallyRegisteredAsSidecar
	}
	return false
}

func (x *NodeService) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *NodeService) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

func (x *NodeService) GetRaftIndex() *pbcommon.RaftIndex {
	if x != nil {
		return x.RaftIndex
	}
	return nil
}

func (x *NodeService) GetLocality() *pbcommon.Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

func (x *NodeService) GetPorts() []*ServicePort {
	if x != nil {
		return x.Ports
	}
	return nil
}

var File_private_pbservice_node_proto protoreflect.FileDescriptor

const file_private_pbservice_node_proto_rawDesc = "" +
	"\n" +
	"\x1cprivate/pbservice/node.proto\x12!hashicorp.consul.internal.service\x1a\x1dprivate/pbcommon/common.proto\x1a#private/pbservice/healthcheck.proto\x1a\x1fprivate/pbservice/service.proto\"{\n" +
	"\x18IndexedCheckServiceNodes\x12\x14\n" +
	"\x05Index\x18\x01 \x01(\x04R\x05Index\x12I\n" +
	"\x05Nodes\x18\x02 \x03(\v23.hashicorp.consul.internal.service.CheckServiceNodeR\x05Nodes\"\xe1\x01\n" +
	"\x10CheckServiceNode\x12;\n" +
	"\x04Node\x18\x01 \x01(\v2'.hashicorp.consul.internal.service.NodeR\x04Node\x12H\n" +
	"\aService\x18\x02 \x01(\v2..hashicorp.consul.internal.service.NodeServiceR\aService\x12F\n" +
	"\x06Checks\x18\x03 \x03(\v2..hashicorp.consul.internal.service.HealthCheckR\x06Checks\"\xdd\x04\n" +
	"\x04Node\x12\x0e\n" +
	"\x02ID\x18\x01 \x01(\tR\x02ID\x12\x12\n" +
	"\x04Node\x18\x02 \x01(\tR\x04Node\x12\x1c\n" +
	"\tPartition\x18\b \x01(\tR\tPartition\x12\x1a\n" +
	"\bPeerName\x18\t \x01(\tR\bPeerName\x12\x18\n" +
	"\aAddress\x18\x03 \x01(\tR\aAddress\x12\x1e\n" +
	"\n" +
	"Datacenter\x18\x04 \x01(\tR\n" +
	"Datacenter\x12f\n" +
	"\x0fTaggedAddresses\x18\x05 \x03(\v2<.hashicorp.consul.internal.service.Node.TaggedAddressesEntryR\x0fTaggedAddresses\x12E\n" +
	"\x04Meta\x18\x06 \x03(\v21.hashicorp.consul.internal.service.Node.MetaEntryR\x04Meta\x12I\n" +
	"\tRaftIndex\x18\a \x01(\v2+.hashicorp.consul.internal.common.RaftIndexR\tRaftIndex\x12F\n" +
	"\bLocality\x18\n" +
	" \x01(\v2*.hashicorp.consul.internal.common.LocalityR\bLocality\x1aB\n" +
	"\x14TaggedAddressesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a7\n" +
	"\tMetaEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xb7\t\n" +
	"\vNodeService\x12\x12\n" +
	"\x04Kind\x18\x01 \x01(\tR\x04Kind\x12\x0e\n" +
	"\x02ID\x18\x02 \x01(\tR\x02ID\x12\x18\n" +
	"\aService\x18\x03 \x01(\tR\aService\x12\x12\n" +
	"\x04Tags\x18\x04 \x03(\tR\x04Tags\x12\x18\n" +
	"\aAddress\x18\x05 \x01(\tR\aAddress\x12m\n" +
	"\x0fTaggedAddresses\x18\x0f \x03(\v2C.hashicorp.consul.internal.service.NodeService.TaggedAddressesEntryR\x0fTaggedAddresses\x12L\n" +
	"\x04Meta\x18\x06 \x03(\v28.hashicorp.consul.internal.service.NodeService.MetaEntryR\x04Meta\x12\x12\n" +
	"\x04Port\x18\a \x01(\x05R\x04Port\x12\x1e\n" +
	"\n" +
	"SocketPath\x18\x11 \x01(\tR\n" +
	"SocketPath\x12D\n" +
	"\aWeights\x18\b \x01(\v2*.hashicorp.consul.internal.service.WeightsR\aWeights\x12,\n" +
	"\x11EnableTagOverride\x18\t \x01(\bR\x11EnableTagOverride\x12K\n" +
	"\x05Proxy\x18\v \x01(\v25.hashicorp.consul.internal.service.ConnectProxyConfigR\x05Proxy\x12K\n" +
	"\aConnect\x18\f \x01(\v21.hashicorp.consul.internal.service.ServiceConnectR\aConnect\x12>\n" +
	"\x1aLocallyRegisteredAsSidecar\x18\r \x01(\bR\x1aLocallyRegisteredAsSidecar\x12X\n" +
	"\x0eEnterpriseMeta\x18\x10 \x01(\v20.hashicorp.consul.internal.common.EnterpriseMetaR\x0eEnterpriseMeta\x12\x1a\n" +
	"\bPeerName\x18\x12 \x01(\tR\bPeerName\x12I\n" +
	"\tRaftIndex\x18\x0e \x01(\v2+.hashicorp.consul.internal.common.RaftIndexR\tRaftIndex\x12F\n" +
	"\bLocality\x18\x13 \x01(\v2*.hashicorp.consul.internal.common.LocalityR\bLocality\x12D\n" +
	"\x05Ports\x18\x14 \x03(\v2..hashicorp.consul.internal.service.ServicePortR\x05Ports\x1au\n" +
	"\x14TaggedAddressesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12G\n" +
	"\x05value\x18\x02 \x01(\v21.hashicorp.consul.internal.service.ServiceAddressR\x05value:\x028\x01\x1a7\n" +
	"\tMetaEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\x8f\x02\n" +
	"%com.hashicorp.consul.internal.serviceB\tNodeProtoP\x01Z3github.com/hashicorp/consul/proto/private/pbservice\xa2\x02\x04HCIS\xaa\x02!Hashicorp.Consul.Internal.Service\xca\x02!Hashicorp\\Consul\\Internal\\Service\xe2\x02-Hashicorp\\Consul\\Internal\\Service\\GPBMetadata\xea\x02$Hashicorp::Consul::Internal::Serviceb\x06proto3"

var (
	file_private_pbservice_node_proto_rawDescOnce sync.Once
	file_private_pbservice_node_proto_rawDescData []byte
)

func file_private_pbservice_node_proto_rawDescGZIP() []byte {
	file_private_pbservice_node_proto_rawDescOnce.Do(func() {
		file_private_pbservice_node_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbservice_node_proto_rawDesc), len(file_private_pbservice_node_proto_rawDesc)))
	})
	return file_private_pbservice_node_proto_rawDescData
}

var file_private_pbservice_node_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_private_pbservice_node_proto_goTypes = []any{
	(*IndexedCheckServiceNodes)(nil), // 0: hashicorp.consul.internal.service.IndexedCheckServiceNodes
	(*CheckServiceNode)(nil),         // 1: hashicorp.consul.internal.service.CheckServiceNode
	(*Node)(nil),                     // 2: hashicorp.consul.internal.service.Node
	(*NodeService)(nil),              // 3: hashicorp.consul.internal.service.NodeService
	nil,                              // 4: hashicorp.consul.internal.service.Node.TaggedAddressesEntry
	nil,                              // 5: hashicorp.consul.internal.service.Node.MetaEntry
	nil,                              // 6: hashicorp.consul.internal.service.NodeService.TaggedAddressesEntry
	nil,                              // 7: hashicorp.consul.internal.service.NodeService.MetaEntry
	(*HealthCheck)(nil),              // 8: hashicorp.consul.internal.service.HealthCheck
	(*pbcommon.RaftIndex)(nil),       // 9: hashicorp.consul.internal.common.RaftIndex
	(*pbcommon.Locality)(nil),        // 10: hashicorp.consul.internal.common.Locality
	(*Weights)(nil),                  // 11: hashicorp.consul.internal.service.Weights
	(*ConnectProxyConfig)(nil),       // 12: hashicorp.consul.internal.service.ConnectProxyConfig
	(*ServiceConnect)(nil),           // 13: hashicorp.consul.internal.service.ServiceConnect
	(*pbcommon.EnterpriseMeta)(nil),  // 14: hashicorp.consul.internal.common.EnterpriseMeta
	(*ServicePort)(nil),              // 15: hashicorp.consul.internal.service.ServicePort
	(*ServiceAddress)(nil),           // 16: hashicorp.consul.internal.service.ServiceAddress
}
var file_private_pbservice_node_proto_depIdxs = []int32{
	1,  // 0: hashicorp.consul.internal.service.IndexedCheckServiceNodes.Nodes:type_name -> hashicorp.consul.internal.service.CheckServiceNode
	2,  // 1: hashicorp.consul.internal.service.CheckServiceNode.Node:type_name -> hashicorp.consul.internal.service.Node
	3,  // 2: hashicorp.consul.internal.service.CheckServiceNode.Service:type_name -> hashicorp.consul.internal.service.NodeService
	8,  // 3: hashicorp.consul.internal.service.CheckServiceNode.Checks:type_name -> hashicorp.consul.internal.service.HealthCheck
	4,  // 4: hashicorp.consul.internal.service.Node.TaggedAddresses:type_name -> hashicorp.consul.internal.service.Node.TaggedAddressesEntry
	5,  // 5: hashicorp.consul.internal.service.Node.Meta:type_name -> hashicorp.consul.internal.service.Node.MetaEntry
	9,  // 6: hashicorp.consul.internal.service.Node.RaftIndex:type_name -> hashicorp.consul.internal.common.RaftIndex
	10, // 7: hashicorp.consul.internal.service.Node.Locality:type_name -> hashicorp.consul.internal.common.Locality
	6,  // 8: hashicorp.consul.internal.service.NodeService.TaggedAddresses:type_name -> hashicorp.consul.internal.service.NodeService.TaggedAddressesEntry
	7,  // 9: hashicorp.consul.internal.service.NodeService.Meta:type_name -> hashicorp.consul.internal.service.NodeService.MetaEntry
	11, // 10: hashicorp.consul.internal.service.NodeService.Weights:type_name -> hashicorp.consul.internal.service.Weights
	12, // 11: hashicorp.consul.internal.service.NodeService.Proxy:type_name -> hashicorp.consul.internal.service.ConnectProxyConfig
	13, // 12: hashicorp.consul.internal.service.NodeService.Connect:type_name -> hashicorp.consul.internal.service.ServiceConnect
	14, // 13: hashicorp.consul.internal.service.NodeService.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	9,  // 14: hashicorp.consul.internal.service.NodeService.RaftIndex:type_name -> hashicorp.consul.internal.common.RaftIndex
	10, // 15: hashicorp.consul.internal.service.NodeService.Locality:type_name -> hashicorp.consul.internal.common.Locality
	15, // 16: hashicorp.consul.internal.service.NodeService.Ports:type_name -> hashicorp.consul.internal.service.ServicePort
	16, // 17: hashicorp.consul.internal.service.NodeService.TaggedAddressesEntry.value:type_name -> hashicorp.consul.internal.service.ServiceAddress
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_private_pbservice_node_proto_init() }
func file_private_pbservice_node_proto_init() {
	if File_private_pbservice_node_proto != nil {
		return
	}
	file_private_pbservice_healthcheck_proto_init()
	file_private_pbservice_service_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbservice_node_proto_rawDesc), len(file_private_pbservice_node_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_private_pbservice_node_proto_goTypes,
		DependencyIndexes: file_private_pbservice_node_proto_depIdxs,
		MessageInfos:      file_private_pbservice_node_proto_msgTypes,
	}.Build()
	File_private_pbservice_node_proto = out.File
	file_private_pbservice_node_proto_goTypes = nil
	file_private_pbservice_node_proto_depIdxs = nil
}
