// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbstorage/raft.proto

// This package contains types used by the Raft storage backend that lives in
// the internal/storage/raft Go package.

package pbstorage

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbresource "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// LogType describes the type of operation being written to the Raft log.
type LogType int32

const (
	LogType_LOG_TYPE_UNSPECIFIED LogType = 0
	LogType_LOG_TYPE_WRITE       LogType = 1
	LogType_LOG_TYPE_DELETE      LogType = 2
)

// Enum value maps for LogType.
var (
	LogType_name = map[int32]string{
		0: "LOG_TYPE_UNSPECIFIED",
		1: "LOG_TYPE_WRITE",
		2: "LOG_TYPE_DELETE",
	}
	LogType_value = map[string]int32{
		"LOG_TYPE_UNSPECIFIED": 0,
		"LOG_TYPE_WRITE":       1,
		"LOG_TYPE_DELETE":      2,
	}
)

func (x LogType) Enum() *LogType {
	p := new(LogType)
	*p = x
	return p
}

func (x LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbstorage_raft_proto_enumTypes[0].Descriptor()
}

func (LogType) Type() protoreflect.EnumType {
	return &file_private_pbstorage_raft_proto_enumTypes[0]
}

func (x LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogType.Descriptor instead.
func (LogType) EnumDescriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{0}
}

// Log is protobuf-encoded and written to the Raft log.
type Log struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  LogType                `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.consul.internal.storage.raft.LogType" json:"type,omitempty"`
	// Types that are valid to be assigned to Request:
	//
	//	*Log_Write
	//	*Log_Delete
	Request       isLog_Request `protobuf_oneof:"request"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Log) Reset() {
	*x = Log{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Log) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Log) ProtoMessage() {}

func (x *Log) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Log.ProtoReflect.Descriptor instead.
func (*Log) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{0}
}

func (x *Log) GetType() LogType {
	if x != nil {
		return x.Type
	}
	return LogType_LOG_TYPE_UNSPECIFIED
}

func (x *Log) GetRequest() isLog_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *Log) GetWrite() *WriteRequest {
	if x != nil {
		if x, ok := x.Request.(*Log_Write); ok {
			return x.Write
		}
	}
	return nil
}

func (x *Log) GetDelete() *DeleteRequest {
	if x != nil {
		if x, ok := x.Request.(*Log_Delete); ok {
			return x.Delete
		}
	}
	return nil
}

type isLog_Request interface {
	isLog_Request()
}

type Log_Write struct {
	Write *WriteRequest `protobuf:"bytes,2,opt,name=write,proto3,oneof"`
}

type Log_Delete struct {
	Delete *DeleteRequest `protobuf:"bytes,3,opt,name=delete,proto3,oneof"`
}

func (*Log_Write) isLog_Request() {}

func (*Log_Delete) isLog_Request() {}

// LogResponse contains the FSM's response to applying a log.
type LogResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Response:
	//
	//	*LogResponse_Write
	//	*LogResponse_Delete
	Response      isLogResponse_Response `protobuf_oneof:"response"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogResponse) Reset() {
	*x = LogResponse{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogResponse) ProtoMessage() {}

func (x *LogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogResponse.ProtoReflect.Descriptor instead.
func (*LogResponse) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{1}
}

func (x *LogResponse) GetResponse() isLogResponse_Response {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *LogResponse) GetWrite() *WriteResponse {
	if x != nil {
		if x, ok := x.Response.(*LogResponse_Write); ok {
			return x.Write
		}
	}
	return nil
}

func (x *LogResponse) GetDelete() *emptypb.Empty {
	if x != nil {
		if x, ok := x.Response.(*LogResponse_Delete); ok {
			return x.Delete
		}
	}
	return nil
}

type isLogResponse_Response interface {
	isLogResponse_Response()
}

type LogResponse_Write struct {
	Write *WriteResponse `protobuf:"bytes,1,opt,name=write,proto3,oneof"`
}

type LogResponse_Delete struct {
	Delete *emptypb.Empty `protobuf:"bytes,2,opt,name=delete,proto3,oneof"`
}

func (*LogResponse_Write) isLogResponse_Response() {}

func (*LogResponse_Delete) isLogResponse_Response() {}

// WriteRequest contains the parameters for a write operation.
type WriteRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *pbresource.Resource   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteRequest) Reset() {
	*x = WriteRequest{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRequest) ProtoMessage() {}

func (x *WriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRequest.ProtoReflect.Descriptor instead.
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{2}
}

func (x *WriteRequest) GetResource() *pbresource.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// WriteResponse contains the results of a write operation.
type WriteResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *pbresource.Resource   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WriteResponse) Reset() {
	*x = WriteResponse{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResponse) ProtoMessage() {}

func (x *WriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResponse.ProtoReflect.Descriptor instead.
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{3}
}

func (x *WriteResponse) GetResource() *pbresource.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// DeleteRequest contains the parameters for a write operation.
type DeleteRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            *pbresource.ID         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Version       string                 `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRequest) Reset() {
	*x = DeleteRequest{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRequest) ProtoMessage() {}

func (x *DeleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRequest.ProtoReflect.Descriptor instead.
func (*DeleteRequest) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteRequest) GetId() *pbresource.ID {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *DeleteRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// ReadRequest contains the parameters for a consistent read operation.
type ReadRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            *pbresource.ID         `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadRequest) Reset() {
	*x = ReadRequest{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRequest) ProtoMessage() {}

func (x *ReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRequest.ProtoReflect.Descriptor instead.
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{5}
}

func (x *ReadRequest) GetId() *pbresource.ID {
	if x != nil {
		return x.Id
	}
	return nil
}

// ReadResponse contains the results of a consistent read operation.
type ReadResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resource      *pbresource.Resource   `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResponse) Reset() {
	*x = ReadResponse{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResponse) ProtoMessage() {}

func (x *ReadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResponse.ProtoReflect.Descriptor instead.
func (*ReadResponse) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{6}
}

func (x *ReadResponse) GetResource() *pbresource.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// ListRequest contains the parameters for a consistent list operation.
type ListRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          *pbresource.Type       `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Tenancy       *pbresource.Tenancy    `protobuf:"bytes,2,opt,name=tenancy,proto3" json:"tenancy,omitempty"`
	NamePrefix    string                 `protobuf:"bytes,3,opt,name=name_prefix,json=namePrefix,proto3" json:"name_prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListRequest) Reset() {
	*x = ListRequest{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRequest) ProtoMessage() {}

func (x *ListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRequest.ProtoReflect.Descriptor instead.
func (*ListRequest) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{7}
}

func (x *ListRequest) GetType() *pbresource.Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ListRequest) GetTenancy() *pbresource.Tenancy {
	if x != nil {
		return x.Tenancy
	}
	return nil
}

func (x *ListRequest) GetNamePrefix() string {
	if x != nil {
		return x.NamePrefix
	}
	return ""
}

// ListResponse contains the results of a consistent list operation.
type ListResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Resources     []*pbresource.Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResponse) Reset() {
	*x = ListResponse{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResponse) ProtoMessage() {}

func (x *ListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResponse.ProtoReflect.Descriptor instead.
func (*ListResponse) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{8}
}

func (x *ListResponse) GetResources() []*pbresource.Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

// GroupVersionMismatchErrorDetails contains the error details that will be
// returned when the leader encounters a storage.GroupVersionMismatchError.
type GroupVersionMismatchErrorDetails struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	RequestedType *pbresource.Type       `protobuf:"bytes,1,opt,name=requested_type,json=requestedType,proto3" json:"requested_type,omitempty"`
	Stored        *pbresource.Resource   `protobuf:"bytes,2,opt,name=stored,proto3" json:"stored,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupVersionMismatchErrorDetails) Reset() {
	*x = GroupVersionMismatchErrorDetails{}
	mi := &file_private_pbstorage_raft_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupVersionMismatchErrorDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupVersionMismatchErrorDetails) ProtoMessage() {}

func (x *GroupVersionMismatchErrorDetails) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbstorage_raft_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupVersionMismatchErrorDetails.ProtoReflect.Descriptor instead.
func (*GroupVersionMismatchErrorDetails) Descriptor() ([]byte, []int) {
	return file_private_pbstorage_raft_proto_rawDescGZIP(), []int{9}
}

func (x *GroupVersionMismatchErrorDetails) GetRequestedType() *pbresource.Type {
	if x != nil {
		return x.RequestedType
	}
	return nil
}

func (x *GroupVersionMismatchErrorDetails) GetStored() *pbresource.Resource {
	if x != nil {
		return x.Stored
	}
	return nil
}

var File_private_pbstorage_raft_proto protoreflect.FileDescriptor

const file_private_pbstorage_raft_proto_rawDesc = "" +
	"\n" +
	"\x1cprivate/pbstorage/raft.proto\x12&hashicorp.consul.internal.storage.raft\x1a%annotations/ratelimit/ratelimit.proto\x1a\x1bgoogle/protobuf/empty.proto\x1a\x19pbresource/resource.proto\"\xf4\x01\n" +
	"\x03Log\x12C\n" +
	"\x04type\x18\x01 \x01(\x0e2/.hashicorp.consul.internal.storage.raft.LogTypeR\x04type\x12L\n" +
	"\x05write\x18\x02 \x01(\v24.hashicorp.consul.internal.storage.raft.WriteRequestH\x00R\x05write\x12O\n" +
	"\x06delete\x18\x03 \x01(\v25.hashicorp.consul.internal.storage.raft.DeleteRequestH\x00R\x06deleteB\t\n" +
	"\arequest\"\x9a\x01\n" +
	"\vLogResponse\x12M\n" +
	"\x05write\x18\x01 \x01(\v25.hashicorp.consul.internal.storage.raft.WriteResponseH\x00R\x05write\x120\n" +
	"\x06delete\x18\x02 \x01(\v2\x16.google.protobuf.EmptyH\x00R\x06deleteB\n" +
	"\n" +
	"\bresponse\"O\n" +
	"\fWriteRequest\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"P\n" +
	"\rWriteResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"X\n" +
	"\rDeleteRequest\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\"<\n" +
	"\vReadRequest\x12-\n" +
	"\x02id\x18\x01 \x01(\v2\x1d.hashicorp.consul.resource.IDR\x02id\"O\n" +
	"\fReadResponse\x12?\n" +
	"\bresource\x18\x01 \x01(\v2#.hashicorp.consul.resource.ResourceR\bresource\"\xa1\x01\n" +
	"\vListRequest\x123\n" +
	"\x04type\x18\x01 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\x04type\x12<\n" +
	"\atenancy\x18\x02 \x01(\v2\".hashicorp.consul.resource.TenancyR\atenancy\x12\x1f\n" +
	"\vname_prefix\x18\x03 \x01(\tR\n" +
	"namePrefix\"Q\n" +
	"\fListResponse\x12A\n" +
	"\tresources\x18\x01 \x03(\v2#.hashicorp.consul.resource.ResourceR\tresources\"\xa7\x01\n" +
	" GroupVersionMismatchErrorDetails\x12F\n" +
	"\x0erequested_type\x18\x01 \x01(\v2\x1f.hashicorp.consul.resource.TypeR\rrequestedType\x12;\n" +
	"\x06stored\x18\x02 \x01(\v2#.hashicorp.consul.resource.ResourceR\x06stored*L\n" +
	"\aLogType\x12\x18\n" +
	"\x14LOG_TYPE_UNSPECIFIED\x10\x00\x12\x12\n" +
	"\x0eLOG_TYPE_WRITE\x10\x01\x12\x13\n" +
	"\x0fLOG_TYPE_DELETE\x10\x022\xf0\x03\n" +
	"\x11ForwardingService\x12~\n" +
	"\x05Write\x124.hashicorp.consul.internal.storage.raft.WriteRequest\x1a5.hashicorp.consul.internal.storage.raft.WriteResponse\"\b\xe2\x86\x04\x04\b\x01\x10\v\x12a\n" +
	"\x06Delete\x125.hashicorp.consul.internal.storage.raft.DeleteRequest\x1a\x16.google.protobuf.Empty\"\b\xe2\x86\x04\x04\b\x01\x10\v\x12{\n" +
	"\x04Read\x123.hashicorp.consul.internal.storage.raft.ReadRequest\x1a4.hashicorp.consul.internal.storage.raft.ReadResponse\"\b\xe2\x86\x04\x04\b\x01\x10\v\x12{\n" +
	"\x04List\x123.hashicorp.consul.internal.storage.raft.ListRequest\x1a4.hashicorp.consul.internal.storage.raft.ListResponse\"\b\xe2\x86\x04\x04\b\x01\x10\vB\xaa\x02\n" +
	"*com.hashicorp.consul.internal.storage.raftB\tRaftProtoP\x01Z3github.com/hashicorp/consul/proto/private/pbstorage\xa2\x02\x05HCISR\xaa\x02&Hashicorp.Consul.Internal.Storage.Raft\xca\x02&Hashicorp\\Consul\\Internal\\Storage\\Raft\xe2\x022Hashicorp\\Consul\\Internal\\Storage\\Raft\\GPBMetadata\xea\x02*Hashicorp::Consul::Internal::Storage::Raftb\x06proto3"

var (
	file_private_pbstorage_raft_proto_rawDescOnce sync.Once
	file_private_pbstorage_raft_proto_rawDescData []byte
)

func file_private_pbstorage_raft_proto_rawDescGZIP() []byte {
	file_private_pbstorage_raft_proto_rawDescOnce.Do(func() {
		file_private_pbstorage_raft_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbstorage_raft_proto_rawDesc), len(file_private_pbstorage_raft_proto_rawDesc)))
	})
	return file_private_pbstorage_raft_proto_rawDescData
}

var file_private_pbstorage_raft_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_private_pbstorage_raft_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_private_pbstorage_raft_proto_goTypes = []any{
	(LogType)(0),                             // 0: hashicorp.consul.internal.storage.raft.LogType
	(*Log)(nil),                              // 1: hashicorp.consul.internal.storage.raft.Log
	(*LogResponse)(nil),                      // 2: hashicorp.consul.internal.storage.raft.LogResponse
	(*WriteRequest)(nil),                     // 3: hashicorp.consul.internal.storage.raft.WriteRequest
	(*WriteResponse)(nil),                    // 4: hashicorp.consul.internal.storage.raft.WriteResponse
	(*DeleteRequest)(nil),                    // 5: hashicorp.consul.internal.storage.raft.DeleteRequest
	(*ReadRequest)(nil),                      // 6: hashicorp.consul.internal.storage.raft.ReadRequest
	(*ReadResponse)(nil),                     // 7: hashicorp.consul.internal.storage.raft.ReadResponse
	(*ListRequest)(nil),                      // 8: hashicorp.consul.internal.storage.raft.ListRequest
	(*ListResponse)(nil),                     // 9: hashicorp.consul.internal.storage.raft.ListResponse
	(*GroupVersionMismatchErrorDetails)(nil), // 10: hashicorp.consul.internal.storage.raft.GroupVersionMismatchErrorDetails
	(*emptypb.Empty)(nil),                    // 11: google.protobuf.Empty
	(*pbresource.Resource)(nil),              // 12: hashicorp.consul.resource.Resource
	(*pbresource.ID)(nil),                    // 13: hashicorp.consul.resource.ID
	(*pbresource.Type)(nil),                  // 14: hashicorp.consul.resource.Type
	(*pbresource.Tenancy)(nil),               // 15: hashicorp.consul.resource.Tenancy
}
var file_private_pbstorage_raft_proto_depIdxs = []int32{
	0,  // 0: hashicorp.consul.internal.storage.raft.Log.type:type_name -> hashicorp.consul.internal.storage.raft.LogType
	3,  // 1: hashicorp.consul.internal.storage.raft.Log.write:type_name -> hashicorp.consul.internal.storage.raft.WriteRequest
	5,  // 2: hashicorp.consul.internal.storage.raft.Log.delete:type_name -> hashicorp.consul.internal.storage.raft.DeleteRequest
	4,  // 3: hashicorp.consul.internal.storage.raft.LogResponse.write:type_name -> hashicorp.consul.internal.storage.raft.WriteResponse
	11, // 4: hashicorp.consul.internal.storage.raft.LogResponse.delete:type_name -> google.protobuf.Empty
	12, // 5: hashicorp.consul.internal.storage.raft.WriteRequest.resource:type_name -> hashicorp.consul.resource.Resource
	12, // 6: hashicorp.consul.internal.storage.raft.WriteResponse.resource:type_name -> hashicorp.consul.resource.Resource
	13, // 7: hashicorp.consul.internal.storage.raft.DeleteRequest.id:type_name -> hashicorp.consul.resource.ID
	13, // 8: hashicorp.consul.internal.storage.raft.ReadRequest.id:type_name -> hashicorp.consul.resource.ID
	12, // 9: hashicorp.consul.internal.storage.raft.ReadResponse.resource:type_name -> hashicorp.consul.resource.Resource
	14, // 10: hashicorp.consul.internal.storage.raft.ListRequest.type:type_name -> hashicorp.consul.resource.Type
	15, // 11: hashicorp.consul.internal.storage.raft.ListRequest.tenancy:type_name -> hashicorp.consul.resource.Tenancy
	12, // 12: hashicorp.consul.internal.storage.raft.ListResponse.resources:type_name -> hashicorp.consul.resource.Resource
	14, // 13: hashicorp.consul.internal.storage.raft.GroupVersionMismatchErrorDetails.requested_type:type_name -> hashicorp.consul.resource.Type
	12, // 14: hashicorp.consul.internal.storage.raft.GroupVersionMismatchErrorDetails.stored:type_name -> hashicorp.consul.resource.Resource
	3,  // 15: hashicorp.consul.internal.storage.raft.ForwardingService.Write:input_type -> hashicorp.consul.internal.storage.raft.WriteRequest
	5,  // 16: hashicorp.consul.internal.storage.raft.ForwardingService.Delete:input_type -> hashicorp.consul.internal.storage.raft.DeleteRequest
	6,  // 17: hashicorp.consul.internal.storage.raft.ForwardingService.Read:input_type -> hashicorp.consul.internal.storage.raft.ReadRequest
	8,  // 18: hashicorp.consul.internal.storage.raft.ForwardingService.List:input_type -> hashicorp.consul.internal.storage.raft.ListRequest
	4,  // 19: hashicorp.consul.internal.storage.raft.ForwardingService.Write:output_type -> hashicorp.consul.internal.storage.raft.WriteResponse
	11, // 20: hashicorp.consul.internal.storage.raft.ForwardingService.Delete:output_type -> google.protobuf.Empty
	7,  // 21: hashicorp.consul.internal.storage.raft.ForwardingService.Read:output_type -> hashicorp.consul.internal.storage.raft.ReadResponse
	9,  // 22: hashicorp.consul.internal.storage.raft.ForwardingService.List:output_type -> hashicorp.consul.internal.storage.raft.ListResponse
	19, // [19:23] is the sub-list for method output_type
	15, // [15:19] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_private_pbstorage_raft_proto_init() }
func file_private_pbstorage_raft_proto_init() {
	if File_private_pbstorage_raft_proto != nil {
		return
	}
	file_private_pbstorage_raft_proto_msgTypes[0].OneofWrappers = []any{
		(*Log_Write)(nil),
		(*Log_Delete)(nil),
	}
	file_private_pbstorage_raft_proto_msgTypes[1].OneofWrappers = []any{
		(*LogResponse_Write)(nil),
		(*LogResponse_Delete)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbstorage_raft_proto_rawDesc), len(file_private_pbstorage_raft_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbstorage_raft_proto_goTypes,
		DependencyIndexes: file_private_pbstorage_raft_proto_depIdxs,
		EnumInfos:         file_private_pbstorage_raft_proto_enumTypes,
		MessageInfos:      file_private_pbstorage_raft_proto_msgTypes,
	}.Build()
	File_private_pbstorage_raft_proto = out.File
	file_private_pbstorage_raft_proto_goTypes = nil
	file_private_pbstorage_raft_proto_depIdxs = nil
}
