// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

//
//Package event provides a service for subscribing to state change events.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: private/pbsubscribe/subscribe.proto

// TODO: ideally we would have prefixed this package as
// "hashicorp.consul.internal.subscribe" before releasing but now correcting this will
// require a grpc passthrough service shim since the package name is part of
// the rpc method dispatch and editing it naively would break backwards
// compatibility.

package pbsubscribe

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	StateChangeSubscription_Subscribe_FullMethodName = "/subscribe.StateChangeSubscription/Subscribe"
)

// StateChangeSubscriptionClient is the client API for StateChangeSubscription service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// StateChangeSubscription service allows consumers to subscribe to topics of
// state change events. Events are streamed as they happen.
// buf:lint:ignore SERVICE_SUFFIX
type StateChangeSubscriptionClient interface {
	// Subscribe to a topic to receive events when there are changes to the topic.
	//
	// If SubscribeRequest.Index is 0 the event stream will start with one or
	// more snapshot events, followed by an EndOfSnapshot event. Subsequent
	// events will be a live stream of events as they happen.
	//
	// If SubscribeRequest.Index is > 0 it is assumed the client already has a
	// snapshot, and is trying to resume a stream that was disconnected. The
	// client will either receive a NewSnapshotToFollow event, indicating the
	// client view is stale and it must reset its view and prepare for a new
	// snapshot. Or, if no NewSnapshotToFollow event is received, the client
	// view is still fresh, and all events will be the live stream.
	//
	// Subscribe may return a gRPC status error with codes.ABORTED to indicate
	// the client view is now stale due to a change on the server. The client
	// must reset its view and issue a new Subscribe call to restart the stream.
	// This error is used when the server can no longer correctly maintain the
	// stream, for example because the ACL permissions for the token changed, or
	// because the server state was restored from a snapshot.
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	Subscribe(ctx context.Context, in *SubscribeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Event], error)
}

type stateChangeSubscriptionClient struct {
	cc grpc.ClientConnInterface
}

func NewStateChangeSubscriptionClient(cc grpc.ClientConnInterface) StateChangeSubscriptionClient {
	return &stateChangeSubscriptionClient{cc}
}

func (c *stateChangeSubscriptionClient) Subscribe(ctx context.Context, in *SubscribeRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[Event], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &StateChangeSubscription_ServiceDesc.Streams[0], StateChangeSubscription_Subscribe_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[SubscribeRequest, Event]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type StateChangeSubscription_SubscribeClient = grpc.ServerStreamingClient[Event]

// StateChangeSubscriptionServer is the server API for StateChangeSubscription service.
// All implementations should embed UnimplementedStateChangeSubscriptionServer
// for forward compatibility.
//
// StateChangeSubscription service allows consumers to subscribe to topics of
// state change events. Events are streamed as they happen.
// buf:lint:ignore SERVICE_SUFFIX
type StateChangeSubscriptionServer interface {
	// Subscribe to a topic to receive events when there are changes to the topic.
	//
	// If SubscribeRequest.Index is 0 the event stream will start with one or
	// more snapshot events, followed by an EndOfSnapshot event. Subsequent
	// events will be a live stream of events as they happen.
	//
	// If SubscribeRequest.Index is > 0 it is assumed the client already has a
	// snapshot, and is trying to resume a stream that was disconnected. The
	// client will either receive a NewSnapshotToFollow event, indicating the
	// client view is stale and it must reset its view and prepare for a new
	// snapshot. Or, if no NewSnapshotToFollow event is received, the client
	// view is still fresh, and all events will be the live stream.
	//
	// Subscribe may return a gRPC status error with codes.ABORTED to indicate
	// the client view is now stale due to a change on the server. The client
	// must reset its view and issue a new Subscribe call to restart the stream.
	// This error is used when the server can no longer correctly maintain the
	// stream, for example because the ACL permissions for the token changed, or
	// because the server state was restored from a snapshot.
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	Subscribe(*SubscribeRequest, grpc.ServerStreamingServer[Event]) error
}

// UnimplementedStateChangeSubscriptionServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedStateChangeSubscriptionServer struct{}

func (UnimplementedStateChangeSubscriptionServer) Subscribe(*SubscribeRequest, grpc.ServerStreamingServer[Event]) error {
	return status.Errorf(codes.Unimplemented, "method Subscribe not implemented")
}
func (UnimplementedStateChangeSubscriptionServer) testEmbeddedByValue() {}

// UnsafeStateChangeSubscriptionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StateChangeSubscriptionServer will
// result in compilation errors.
type UnsafeStateChangeSubscriptionServer interface {
	mustEmbedUnimplementedStateChangeSubscriptionServer()
}

func RegisterStateChangeSubscriptionServer(s grpc.ServiceRegistrar, srv StateChangeSubscriptionServer) {
	// If the following call pancis, it indicates UnimplementedStateChangeSubscriptionServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&StateChangeSubscription_ServiceDesc, srv)
}

func _StateChangeSubscription_Subscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscribeRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StateChangeSubscriptionServer).Subscribe(m, &grpc.GenericServerStream[SubscribeRequest, Event]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type StateChangeSubscription_SubscribeServer = grpc.ServerStreamingServer[Event]

// StateChangeSubscription_ServiceDesc is the grpc.ServiceDesc for StateChangeSubscription service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StateChangeSubscription_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "subscribe.StateChangeSubscription",
	HandlerType: (*StateChangeSubscriptionServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Subscribe",
			Handler:       _StateChangeSubscription_Subscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "private/pbsubscribe/subscribe.proto",
}
