/*
    SPDX-FileCopyrightText: 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "viewlistmenucontrollerfactory.hpp"

// lib
#include "viewlistmenucontroller.hpp"

namespace Kasten {

ViewListMenuControllerFactory::ViewListMenuControllerFactory(ViewManager* viewManager,
                                                             AbstractGroupedViews* groupedViews)
    : m_viewManager(viewManager)
    , m_groupedViews(groupedViews)
{
}

ViewListMenuControllerFactory::~ViewListMenuControllerFactory() = default;

std::unique_ptr<AbstractXmlGuiController> ViewListMenuControllerFactory::create(KXMLGUIClient* guiClient) const
{
    return std::make_unique<ViewListMenuController>(m_viewManager, m_groupedViews, guiClient);
}

}
