/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import jdk.jfr.Configuration;
import jdk.management.jfr.Stringifier;

public final class ConfigurationInfo {
    private final Map<String, String> settings;
    private final String name;
    private final String label;
    private final String description;
    private final String provider;
    private final String contents;

    ConfigurationInfo(Configuration configuration) {
        this.settings = configuration.getSettings();
        this.name = configuration.getName();
        this.label = configuration.getLabel();
        this.description = configuration.getDescription();
        this.provider = configuration.getProvider();
        this.contents = configuration.getContents();
    }

    private ConfigurationInfo(CompositeData compositeData) {
        this.settings = ConfigurationInfo.createMap(compositeData.get("settings"));
        this.name = (String)compositeData.get("name");
        this.label = (String)compositeData.get("label");
        this.description = (String)compositeData.get("description");
        this.provider = (String)compositeData.get("provider");
        this.contents = (String)compositeData.get("contents");
    }

    private static Map<String, String> createMap(Object object) {
        if (object instanceof TabularData) {
            TabularData tabularData = (TabularData)object;
            Collection<?> collection = tabularData.values();
            HashMap<String, String> hashMap = new HashMap<String, String>(collection.size());
            for (Object obj : tabularData.values()) {
                if (!(obj instanceof CompositeData)) continue;
                CompositeData compositeData = (CompositeData)obj;
                Object object2 = compositeData.get("key");
                Object object3 = compositeData.get("value");
                if (!(object2 instanceof String) || !(object3 instanceof String)) continue;
                hashMap.put((String)object2, (String)object3);
            }
            return Collections.unmodifiableMap(hashMap);
        }
        return Collections.emptyMap();
    }

    public String getProvider() {
        return this.provider;
    }

    public String getContents() {
        return this.contents;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConfigurationInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        return new ConfigurationInfo(compositeData);
    }

    public String toString() {
        Stringifier stringifier = new Stringifier();
        stringifier.add("name", this.name);
        stringifier.add("label", this.label);
        stringifier.add("description", this.description);
        stringifier.add("provider", this.provider);
        return stringifier.toString();
    }
}

