/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaTabbedPaneUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaTabbedPaneContrastUI
extends AquaTabbedPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTabbedPaneContrastUI();
    }

    @Override
    protected void paintTitle(Graphics2D graphics2D, Font font, FontMetrics fontMetrics, Rectangle rectangle, int n, String string) {
        View view = this.getTextViewForTab(n);
        if (view != null) {
            view.paint(graphics2D, rectangle);
            return;
        }
        if (string == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(n);
        if (color instanceof UIResource) {
            graphics2D.setColor(AquaTabbedPaneContrastUI.getNonSelectedTabTitleColor());
            if (this.tabPane.getSelectedIndex() == n) {
                boolean bl = this.isPressedAt(n);
                boolean bl2 = this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n);
                Color color2 = AquaTabbedPaneContrastUI.getSelectedTabTitleColor(bl2, bl);
                Color color3 = AquaTabbedPaneContrastUI.getSelectedTabTitleShadowColor(bl2);
                AquaUtils.paintDropShadowText(graphics2D, this.tabPane, font, fontMetrics, rectangle.x, rectangle.y, 0, 1, color2, color3, string);
                return;
            }
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.setFont(font);
        SwingUtilities2.drawString((JComponent)this.tabPane, (Graphics)graphics2D, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected static Color getSelectedTabTitleColor(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return UIManager.getColor("TabbedPane.selectedTabTitlePressedColor");
        }
        if (!bl) {
            return UIManager.getColor("TabbedPane.selectedTabTitleDisabledColor");
        }
        return UIManager.getColor("TabbedPane.selectedTabTitleNormalColor");
    }

    protected static Color getSelectedTabTitleShadowColor(boolean bl) {
        return bl ? UIManager.getColor("TabbedPane.selectedTabTitleShadowNormalColor") : UIManager.getColor("TabbedPane.selectedTabTitleShadowDisabledColor");
    }

    protected static Color getNonSelectedTabTitleColor() {
        return UIManager.getColor("TabbedPane.nonSelectedTabTitleNormalColor");
    }

    protected boolean isPressedAt(int n) {
        return ((AquaTabbedPaneUI.MouseHandler)this.mouseListener).trackingTab == n;
    }

    @Override
    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return true;
    }

    @Override
    protected JRSUIConstants.State getState(int n, boolean bl, boolean bl2) {
        if (!bl) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!this.tabPane.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.pressedTab == n) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    protected JRSUIConstants.SegmentTrailingSeparator getSegmentTrailingSeparator(int n, int n2, boolean bl) {
        if (this.isTabBeforeSelectedTab(n, n2, bl)) {
            return JRSUIConstants.SegmentTrailingSeparator.NO;
        }
        return JRSUIConstants.SegmentTrailingSeparator.YES;
    }

    @Override
    protected JRSUIConstants.SegmentLeadingSeparator getSegmentLeadingSeparator(int n, int n2, boolean bl) {
        if (n == n2) {
            return JRSUIConstants.SegmentLeadingSeparator.YES;
        }
        return JRSUIConstants.SegmentLeadingSeparator.NO;
    }
}

