/*
 * ********************************************************************************
 * This file is part of the LibreCAD project, a 2D CAD program
 *
 * Copyright (C) 2025 LibreCAD.org
 * Copyright (C) 2025 sand1024
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * ********************************************************************************
 */

#ifndef LC_ARROW_HEADCLOSED_BLANK_H
#define LC_ARROW_HEADCLOSED_BLANK_H
#include "lc_arrow_headclosed.h"

class LC_ArrowHeadClosedBlank: public LC_ArrowHeadClosed{
public:
    LC_ArrowHeadClosedBlank(RS_EntityContainer* container, const RS_Vector& point, double dirAngle, double size, double ownAngle);
    RS_Entity* clone() const override;
    void draw(RS_Painter* painter) override;
};

#endif // LC_ARROW_HEADCLOSED_BLANK_H
