// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PutServiceIDReader is a Reader for the PutServiceID structure.
type PutServiceIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutServiceIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPutServiceIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 201:
		result := NewPutServiceIDCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewPutServiceIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 460:
		result := NewPutServiceIDInvalidFrontend()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 461:
		result := NewPutServiceIDInvalidBackend()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPutServiceIDFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewPutServiceIDUpdateBackendFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /service/{id}] PutServiceID", response, response.Code())
	}
}

// NewPutServiceIDOK creates a PutServiceIDOK with default headers values
func NewPutServiceIDOK() *PutServiceIDOK {
	return &PutServiceIDOK{}
}

/*
PutServiceIDOK describes a response with status code 200, with default header values.

Updated
*/
type PutServiceIDOK struct {
}

// IsSuccess returns true when this put service Id o k response has a 2xx status code
func (o *PutServiceIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put service Id o k response has a 3xx status code
func (o *PutServiceIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id o k response has a 4xx status code
func (o *PutServiceIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this put service Id o k response has a 5xx status code
func (o *PutServiceIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this put service Id o k response a status code equal to that given
func (o *PutServiceIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the put service Id o k response
func (o *PutServiceIDOK) Code() int {
	return 200
}

func (o *PutServiceIDOK) Error() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdOK", 200)
}

func (o *PutServiceIDOK) String() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdOK", 200)
}

func (o *PutServiceIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutServiceIDCreated creates a PutServiceIDCreated with default headers values
func NewPutServiceIDCreated() *PutServiceIDCreated {
	return &PutServiceIDCreated{}
}

/*
PutServiceIDCreated describes a response with status code 201, with default header values.

Created
*/
type PutServiceIDCreated struct {
}

// IsSuccess returns true when this put service Id created response has a 2xx status code
func (o *PutServiceIDCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put service Id created response has a 3xx status code
func (o *PutServiceIDCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id created response has a 4xx status code
func (o *PutServiceIDCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this put service Id created response has a 5xx status code
func (o *PutServiceIDCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this put service Id created response a status code equal to that given
func (o *PutServiceIDCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the put service Id created response
func (o *PutServiceIDCreated) Code() int {
	return 201
}

func (o *PutServiceIDCreated) Error() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdCreated", 201)
}

func (o *PutServiceIDCreated) String() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdCreated", 201)
}

func (o *PutServiceIDCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutServiceIDForbidden creates a PutServiceIDForbidden with default headers values
func NewPutServiceIDForbidden() *PutServiceIDForbidden {
	return &PutServiceIDForbidden{}
}

/*
PutServiceIDForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PutServiceIDForbidden struct {
}

// IsSuccess returns true when this put service Id forbidden response has a 2xx status code
func (o *PutServiceIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put service Id forbidden response has a 3xx status code
func (o *PutServiceIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id forbidden response has a 4xx status code
func (o *PutServiceIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this put service Id forbidden response has a 5xx status code
func (o *PutServiceIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this put service Id forbidden response a status code equal to that given
func (o *PutServiceIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the put service Id forbidden response
func (o *PutServiceIDForbidden) Code() int {
	return 403
}

func (o *PutServiceIDForbidden) Error() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdForbidden", 403)
}

func (o *PutServiceIDForbidden) String() string {
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdForbidden", 403)
}

func (o *PutServiceIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPutServiceIDInvalidFrontend creates a PutServiceIDInvalidFrontend with default headers values
func NewPutServiceIDInvalidFrontend() *PutServiceIDInvalidFrontend {
	return &PutServiceIDInvalidFrontend{}
}

/*
PutServiceIDInvalidFrontend describes a response with status code 460, with default header values.

Invalid frontend in service configuration
*/
type PutServiceIDInvalidFrontend struct {
	Payload models.Error
}

// IsSuccess returns true when this put service Id invalid frontend response has a 2xx status code
func (o *PutServiceIDInvalidFrontend) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put service Id invalid frontend response has a 3xx status code
func (o *PutServiceIDInvalidFrontend) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id invalid frontend response has a 4xx status code
func (o *PutServiceIDInvalidFrontend) IsClientError() bool {
	return true
}

// IsServerError returns true when this put service Id invalid frontend response has a 5xx status code
func (o *PutServiceIDInvalidFrontend) IsServerError() bool {
	return false
}

// IsCode returns true when this put service Id invalid frontend response a status code equal to that given
func (o *PutServiceIDInvalidFrontend) IsCode(code int) bool {
	return code == 460
}

// Code gets the status code for the put service Id invalid frontend response
func (o *PutServiceIDInvalidFrontend) Code() int {
	return 460
}

func (o *PutServiceIDInvalidFrontend) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdInvalidFrontend %s", 460, payload)
}

func (o *PutServiceIDInvalidFrontend) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdInvalidFrontend %s", 460, payload)
}

func (o *PutServiceIDInvalidFrontend) GetPayload() models.Error {
	return o.Payload
}

func (o *PutServiceIDInvalidFrontend) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutServiceIDInvalidBackend creates a PutServiceIDInvalidBackend with default headers values
func NewPutServiceIDInvalidBackend() *PutServiceIDInvalidBackend {
	return &PutServiceIDInvalidBackend{}
}

/*
PutServiceIDInvalidBackend describes a response with status code 461, with default header values.

Invalid backend in service configuration
*/
type PutServiceIDInvalidBackend struct {
	Payload models.Error
}

// IsSuccess returns true when this put service Id invalid backend response has a 2xx status code
func (o *PutServiceIDInvalidBackend) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put service Id invalid backend response has a 3xx status code
func (o *PutServiceIDInvalidBackend) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id invalid backend response has a 4xx status code
func (o *PutServiceIDInvalidBackend) IsClientError() bool {
	return true
}

// IsServerError returns true when this put service Id invalid backend response has a 5xx status code
func (o *PutServiceIDInvalidBackend) IsServerError() bool {
	return false
}

// IsCode returns true when this put service Id invalid backend response a status code equal to that given
func (o *PutServiceIDInvalidBackend) IsCode(code int) bool {
	return code == 461
}

// Code gets the status code for the put service Id invalid backend response
func (o *PutServiceIDInvalidBackend) Code() int {
	return 461
}

func (o *PutServiceIDInvalidBackend) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdInvalidBackend %s", 461, payload)
}

func (o *PutServiceIDInvalidBackend) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdInvalidBackend %s", 461, payload)
}

func (o *PutServiceIDInvalidBackend) GetPayload() models.Error {
	return o.Payload
}

func (o *PutServiceIDInvalidBackend) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutServiceIDFailure creates a PutServiceIDFailure with default headers values
func NewPutServiceIDFailure() *PutServiceIDFailure {
	return &PutServiceIDFailure{}
}

/*
PutServiceIDFailure describes a response with status code 500, with default header values.

Error while creating service
*/
type PutServiceIDFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this put service Id failure response has a 2xx status code
func (o *PutServiceIDFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put service Id failure response has a 3xx status code
func (o *PutServiceIDFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id failure response has a 4xx status code
func (o *PutServiceIDFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this put service Id failure response has a 5xx status code
func (o *PutServiceIDFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this put service Id failure response a status code equal to that given
func (o *PutServiceIDFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the put service Id failure response
func (o *PutServiceIDFailure) Code() int {
	return 500
}

func (o *PutServiceIDFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdFailure %s", 500, payload)
}

func (o *PutServiceIDFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdFailure %s", 500, payload)
}

func (o *PutServiceIDFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *PutServiceIDFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutServiceIDUpdateBackendFailure creates a PutServiceIDUpdateBackendFailure with default headers values
func NewPutServiceIDUpdateBackendFailure() *PutServiceIDUpdateBackendFailure {
	return &PutServiceIDUpdateBackendFailure{}
}

/*
PutServiceIDUpdateBackendFailure describes a response with status code 501, with default header values.

Error while updating backend states
*/
type PutServiceIDUpdateBackendFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this put service Id update backend failure response has a 2xx status code
func (o *PutServiceIDUpdateBackendFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put service Id update backend failure response has a 3xx status code
func (o *PutServiceIDUpdateBackendFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put service Id update backend failure response has a 4xx status code
func (o *PutServiceIDUpdateBackendFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this put service Id update backend failure response has a 5xx status code
func (o *PutServiceIDUpdateBackendFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this put service Id update backend failure response a status code equal to that given
func (o *PutServiceIDUpdateBackendFailure) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the put service Id update backend failure response
func (o *PutServiceIDUpdateBackendFailure) Code() int {
	return 501
}

func (o *PutServiceIDUpdateBackendFailure) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdUpdateBackendFailure %s", 501, payload)
}

func (o *PutServiceIDUpdateBackendFailure) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /service/{id}][%d] putServiceIdUpdateBackendFailure %s", 501, payload)
}

func (o *PutServiceIDUpdateBackendFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *PutServiceIDUpdateBackendFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
