// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { caretDownEmptyIcon } from '../icon';
import { classes } from '../utils';
import { DEFAULT_STYLE_CLASS } from './interface';
export const HTML_SELECT_CLASS = 'jp-HTMLSelect';
export class HTMLSelect extends React.Component {
    render() {
        const _a = this.props, { className, defaultStyle = true, disabled, elementRef, iconProps, icon = caretDownEmptyIcon, options = [] } = _a, htmlProps = __rest(_a, ["className", "defaultStyle", "disabled", "elementRef", "iconProps", "icon", "options"]);
        const cls = classes(HTML_SELECT_CLASS, {
            [DEFAULT_STYLE_CLASS]: defaultStyle
        }, className);
        const optionChildren = options.map(option => {
            const props = typeof option === 'object' ? option : { value: option };
            return (React.createElement("option", Object.assign({}, props, { key: props.value }), props.label || props.value));
        });
        return (React.createElement("div", { className: cls },
            React.createElement("select", Object.assign({ disabled: disabled, ref: elementRef }, htmlProps, { multiple: false }),
                optionChildren,
                htmlProps.children),
            React.createElement(icon.react, Object.assign({}, Object.assign({ tag: 'span', stylesheet: 'select', right: '7px', top: '5px' }, iconProps)))));
    }
}
//# sourceMappingURL=htmlselect.js.map