"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function selectValue(value, selected, all) {
  var at = all.indexOf(value);
  var updated = selected.slice(0, at).concat(value, selected.slice(at)); // As inserting values at predefined index positions doesn't work with empty
  // arrays, we need to reorder the updated selection to match the initial order

  return updated.sort(function (a, b) {
    return all.indexOf(a) > all.indexOf(b);
  });
}

function deselectValue(value, selected) {
  return selected.filter(function (v) {
    return v !== value;
  });
}

function CheckboxesWidget(props) {
  var id = props.id,
      disabled = props.disabled,
      options = props.options,
      value = props.value,
      autofocus = props.autofocus,
      readonly = props.readonly,
      _onChange = props.onChange;
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled,
      inline = options.inline;
  return _react["default"].createElement("div", {
    className: "checkboxes",
    id: id
  }, enumOptions.map(function (option, index) {
    var checked = value.indexOf(option.value) !== -1;
    var itemDisabled = enumDisabled && enumDisabled.indexOf(option.value) != -1;
    var disabledCls = disabled || itemDisabled || readonly ? "disabled" : "";

    var checkbox = _react["default"].createElement("span", null, _react["default"].createElement("input", {
      type: "checkbox",
      id: "".concat(id, "_").concat(index),
      checked: checked,
      disabled: disabled || itemDisabled || readonly,
      autoFocus: autofocus && index === 0,
      onChange: function onChange(event) {
        var all = enumOptions.map(function (_ref) {
          var value = _ref.value;
          return value;
        });

        if (event.target.checked) {
          _onChange(selectValue(option.value, value, all));
        } else {
          _onChange(deselectValue(option.value, value));
        }
      }
    }), _react["default"].createElement("span", null, option.label));

    return inline ? _react["default"].createElement("label", {
      key: index,
      className: "checkbox-inline ".concat(disabledCls)
    }, checkbox) : _react["default"].createElement("div", {
      key: index,
      className: "checkbox ".concat(disabledCls)
    }, _react["default"].createElement("label", null, checkbox));
  }));
}

CheckboxesWidget.defaultProps = {
  autofocus: false,
  options: {
    inline: false
  }
};

if (process.env.NODE_ENV !== "production") {
  CheckboxesWidget.propTypes = {
    schema: _propTypes["default"].object.isRequired,
    id: _propTypes["default"].string.isRequired,
    options: _propTypes["default"].shape({
      enumOptions: _propTypes["default"].array,
      inline: _propTypes["default"].bool
    }).isRequired,
    value: _propTypes["default"].any,
    required: _propTypes["default"].bool,
    readonly: _propTypes["default"].bool,
    disabled: _propTypes["default"].bool,
    multiple: _propTypes["default"].bool,
    autofocus: _propTypes["default"].bool,
    onChange: _propTypes["default"].func
  };
}

var _default = CheckboxesWidget;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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