package = "kong"
version = "3.7.0-0"
rockspec_format = "3.0"
supported_platforms = {"linux", "macosx"}
source = {
  url = "git+https://github.com/Kong/kong.git",
  tag = "3.7.0"
}
description = {
  summary = "Kong is a scalable and customizable API Management Layer built on top of Nginx.",
  homepage = "https://konghq.com",
  license = "Apache 2.0"
}
dependencies = {
  "inspect == 3.1.3",
  "luasec == 1.3.2",
  "luasocket == 3.0-rc1",
  "penlight == 1.13.1",
  "lua-resty-http == 0.17.1",
  "lua-resty-jit-uuid == 0.0.7",
  "lua-ffi-zlib == 0.6",
  "multipart == 0.5.9",
  "version == 1.0.1",
  "kong-lapis == 1.16.0.1",
  "kong-pgmoon == 1.16.2",
  "luatz == 0.4",
  "lua_system_constants == 0.1.4",
  "lyaml == 6.2.8",
  "luasyslog == 2.0.1",
  "lua_pack == 2.0.0",
  "binaryheap >= 0.4",
  "luaxxhash >= 1.0",
  "lua-protobuf == 0.5.0",
  "lua-resty-healthcheck == 3.0.1",
  "lua-messagepack == 0.5.4",
  "lua-resty-aws == 1.3.6",
  "lua-resty-openssl == 1.2.0",
  "lua-resty-counter == 0.2.1",
  "lua-resty-ipmatcher == 0.6.1",
  "lua-resty-acme == 0.12.0",
  "lua-resty-session == 4.0.5",
  "lua-resty-timer-ng == 0.2.6",
  "lpeg == 1.1.0",
  "lua-resty-ljsonschema == 1.1.6-2",
}
build = {
  type = "builtin",
  modules = {
    ["kong"] = "kong/init.lua",
    ["kong.meta"] = "kong/meta.lua",
    ["kong.cache"] = "kong/cache/init.lua",
    ["kong.cache.warmup"] = "kong/cache/warmup.lua",
    ["kong.global"] = "kong/global.lua",
    ["kong.reports"] = "kong/reports.lua",
    ["kong.constants"] = "kong/constants.lua",
    ["kong.concurrency"] = "kong/concurrency.lua",
    ["kong.deprecation"] = "kong/deprecation.lua",
    ["kong.globalpatches"] = "kong/globalpatches.lua",
    ["kong.error_handlers"] = "kong/error_handlers.lua",
    ["kong.hooks"] = "kong/hooks.lua",

    ["kong.router"] = "kong/router/init.lua",
    ["kong.router.traditional"] = "kong/router/traditional.lua",
    ["kong.router.compat"] = "kong/router/compat.lua",
    ["kong.router.expressions"] = "kong/router/expressions.lua",
    ["kong.router.atc"] = "kong/router/atc.lua",
    ["kong.router.fields"] = "kong/router/fields.lua",
    ["kong.router.utils"] = "kong/router/utils.lua",

    ["kong.conf_loader"] = "kong/conf_loader/init.lua",
    ["kong.conf_loader.constants"] = "kong/conf_loader/constants.lua",
    ["kong.conf_loader.parse"] = "kong/conf_loader/parse.lua",
    ["kong.conf_loader.listeners"] = "kong/conf_loader/listeners.lua",

    ["kong.clustering"] = "kong/clustering/init.lua",
    ["kong.clustering.data_plane"] = "kong/clustering/data_plane.lua",
    ["kong.clustering.control_plane"] = "kong/clustering/control_plane.lua",
    ["kong.clustering.utils"] = "kong/clustering/utils.lua",
    ["kong.clustering.events"] = "kong/clustering/events.lua",
    ["kong.clustering.compat"] = "kong/clustering/compat/init.lua",
    ["kong.clustering.compat.version"] = "kong/clustering/compat/version.lua",
    ["kong.clustering.compat.removed_fields"] = "kong/clustering/compat/removed_fields.lua",
    ["kong.clustering.compat.checkers"] = "kong/clustering/compat/checkers.lua",
    ["kong.clustering.config_helper"] = "kong/clustering/config_helper.lua",
    ["kong.clustering.tls"] = "kong/clustering/tls.lua",

    ["kong.cluster_events"] = "kong/cluster_events/init.lua",
    ["kong.cluster_events.strategies.postgres"] = "kong/cluster_events/strategies/postgres.lua",
    ["kong.cluster_events.strategies.off"] = "kong/cluster_events/strategies/off.lua",

    ["kong.templates.nginx"] = "kong/templates/nginx.lua",
    ["kong.templates.nginx_kong"] = "kong/templates/nginx_kong.lua",
    ["kong.templates.nginx_kong_gui_include"] = "kong/templates/nginx_kong_gui_include.lua",
    ["kong.templates.nginx_kong_stream"] = "kong/templates/nginx_kong_stream.lua",
    ["kong.templates.kong_defaults"] = "kong/templates/kong_defaults.lua",
    ["kong.templates.nginx_inject"] = "kong/templates/nginx_inject.lua",
    ["kong.templates.nginx_kong_inject"] = "kong/templates/nginx_kong_inject.lua",
    ["kong.templates.nginx_kong_stream_inject"] = "kong/templates/nginx_kong_stream_inject.lua",
    ["kong.templates.kong_yml"] = "kong/templates/kong_yml.lua",

    ["kong.resty.dns.client"] = "kong/resty/dns/client.lua",
    ["kong.resty.dns.utils"] = "kong/resty/dns/utils.lua",
    ["kong.resty.ctx"] = "kong/resty/ctx.lua",

    ["kong.resty.mlcache"] = "kong/resty/mlcache/init.lua",
    ["kong.resty.mlcache.ipc"] = "kong/resty/mlcache/ipc.lua",

    ["kong.cmd"] = "kong/cmd/init.lua",
    ["kong.cmd.roar"] = "kong/cmd/roar.lua",
    ["kong.cmd.stop"] = "kong/cmd/stop.lua",
    ["kong.cmd.quit"] = "kong/cmd/quit.lua",
    ["kong.cmd.start"] = "kong/cmd/start.lua",
    ["kong.cmd.check"] = "kong/cmd/check.lua",
    ["kong.cmd.config"] = "kong/cmd/config.lua",
    ["kong.cmd.reload"] = "kong/cmd/reload.lua",
    ["kong.cmd.restart"] = "kong/cmd/restart.lua",
    ["kong.cmd.prepare"] = "kong/cmd/prepare.lua",
    ["kong.cmd.migrations"] = "kong/cmd/migrations.lua",
    ["kong.cmd.health"] = "kong/cmd/health.lua",
    ["kong.cmd.vault"] = "kong/cmd/vault.lua",
    ["kong.cmd.version"] = "kong/cmd/version.lua",
    ["kong.cmd.hybrid"] = "kong/cmd/hybrid.lua",
    ["kong.cmd.utils.log"] = "kong/cmd/utils/log.lua",
    ["kong.cmd.utils.kill"] = "kong/cmd/utils/kill.lua",
    ["kong.cmd.utils.env"] = "kong/cmd/utils/env.lua",
    ["kong.cmd.utils.migrations"] = "kong/cmd/utils/migrations.lua",
    ["kong.cmd.utils.tty"] = "kong/cmd/utils/tty.lua",
    ["kong.cmd.utils.nginx_signals"] = "kong/cmd/utils/nginx_signals.lua",
    ["kong.cmd.utils.prefix_handler"] = "kong/cmd/utils/prefix_handler.lua",
    ["kong.cmd.utils.process_secrets"] = "kong/cmd/utils/process_secrets.lua",
    ["kong.cmd.utils.inject_confs"] = "kong/cmd/utils/inject_confs.lua",

    ["kong.api"] = "kong/api/init.lua",
    ["kong.api.api_helpers"] = "kong/api/api_helpers.lua",
    ["kong.api.arguments"] = "kong/api/arguments.lua",
    ["kong.api.endpoints"] = "kong/api/endpoints.lua",
    ["kong.api.routes.cache"] = "kong/api/routes/cache.lua",
    ["kong.api.routes.certificates"] = "kong/api/routes/certificates.lua",
    ["kong.api.routes.clustering"] = "kong/api/routes/clustering.lua",
    ["kong.api.routes.config"] = "kong/api/routes/config.lua",
    ["kong.api.routes.consumers"] = "kong/api/routes/consumers.lua",
    ["kong.api.routes.debug"] = "kong/api/routes/debug.lua",
    ["kong.api.routes.filter_chains"] = "kong/api/routes/filter_chains.lua",
    ["kong.api.routes.health"] = "kong/api/routes/health.lua",
    ["kong.api.routes.kong"] = "kong/api/routes/kong.lua",
    ["kong.api.routes.plugins"] = "kong/api/routes/plugins.lua",
    ["kong.api.routes.snis"] = "kong/api/routes/snis.lua",
    ["kong.api.routes.tags"] = "kong/api/routes/tags.lua",
    ["kong.api.routes.targets"] = "kong/api/routes/targets.lua",
    ["kong.api.routes.upstreams"] = "kong/api/routes/upstreams.lua",

    ["kong.admin_gui"] = "kong/admin_gui/init.lua",
    ["kong.admin_gui.utils"] = "kong/admin_gui/utils.lua",

    ["kong.status"] = "kong/status/init.lua",
    ["kong.status.ready"] = "kong/status/ready.lua",

    ["kong.tools.dns"] = "kong/tools/dns.lua",
    ["kong.tools.grpc"] = "kong/tools/grpc.lua",
    ["kong.tools.utils"] = "kong/tools/utils.lua",
    ["kong.tools.timestamp"] = "kong/tools/timestamp.lua",
    ["kong.tools.stream_api"] = "kong/tools/stream_api.lua",
    ["kong.tools.queue"] = "kong/tools/queue.lua",
    ["kong.tools.queue_schema"] = "kong/tools/queue_schema.lua",
    ["kong.tools.sandbox"] = "kong/tools/sandbox.lua",
    ["kong.tools.uri"] = "kong/tools/uri.lua",
    ["kong.tools.kong-lua-sandbox"] = "kong/tools/kong-lua-sandbox.lua",
    ["kong.tools.protobuf"] = "kong/tools/protobuf.lua",
    ["kong.tools.mime_type"] = "kong/tools/mime_type.lua",
    ["kong.tools.request_aware_table"] = "kong/tools/request_aware_table.lua",
    ["kong.tools.gzip"] = "kong/tools/gzip.lua",
    ["kong.tools.string"] = "kong/tools/string.lua",
    ["kong.tools.table"] = "kong/tools/table.lua",
    ["kong.tools.sha256"] = "kong/tools/sha256.lua",
    ["kong.tools.yield"] = "kong/tools/yield.lua",
    ["kong.tools.uuid"] = "kong/tools/uuid.lua",
    ["kong.tools.rand"] = "kong/tools/rand.lua",
    ["kong.tools.system"] = "kong/tools/system.lua",
    ["kong.tools.time"] = "kong/tools/time.lua",
    ["kong.tools.module"] = "kong/tools/module.lua",
    ["kong.tools.ip"] = "kong/tools/ip.lua",
    ["kong.tools.http"] = "kong/tools/http.lua",
    ["kong.tools.cjson"] = "kong/tools/cjson.lua",
    ["kong.tools.redis.schema"] = "kong/tools/redis/schema.lua",

    ["kong.runloop.handler"] = "kong/runloop/handler.lua",
    ["kong.runloop.events"] = "kong/runloop/events.lua",
    ["kong.runloop.log_level"] = "kong/runloop/log_level.lua",
    ["kong.runloop.certificate"] = "kong/runloop/certificate.lua",
    ["kong.runloop.plugins_iterator"] = "kong/runloop/plugins_iterator.lua",
    ["kong.runloop.upstream_ssl"] = "kong/runloop/upstream_ssl.lua",
    ["kong.runloop.balancer"] = "kong/runloop/balancer/init.lua",
    ["kong.runloop.balancer.balancers"] = "kong/runloop/balancer/balancers.lua",
    ["kong.runloop.balancer.consistent_hashing"] = "kong/runloop/balancer/consistent_hashing.lua",
    ["kong.runloop.balancer.healthcheckers"] = "kong/runloop/balancer/healthcheckers.lua",
    ["kong.runloop.balancer.least_connections"] = "kong/runloop/balancer/least_connections.lua",
    ["kong.runloop.balancer.latency"] = "kong/runloop/balancer/latency.lua",
    ["kong.runloop.balancer.round_robin"] = "kong/runloop/balancer/round_robin.lua",
    ["kong.runloop.balancer.targets"] = "kong/runloop/balancer/targets.lua",
    ["kong.runloop.balancer.upstreams"] = "kong/runloop/balancer/upstreams.lua",
    ["kong.runloop.plugin_servers"] = "kong/runloop/plugin_servers/init.lua",
    ["kong.runloop.plugin_servers.process"] = "kong/runloop/plugin_servers/process.lua",
    ["kong.runloop.plugin_servers.mp_rpc"] = "kong/runloop/plugin_servers/mp_rpc.lua",
    ["kong.runloop.plugin_servers.pb_rpc"] = "kong/runloop/plugin_servers/pb_rpc.lua",
    ["kong.runloop.wasm"] = "kong/runloop/wasm.lua",
    ["kong.runloop.wasm.properties"] = "kong/runloop/wasm/properties.lua",

    ["kong.workspaces"] = "kong/workspaces/init.lua",

    ["kong.db"] = "kong/db/init.lua",
    ["kong.db.utils"] = "kong/db/utils.lua",
    ["kong.db.errors"] = "kong/db/errors.lua",
    ["kong.db.iteration"] = "kong/db/iteration.lua",
    ["kong.db.dao"] = "kong/db/dao/init.lua",
    ["kong.db.dao.certificates"] = "kong/db/dao/certificates.lua",
    ["kong.db.dao.snis"] = "kong/db/dao/snis.lua",
    ["kong.db.dao.targets"] = "kong/db/dao/targets.lua",
    ["kong.db.dao.plugins"] = "kong/db/dao/plugins.lua",
    ["kong.db.dao.tags"] = "kong/db/dao/tags.lua",
    ["kong.db.dao.vaults"] = "kong/db/dao/vaults.lua",
    ["kong.db.dao.workspaces"] = "kong/db/dao/workspaces.lua",
    ["kong.db.dao.services"] = "kong/db/dao/services.lua",
    ["kong.db.dao.ca_certificates"] = "kong/db/dao/ca_certificates.lua",
    ["kong.db.declarative"] = "kong/db/declarative/init.lua",
    ["kong.db.declarative.marshaller"] = "kong/db/declarative/marshaller.lua",
    ["kong.db.declarative.export"] = "kong/db/declarative/export.lua",
    ["kong.db.declarative.import"] = "kong/db/declarative/import.lua",
    ["kong.db.schema"] = "kong/db/schema/init.lua",
    ["kong.db.dao.keys"] = "kong/db/dao/keys.lua",
    ["kong.db.dao.key_sets"] = "kong/db/dao/key_sets.lua",
    ["kong.db.schema.entities.keys"] = "kong/db/schema/entities/keys.lua",
    ["kong.db.schema.entities.key_sets"] = "kong/db/schema/entities/key_sets.lua",
    ["kong.db.schema.entities.consumers"] = "kong/db/schema/entities/consumers.lua",
    ["kong.db.schema.entities.routes"] = "kong/db/schema/entities/routes.lua",
    ["kong.db.schema.entities.routes_subschemas"] = "kong/db/schema/entities/routes_subschemas.lua",
    ["kong.db.schema.entities.services"] = "kong/db/schema/entities/services.lua",
    ["kong.db.schema.entities.certificates"] = "kong/db/schema/entities/certificates.lua",
    ["kong.db.schema.entities.snis"] = "kong/db/schema/entities/snis.lua",
    ["kong.db.schema.entities.upstreams"] = "kong/db/schema/entities/upstreams.lua",
    ["kong.db.schema.entities.targets"] = "kong/db/schema/entities/targets.lua",
    ["kong.db.schema.entities.plugins"] = "kong/db/schema/entities/plugins.lua",
    ["kong.db.schema.entities.tags"] = "kong/db/schema/entities/tags.lua",
    ["kong.db.schema.entities.ca_certificates"] = "kong/db/schema/entities/ca_certificates.lua",
    ["kong.db.schema.entities.vaults"] = "kong/db/schema/entities/vaults.lua",
    ["kong.db.schema.entities.workspaces"] = "kong/db/schema/entities/workspaces.lua",
    ["kong.db.schema.entities.clustering_data_planes"] = "kong/db/schema/entities/clustering_data_planes.lua",
    ["kong.db.schema.entities.parameters"] = "kong/db/schema/entities/parameters.lua",
    ["kong.db.schema.entities.filter_chains"] = "kong/db/schema/entities/filter_chains.lua",
    ["kong.db.schema.json"] = "kong/db/schema/json.lua",
    ["kong.db.schema.others.migrations"] = "kong/db/schema/others/migrations.lua",
    ["kong.db.schema.others.declarative_config"] = "kong/db/schema/others/declarative_config.lua",
    ["kong.db.schema.entity"] = "kong/db/schema/entity.lua",
    ["kong.db.schema.metaschema"] = "kong/db/schema/metaschema.lua",
    ["kong.db.schema.typedefs"] = "kong/db/schema/typedefs.lua",
    ["kong.db.schema.plugin_loader"] = "kong/db/schema/plugin_loader.lua",
    ["kong.db.schema.vault_loader"] = "kong/db/schema/vault_loader.lua",
    ["kong.db.schema.topological_sort"] = "kong/db/schema/topological_sort.lua",
    ["kong.db.strategies"] = "kong/db/strategies/init.lua",
    ["kong.db.strategies.connector"] = "kong/db/strategies/connector.lua",
    ["kong.db.strategies.postgres"] = "kong/db/strategies/postgres/init.lua",
    ["kong.db.strategies.postgres.connector"] = "kong/db/strategies/postgres/connector.lua",
    ["kong.db.strategies.postgres.tags"] = "kong/db/strategies/postgres/tags.lua",
    ["kong.db.strategies.postgres.services"] = "kong/db/strategies/postgres/services.lua",
    ["kong.db.strategies.postgres.plugins"] = "kong/db/strategies/postgres/plugins.lua",
    ["kong.db.strategies.off"] = "kong/db/strategies/off/init.lua",
    ["kong.db.strategies.off.connector"] = "kong/db/strategies/off/connector.lua",
    ["kong.db.strategies.off.tags"] = "kong/db/strategies/off/tags.lua",

    ["kong.db.migrations.state"] = "kong/db/migrations/state.lua",
    ["kong.db.migrations.subsystems"] = "kong/db/migrations/subsystems.lua",
    ["kong.db.migrations.core"] = "kong/db/migrations/core/init.lua",
    ["kong.db.migrations.core.000_base"] = "kong/db/migrations/core/000_base.lua",
    ["kong.db.migrations.core.003_100_to_110"] = "kong/db/migrations/core/003_100_to_110.lua",
    ["kong.db.migrations.core.004_110_to_120"] = "kong/db/migrations/core/004_110_to_120.lua",
    ["kong.db.migrations.core.005_120_to_130"] = "kong/db/migrations/core/005_120_to_130.lua",
    ["kong.db.migrations.core.006_130_to_140"] = "kong/db/migrations/core/006_130_to_140.lua",
    ["kong.db.migrations.core.007_140_to_150"] = "kong/db/migrations/core/007_140_to_150.lua",
    ["kong.db.migrations.core.008_150_to_200"] = "kong/db/migrations/core/008_150_to_200.lua",
    ["kong.db.migrations.core.009_200_to_210"] = "kong/db/migrations/core/009_200_to_210.lua",
    ["kong.db.migrations.core.010_210_to_211"] = "kong/db/migrations/core/010_210_to_211.lua",
    ["kong.db.migrations.core.011_212_to_213"] = "kong/db/migrations/core/011_212_to_213.lua",
    ["kong.db.migrations.core.012_213_to_220"] = "kong/db/migrations/core/012_213_to_220.lua",
    ["kong.db.migrations.core.013_220_to_230"] = "kong/db/migrations/core/013_220_to_230.lua",
    ["kong.db.migrations.core.014_230_to_270"] = "kong/db/migrations/core/014_230_to_270.lua",
    ["kong.db.migrations.core.015_270_to_280"] = "kong/db/migrations/core/015_270_to_280.lua",
    ["kong.db.migrations.core.016_280_to_300"] = "kong/db/migrations/core/016_280_to_300.lua",
    ["kong.db.migrations.core.017_300_to_310"] = "kong/db/migrations/core/017_300_to_310.lua",
    ["kong.db.migrations.core.018_310_to_320"] = "kong/db/migrations/core/018_310_to_320.lua",
    ["kong.db.migrations.core.019_320_to_330"] = "kong/db/migrations/core/019_320_to_330.lua",
    ["kong.db.migrations.core.020_330_to_340"] = "kong/db/migrations/core/020_330_to_340.lua",
    ["kong.db.migrations.core.021_340_to_350"] = "kong/db/migrations/core/021_340_to_350.lua",
    ["kong.db.migrations.core.022_350_to_360"] = "kong/db/migrations/core/022_350_to_360.lua",
    ["kong.db.migrations.operations.200_to_210"] = "kong/db/migrations/operations/200_to_210.lua",
    ["kong.db.migrations.operations.212_to_213"] = "kong/db/migrations/operations/212_to_213.lua",
    ["kong.db.migrations.operations.280_to_300"] = "kong/db/migrations/operations/280_to_300.lua",
    ["kong.db.migrations.migrate_path_280_300"] = "kong/db/migrations/migrate_path_280_300.lua",
    ["kong.db.declarative.migrations"] = "kong/db/declarative/migrations/init.lua",
    ["kong.db.declarative.migrations.route_path"] = "kong/db/declarative/migrations/route_path.lua",

    ["kong.pdk"] = "kong/pdk/init.lua",
    ["kong.pdk.private.checks"] = "kong/pdk/private/checks.lua",
    ["kong.pdk.private.phases"] = "kong/pdk/private/phases.lua",
    ["kong.pdk.private.node"] = "kong/pdk/private/node.lua",
    ["kong.pdk.client"] = "kong/pdk/client.lua",
    ["kong.pdk.client.tls"] = "kong/pdk/client/tls.lua",
    ["kong.pdk.ctx"] = "kong/pdk/ctx.lua",
    ["kong.pdk.ip"] = "kong/pdk/ip.lua",
    ["kong.pdk.log"] = "kong/pdk/log.lua",
    ["kong.pdk.service"] = "kong/pdk/service.lua",
    ["kong.pdk.service.request"] = "kong/pdk/service/request.lua",
    ["kong.pdk.service.response"] = "kong/pdk/service/response.lua",
    ["kong.pdk.router"] = "kong/pdk/router.lua",
    ["kong.pdk.request"] = "kong/pdk/request.lua",
    ["kong.pdk.response"] = "kong/pdk/response.lua",
    ["kong.pdk.table"] = "kong/pdk/table.lua",
    ["kong.pdk.node"] = "kong/pdk/node.lua",
    ["kong.pdk.nginx"] = "kong/pdk/nginx.lua",
    ["kong.pdk.cluster"] = "kong/pdk/cluster.lua",
    ["kong.pdk.vault"] = "kong/pdk/vault.lua",
    ["kong.pdk.tracing"] = "kong/pdk/tracing.lua",
    ["kong.pdk.plugin"] = "kong/pdk/plugin.lua",

    ["kong.plugins.basic-auth.migrations"] = "kong/plugins/basic-auth/migrations/init.lua",
    ["kong.plugins.basic-auth.migrations.000_base_basic_auth"] = "kong/plugins/basic-auth/migrations/000_base_basic_auth.lua",
    ["kong.plugins.basic-auth.migrations.002_130_to_140"] = "kong/plugins/basic-auth/migrations/002_130_to_140.lua",
    ["kong.plugins.basic-auth.migrations.003_200_to_210"] = "kong/plugins/basic-auth/migrations/003_200_to_210.lua",
    ["kong.plugins.basic-auth.crypto"] = "kong/plugins/basic-auth/crypto.lua",
    ["kong.plugins.basic-auth.handler"] = "kong/plugins/basic-auth/handler.lua",
    ["kong.plugins.basic-auth.access"] = "kong/plugins/basic-auth/access.lua",
    ["kong.plugins.basic-auth.schema"] = "kong/plugins/basic-auth/schema.lua",
    ["kong.plugins.basic-auth.daos"] = "kong/plugins/basic-auth/daos.lua",

    ["kong.plugins.key-auth.migrations"] = "kong/plugins/key-auth/migrations/init.lua",
    ["kong.plugins.key-auth.migrations.000_base_key_auth"] = "kong/plugins/key-auth/migrations/000_base_key_auth.lua",
    ["kong.plugins.key-auth.migrations.002_130_to_140"] = "kong/plugins/key-auth/migrations/002_130_to_140.lua",
    ["kong.plugins.key-auth.migrations.003_200_to_210"] = "kong/plugins/key-auth/migrations/003_200_to_210.lua",
    ["kong.plugins.key-auth.migrations.004_320_to_330"] = "kong/plugins/key-auth/migrations/004_320_to_330.lua",
    ["kong.plugins.key-auth.handler"] = "kong/plugins/key-auth/handler.lua",
    ["kong.plugins.key-auth.schema"] = "kong/plugins/key-auth/schema.lua",
    ["kong.plugins.key-auth.daos"] = "kong/plugins/key-auth/daos.lua",

    ["kong.plugins.oauth2.migrations"] = "kong/plugins/oauth2/migrations/init.lua",
    ["kong.plugins.oauth2.migrations.000_base_oauth2"] = "kong/plugins/oauth2/migrations/000_base_oauth2.lua",
    ["kong.plugins.oauth2.migrations.003_130_to_140"] = "kong/plugins/oauth2/migrations/003_130_to_140.lua",
    ["kong.plugins.oauth2.migrations.004_200_to_210"] = "kong/plugins/oauth2/migrations/004_200_to_210.lua",
    ["kong.plugins.oauth2.migrations.005_210_to_211"] = "kong/plugins/oauth2/migrations/005_210_to_211.lua",
    ["kong.plugins.oauth2.migrations.006_320_to_330"] = "kong/plugins/oauth2/migrations/006_320_to_330.lua",
    ["kong.plugins.oauth2.migrations.007_320_to_330"] = "kong/plugins/oauth2/migrations/007_320_to_330.lua",
    ["kong.plugins.oauth2.handler"] = "kong/plugins/oauth2/handler.lua",
    ["kong.plugins.oauth2.secret"] = "kong/plugins/oauth2/secret.lua",
    ["kong.plugins.oauth2.access"] = "kong/plugins/oauth2/access.lua",
    ["kong.plugins.oauth2.schema"] = "kong/plugins/oauth2/schema.lua",
    ["kong.plugins.oauth2.daos"] = "kong/plugins/oauth2/daos.lua",
    ["kong.plugins.oauth2.daos.oauth2_tokens"] = "kong/plugins/oauth2/daos/oauth2_tokens.lua",

    ["kong.plugins.tcp-log.handler"] = "kong/plugins/tcp-log/handler.lua",
    ["kong.plugins.tcp-log.schema"] = "kong/plugins/tcp-log/schema.lua",

    ["kong.plugins.udp-log.handler"] = "kong/plugins/udp-log/handler.lua",
    ["kong.plugins.udp-log.schema"] = "kong/plugins/udp-log/schema.lua",

    ["kong.plugins.http-log.handler"] = "kong/plugins/http-log/handler.lua",
    ["kong.plugins.http-log.schema"] = "kong/plugins/http-log/schema.lua",
    ["kong.plugins.http-log.migrations"] = "kong/plugins/http-log/migrations/init.lua",
    ["kong.plugins.http-log.migrations.001_280_to_300"] = "kong/plugins/http-log/migrations/001_280_to_300.lua",

    ["kong.plugins.file-log.handler"] = "kong/plugins/file-log/handler.lua",
    ["kong.plugins.file-log.schema"] = "kong/plugins/file-log/schema.lua",

    ["kong.plugins.rate-limiting.migrations"] = "kong/plugins/rate-limiting/migrations/init.lua",
    ["kong.plugins.rate-limiting.migrations.000_base_rate_limiting"] = "kong/plugins/rate-limiting/migrations/000_base_rate_limiting.lua",
    ["kong.plugins.rate-limiting.migrations.003_10_to_112"] = "kong/plugins/rate-limiting/migrations/003_10_to_112.lua",
    ["kong.plugins.rate-limiting.migrations.004_200_to_210"] = "kong/plugins/rate-limiting/migrations/004_200_to_210.lua",
    ["kong.plugins.rate-limiting.migrations.005_320_to_330"] = "kong/plugins/rate-limiting/migrations/005_320_to_330.lua",
    ["kong.plugins.rate-limiting.migrations.006_350_to_360"] = "kong/plugins/rate-limiting/migrations/006_350_to_360.lua",
    ["kong.plugins.rate-limiting.expiration"] = "kong/plugins/rate-limiting/expiration.lua",
    ["kong.plugins.rate-limiting.handler"] = "kong/plugins/rate-limiting/handler.lua",
    ["kong.plugins.rate-limiting.schema"] = "kong/plugins/rate-limiting/schema.lua",
    ["kong.plugins.rate-limiting.daos"] = "kong/plugins/rate-limiting/daos.lua",
    ["kong.plugins.rate-limiting.policies"] = "kong/plugins/rate-limiting/policies/init.lua",
    ["kong.plugins.rate-limiting.policies.cluster"] = "kong/plugins/rate-limiting/policies/cluster.lua",
    ["kong.plugins.rate-limiting.clustering.compat.redis_translation"] = "kong/plugins/rate-limiting/clustering/compat/redis_translation.lua",

    ["kong.plugins.response-ratelimiting.migrations"] = "kong/plugins/response-ratelimiting/migrations/init.lua",
    ["kong.plugins.response-ratelimiting.migrations.000_base_response_rate_limiting"] = "kong/plugins/response-ratelimiting/migrations/000_base_response_rate_limiting.lua",
    ["kong.plugins.response-ratelimiting.migrations.001_350_to_360"] = "kong/plugins/response-ratelimiting/migrations/001_350_to_360.lua",
    ["kong.plugins.response-ratelimiting.handler"] = "kong/plugins/response-ratelimiting/handler.lua",
    ["kong.plugins.response-ratelimiting.access"] = "kong/plugins/response-ratelimiting/access.lua",
    ["kong.plugins.response-ratelimiting.header_filter"] = "kong/plugins/response-ratelimiting/header_filter.lua",
    ["kong.plugins.response-ratelimiting.log"] = "kong/plugins/response-ratelimiting/log.lua",
    ["kong.plugins.response-ratelimiting.schema"] = "kong/plugins/response-ratelimiting/schema.lua",
    ["kong.plugins.response-ratelimiting.policies"] = "kong/plugins/response-ratelimiting/policies/init.lua",
    ["kong.plugins.response-ratelimiting.policies.cluster"] = "kong/plugins/response-ratelimiting/policies/cluster.lua",
    ["kong.plugins.response-ratelimiting.clustering.compat.redis_translation"] = "kong/plugins/response-ratelimiting/clustering/compat/redis_translation.lua",

    ["kong.plugins.request-size-limiting.handler"] = "kong/plugins/request-size-limiting/handler.lua",
    ["kong.plugins.request-size-limiting.schema"] = "kong/plugins/request-size-limiting/schema.lua",

    ["kong.plugins.response-transformer.handler"] = "kong/plugins/response-transformer/handler.lua",
    ["kong.plugins.response-transformer.body_transformer"] = "kong/plugins/response-transformer/body_transformer.lua",
    ["kong.plugins.response-transformer.header_transformer"] = "kong/plugins/response-transformer/header_transformer.lua",
    ["kong.plugins.response-transformer.schema"] = "kong/plugins/response-transformer/schema.lua",

    ["kong.plugins.cors.handler"] = "kong/plugins/cors/handler.lua",
    ["kong.plugins.cors.schema"] = "kong/plugins/cors/schema.lua",

    ["kong.plugins.ip-restriction.handler"] = "kong/plugins/ip-restriction/handler.lua",
    ["kong.plugins.ip-restriction.schema"] = "kong/plugins/ip-restriction/schema.lua",
    ["kong.plugins.ip-restriction.migrations"] = "kong/plugins/ip-restriction/migrations/init.lua",
    ["kong.plugins.ip-restriction.migrations.001_200_to_210"] = "kong/plugins/ip-restriction/migrations/001_200_to_210.lua",

    ["kong.plugins.acl.migrations"] = "kong/plugins/acl/migrations/init.lua",
    ["kong.plugins.acl.migrations.000_base_acl"] = "kong/plugins/acl/migrations/000_base_acl.lua",
    ["kong.plugins.acl.migrations.002_130_to_140"] = "kong/plugins/acl/migrations/002_130_to_140.lua",
    ["kong.plugins.acl.migrations.003_200_to_210"] = "kong/plugins/acl/migrations/003_200_to_210.lua",
    ["kong.plugins.acl.migrations.004_212_to_213"] = "kong/plugins/acl/migrations/004_212_to_213.lua",
    ["kong.plugins.acl.handler"] = "kong/plugins/acl/handler.lua",
    ["kong.plugins.acl.schema"] = "kong/plugins/acl/schema.lua",
    ["kong.plugins.acl.daos"] = "kong/plugins/acl/daos.lua",
    ["kong.plugins.acl.groups"] = "kong/plugins/acl/groups.lua",
    ["kong.plugins.acl.acls"] = "kong/plugins/acl/acls.lua",
    ["kong.plugins.acl.api"] = "kong/plugins/acl/api.lua",

    ["kong.plugins.correlation-id.handler"] = "kong/plugins/correlation-id/handler.lua",
    ["kong.plugins.correlation-id.schema"] = "kong/plugins/correlation-id/schema.lua",

    ["kong.plugins.jwt.migrations"] = "kong/plugins/jwt/migrations/init.lua",
    ["kong.plugins.jwt.migrations.000_base_jwt"] = "kong/plugins/jwt/migrations/000_base_jwt.lua",
    ["kong.plugins.jwt.migrations.002_130_to_140"] = "kong/plugins/jwt/migrations/002_130_to_140.lua",
    ["kong.plugins.jwt.migrations.003_200_to_210"] = "kong/plugins/jwt/migrations/003_200_to_210.lua",
    ["kong.plugins.jwt.handler"] = "kong/plugins/jwt/handler.lua",
    ["kong.plugins.jwt.schema"] = "kong/plugins/jwt/schema.lua",
    ["kong.plugins.jwt.daos"] = "kong/plugins/jwt/daos.lua",
    ["kong.plugins.jwt.jwt_parser"] = "kong/plugins/jwt/jwt_parser.lua",

    ["kong.plugins.hmac-auth.migrations"] = "kong/plugins/hmac-auth/migrations/init.lua",
    ["kong.plugins.hmac-auth.migrations.000_base_hmac_auth"] = "kong/plugins/hmac-auth/migrations/000_base_hmac_auth.lua",
    ["kong.plugins.hmac-auth.migrations.002_130_to_140"] = "kong/plugins/hmac-auth/migrations/002_130_to_140.lua",
    ["kong.plugins.hmac-auth.migrations.003_200_to_210"] = "kong/plugins/hmac-auth/migrations/003_200_to_210.lua",
    ["kong.plugins.hmac-auth.handler"] = "kong/plugins/hmac-auth/handler.lua",
    ["kong.plugins.hmac-auth.access"] = "kong/plugins/hmac-auth/access.lua",
    ["kong.plugins.hmac-auth.schema"] = "kong/plugins/hmac-auth/schema.lua",
    ["kong.plugins.hmac-auth.daos"] = "kong/plugins/hmac-auth/daos.lua",

    ["kong.plugins.ldap-auth.handler"] = "kong/plugins/ldap-auth/handler.lua",
    ["kong.plugins.ldap-auth.access"] = "kong/plugins/ldap-auth/access.lua",
    ["kong.plugins.ldap-auth.schema"] = "kong/plugins/ldap-auth/schema.lua",
    ["kong.plugins.ldap-auth.ldap"] = "kong/plugins/ldap-auth/ldap.lua",
    ["kong.plugins.ldap-auth.asn1"] = "kong/plugins/ldap-auth/asn1.lua",

    ["kong.plugins.syslog.handler"] = "kong/plugins/syslog/handler.lua",
    ["kong.plugins.syslog.schema"] = "kong/plugins/syslog/schema.lua",

    ["kong.plugins.loggly.handler"] = "kong/plugins/loggly/handler.lua",
    ["kong.plugins.loggly.schema"] = "kong/plugins/loggly/schema.lua",

    ["kong.plugins.datadog.handler"] = "kong/plugins/datadog/handler.lua",
    ["kong.plugins.datadog.schema"] = "kong/plugins/datadog/schema.lua",
    ["kong.plugins.datadog.statsd_logger"] = "kong/plugins/datadog/statsd_logger.lua",

    ["kong.plugins.statsd.constants"] = "kong/plugins/statsd/constants.lua",
    ["kong.plugins.statsd.handler"] = "kong/plugins/statsd/handler.lua",
    ["kong.plugins.statsd.log"] = "kong/plugins/statsd/log.lua",
    ["kong.plugins.statsd.schema"] = "kong/plugins/statsd/schema.lua",
    ["kong.plugins.statsd.statsd_logger"] = "kong/plugins/statsd/statsd_logger.lua",

    ["kong.plugins.bot-detection.handler"] = "kong/plugins/bot-detection/handler.lua",
    ["kong.plugins.bot-detection.schema"] = "kong/plugins/bot-detection/schema.lua",
    ["kong.plugins.bot-detection.rules"] = "kong/plugins/bot-detection/rules.lua",
    ["kong.plugins.bot-detection.migrations"] = "kong/plugins/bot-detection/migrations/init.lua",
    ["kong.plugins.bot-detection.migrations.001_200_to_210"] = "kong/plugins/bot-detection/migrations/001_200_to_210.lua",

    ["kong.plugins.request-termination.handler"] = "kong/plugins/request-termination/handler.lua",
    ["kong.plugins.request-termination.schema"] = "kong/plugins/request-termination/schema.lua",

    ["kong.plugins.aws-lambda.handler"]              = "kong/plugins/aws-lambda/handler.lua",
    ["kong.plugins.aws-lambda.schema"]               = "kong/plugins/aws-lambda/schema.lua",
    ["kong.plugins.aws-lambda.request-util"]         = "kong/plugins/aws-lambda/request-util.lua",

    ["kong.plugins.grpc-gateway.deco"] = "kong/plugins/grpc-gateway/deco.lua",
    ["kong.plugins.grpc-gateway.handler"] = "kong/plugins/grpc-gateway/handler.lua",
    ["kong.plugins.grpc-gateway.schema"] = "kong/plugins/grpc-gateway/schema.lua",

    ["kong.plugins.acme.api"] = "kong/plugins/acme/api.lua",
    ["kong.plugins.acme.client"] = "kong/plugins/acme/client.lua",
    ["kong.plugins.acme.clustering.compat.redis_translation"] = "kong/plugins/acme/clustering/compat/redis_translation.lua",
    ["kong.plugins.acme.daos"] = "kong/plugins/acme/daos.lua",
    ["kong.plugins.acme.handler"] = "kong/plugins/acme/handler.lua",
    ["kong.plugins.acme.migrations.000_base_acme"] = "kong/plugins/acme/migrations/000_base_acme.lua",
    ["kong.plugins.acme.migrations.001_280_to_300"] = "kong/plugins/acme/migrations/001_280_to_300.lua",
    ["kong.plugins.acme.migrations.002_320_to_330"] = "kong/plugins/acme/migrations/002_320_to_330.lua",
    ["kong.plugins.acme.migrations.003_350_to_360"] = "kong/plugins/acme/migrations/003_350_to_360.lua",
    ["kong.plugins.acme.migrations"] = "kong/plugins/acme/migrations/init.lua",
    ["kong.plugins.acme.schema"] = "kong/plugins/acme/schema.lua",
    ["kong.plugins.acme.storage.kong"] = "kong/plugins/acme/storage/kong.lua",
    ["kong.plugins.acme.storage.config_adapters"] = "kong/plugins/acme/storage/config_adapters/init.lua",
    ["kong.plugins.acme.storage.config_adapters.redis"] = "kong/plugins/acme/storage/config_adapters/redis.lua",
    ["kong.plugins.acme.reserved_words"] = "kong/plugins/acme/reserved_words.lua",

    ["kong.plugins.prometheus.api"] = "kong/plugins/prometheus/api.lua",
    ["kong.plugins.prometheus.status_api"] = "kong/plugins/prometheus/status_api.lua",
    ["kong.plugins.prometheus.exporter"] = "kong/plugins/prometheus/exporter.lua",
    ["kong.plugins.prometheus.handler"] = "kong/plugins/prometheus/handler.lua",
    ["kong.plugins.prometheus.prometheus"] = "kong/plugins/prometheus/prometheus.lua",
    ["kong.plugins.prometheus.serve"] = "kong/plugins/prometheus/serve.lua",
    ["kong.plugins.prometheus.schema"] = "kong/plugins/prometheus/schema.lua",

    ["kong.plugins.session.handler"] = "kong/plugins/session/handler.lua",
    ["kong.plugins.session.schema"] = "kong/plugins/session/schema.lua",
    ["kong.plugins.session.access"] = "kong/plugins/session/access.lua",
    ["kong.plugins.session.header_filter"] = "kong/plugins/session/header_filter.lua",
    ["kong.plugins.session.session"] = "kong/plugins/session/session.lua",
    ["kong.plugins.session.daos"] = "kong/plugins/session/daos.lua",
    ["kong.plugins.session.storage.kong"] = "kong/plugins/session/storage/kong.lua",
    ["kong.plugins.session.migrations.000_base_session"] = "kong/plugins/session/migrations/000_base_session.lua",
    ["kong.plugins.session.migrations.001_add_ttl_index"] = "kong/plugins/session/migrations/001_add_ttl_index.lua",
    ["kong.plugins.session.migrations.002_320_to_330"] = "kong/plugins/session/migrations/002_320_to_330.lua",
    ["kong.plugins.session.migrations"] = "kong/plugins/session/migrations/init.lua",

    ["kong.plugins.proxy-cache.handler"]              = "kong/plugins/proxy-cache/handler.lua",
    ["kong.plugins.proxy-cache.cache_key"]            = "kong/plugins/proxy-cache/cache_key.lua",
    ["kong.plugins.proxy-cache.schema"]               = "kong/plugins/proxy-cache/schema.lua",
    ["kong.plugins.proxy-cache.api"]                  = "kong/plugins/proxy-cache/api.lua",
    ["kong.plugins.proxy-cache.strategies"]           = "kong/plugins/proxy-cache/strategies/init.lua",
    ["kong.plugins.proxy-cache.strategies.memory"]    = "kong/plugins/proxy-cache/strategies/memory.lua",

    ["kong.plugins.grpc-web.deco"] = "kong/plugins/grpc-web/deco.lua",
    ["kong.plugins.grpc-web.handler"] = "kong/plugins/grpc-web/handler.lua",
    ["kong.plugins.grpc-web.schema"] = "kong/plugins/grpc-web/schema.lua",

    ["kong.plugins.pre-function._handler"] = "kong/plugins/pre-function/_handler.lua",
    ["kong.plugins.pre-function._schema"] = "kong/plugins/pre-function/_schema.lua",
    ["kong.plugins.pre-function.migrations._001_280_to_300"] = "kong/plugins/pre-function/migrations/_001_280_to_300.lua",

    ["kong.plugins.pre-function.handler"] = "kong/plugins/pre-function/handler.lua",
    ["kong.plugins.pre-function.schema"] = "kong/plugins/pre-function/schema.lua",
    ["kong.plugins.pre-function.migrations"] = "kong/plugins/pre-function/migrations/init.lua",
    ["kong.plugins.pre-function.migrations.001_280_to_300"] = "kong/plugins/pre-function/migrations/001_280_to_300.lua",

    ["kong.plugins.post-function.handler"] = "kong/plugins/post-function/handler.lua",
    ["kong.plugins.post-function.schema"] = "kong/plugins/post-function/schema.lua",
    ["kong.plugins.post-function.migrations"] = "kong/plugins/post-function/migrations/init.lua",
    ["kong.plugins.post-function.migrations.001_280_to_300"] = "kong/plugins/post-function/migrations/001_280_to_300.lua",

    ["kong.plugins.zipkin.handler"] = "kong/plugins/zipkin/handler.lua",
    ["kong.plugins.zipkin.reporter"] = "kong/plugins/zipkin/reporter.lua",
    ["kong.plugins.zipkin.span"] = "kong/plugins/zipkin/span.lua",
    ["kong.plugins.zipkin.schema"] = "kong/plugins/zipkin/schema.lua",
    ["kong.plugins.zipkin.request_tags"] = "kong/plugins/zipkin/request_tags.lua",

    ["kong.plugins.request-transformer.migrations.postgres"] = "kong/plugins/request-transformer/migrations/postgres.lua",
    ["kong.plugins.request-transformer.migrations.common"] = "kong/plugins/request-transformer/migrations/common.lua",
    ["kong.plugins.request-transformer.handler"] = "kong/plugins/request-transformer/handler.lua",
    ["kong.plugins.request-transformer.access"] = "kong/plugins/request-transformer/access.lua",
    ["kong.plugins.request-transformer.schema"] = "kong/plugins/request-transformer/schema.lua",

    ["kong.plugins.azure-functions.handler"] = "kong/plugins/azure-functions/handler.lua",
    ["kong.plugins.azure-functions.schema"]  = "kong/plugins/azure-functions/schema.lua",

    ["kong.plugins.opentelemetry.handler"] = "kong/plugins/opentelemetry/handler.lua",
    ["kong.plugins.opentelemetry.schema"]  = "kong/plugins/opentelemetry/schema.lua",
    ["kong.plugins.opentelemetry.proto"]  = "kong/plugins/opentelemetry/proto.lua",
    ["kong.plugins.opentelemetry.otlp"]  = "kong/plugins/opentelemetry/otlp.lua",

    ["kong.plugins.ai-proxy.handler"] = "kong/plugins/ai-proxy/handler.lua",
    ["kong.plugins.ai-proxy.schema"] = "kong/plugins/ai-proxy/schema.lua",

    ["kong.plugins.ai-request-transformer.handler"] = "kong/plugins/ai-request-transformer/handler.lua",
    ["kong.plugins.ai-request-transformer.schema"] = "kong/plugins/ai-request-transformer/schema.lua",

    ["kong.plugins.ai-response-transformer.handler"] = "kong/plugins/ai-response-transformer/handler.lua",
    ["kong.plugins.ai-response-transformer.schema"] = "kong/plugins/ai-response-transformer/schema.lua",

    ["kong.llm"] = "kong/llm/init.lua",
    ["kong.llm.drivers.shared"] = "kong/llm/drivers/shared.lua",
    ["kong.llm.drivers.openai"] = "kong/llm/drivers/openai.lua",
    ["kong.llm.drivers.azure"] = "kong/llm/drivers/azure.lua",
    ["kong.llm.drivers.cohere"] = "kong/llm/drivers/cohere.lua",
    ["kong.llm.drivers.anthropic"] = "kong/llm/drivers/anthropic.lua",
    ["kong.llm.drivers.mistral"] = "kong/llm/drivers/mistral.lua",
    ["kong.llm.drivers.llama2"] = "kong/llm/drivers/llama2.lua",

    ["kong.plugins.ai-prompt-decorator.handler"] = "kong/plugins/ai-prompt-decorator/handler.lua",
    ["kong.plugins.ai-prompt-decorator.schema"]  = "kong/plugins/ai-prompt-decorator/schema.lua",

    ["kong.plugins.ai-prompt-template.handler"] = "kong/plugins/ai-prompt-template/handler.lua",
    ["kong.plugins.ai-prompt-template.schema"]  = "kong/plugins/ai-prompt-template/schema.lua",
    ["kong.plugins.ai-prompt-template.templater"]  = "kong/plugins/ai-prompt-template/templater.lua",

    ["kong.plugins.ai-prompt-guard.handler"] = "kong/plugins/ai-prompt-guard/handler.lua",
    ["kong.plugins.ai-prompt-guard.schema"]  = "kong/plugins/ai-prompt-guard/schema.lua",

    ["kong.vaults.env"] = "kong/vaults/env/init.lua",
    ["kong.vaults.env.schema"] = "kong/vaults/env/schema.lua",

    ["kong.tracing.instrumentation"] = "kong/tracing/instrumentation.lua",
    ["kong.tracing.propagation"] = "kong/tracing/propagation.lua",
    ["kong.tracing.request_id"] = "kong/tracing/request_id.lua",
    ["kong.tracing.tracing_context"] = "kong/tracing/tracing_context.lua",

    ["kong.timing"] = "kong/timing/init.lua",
    ["kong.timing.context"] = "kong/timing/context.lua",
    ["kong.timing.hooks"] = "kong/timing/hooks/init.lua",
    ["kong.timing.hooks.dns"] = "kong/timing/hooks/dns.lua",
    ["kong.timing.hooks.http"] = "kong/timing/hooks/http.lua",
    ["kong.timing.hooks.redis"] = "kong/timing/hooks/redis.lua",
    ["kong.timing.hooks.socket"] = "kong/timing/hooks/socket.lua",

    ["kong.dynamic_hook"] = "kong/dynamic_hook/init.lua",
    ["kong.dynamic_hook.wrap_function_gen"] = "kong/dynamic_hook/wrap_function_gen.lua",
  }
}
