# Announce: Rakudo Perl 6 compiler, Release 2017.04.3

On behalf of the Rakudo development team, I'm announcing an
out-of-schedule release of the Rakudo Perl 6 compiler.
Rakudo is an implementation of Perl 6 on the Moar Virtual Machine[^1].

This release is a point release in addition to the regular, monthly
releases. This release fixes an issue with `)>` regex capture working
incorrectly when .MATCH is called, e.g. in grammar actions. In addition,
it fixes false positive regex matches when using case-insensitive regexes
and start of string and end of string match. Also, it fixes failure to
load history file when using REPL with Linenoise or Readline on OSX. Last
but not least, this release tests how many point releases is too many :)

As mentioned in previous release announcement, we're working on a system
to do extended testing during and before releases that will include testing
of multiple ecosystem modules. This will prevent issues that require point releases.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

**This point release requires a newer NQP and MoarVM than 2017.04**. There has not been any further NQP or MoarVM *release* tags, but the version/git tags required are at least:

* NQP 2017.04-24-g87501f7b
* MoarVM 2017.04-44-gf0db8822

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.04.3:
 + Fixes:
    + Fix REPL history file failure with Linoise on [6c66c1b88c]
    + Fix `)>` to work whenever .MATCH is called [2f143f476d][0150c7b8c5]
    + Fixed issues with false positive case-insensitive regex matches
        when only start of string and end of string match [f756b4b54f][25048824c8]

The following people contributed to this release:

Samantha McVey, Timo Paulssen, Larry Wall, Zoffix Znet

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#111), is tentatively scheduled for 2017-05-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

[^3]: NQP stands for 'Not Quite Perl', which is a language/environment
that Rakudo is largely written in. See https://github.com/perl6/nqp

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.

