/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPEntrySource;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.persist.DefaultOIDAllocator;
import com.unboundid.ldap.sdk.persist.FieldInfo;
import com.unboundid.ldap.sdk.persist.GetterInfo;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import com.unboundid.ldap.sdk.persist.LDAPObjectHandler;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.OIDAllocator;
import com.unboundid.ldap.sdk.persist.ObjectSearchListener;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.persist.PersistedObjects;
import com.unboundid.ldap.sdk.persist.SearchListenerBridge;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPPersister<T>
implements Serializable {
    private static final long serialVersionUID = -4001743482496453961L;
    @NotNull
    private static final Control[] NO_CONTROLS = new Control[0];
    @NotNull
    private static final ConcurrentHashMap<Class<?>, LDAPPersister<?>> INSTANCES = new ConcurrentHashMap(StaticUtils.computeMapCapacity(10));
    @NotNull
    private final LDAPObjectHandler<T> handler;

    private LDAPPersister(@NotNull Class<T> type) throws LDAPPersistException {
        this.handler = new LDAPObjectHandler<T>(type);
    }

    @NotNull
    public static <T> LDAPPersister<T> getInstance(@NotNull Class<T> type) throws LDAPPersistException {
        Validator.ensureNotNull(type);
        LDAPPersister<Object> p = INSTANCES.get(type);
        if (p == null) {
            p = new LDAPPersister<T>(type);
            INSTANCES.put(type, p);
        }
        return p;
    }

    @NotNull
    public LDAPObject getLDAPObjectAnnotation() {
        return this.handler.getLDAPObjectAnnotation();
    }

    @NotNull
    public LDAPObjectHandler<T> getObjectHandler() {
        return this.handler;
    }

    @NotNull
    public List<AttributeTypeDefinition> constructAttributeTypes() throws LDAPPersistException {
        return this.constructAttributeTypes(DefaultOIDAllocator.getInstance());
    }

    @NotNull
    public List<AttributeTypeDefinition> constructAttributeTypes(@NotNull OIDAllocator a) throws LDAPPersistException {
        LinkedList<AttributeTypeDefinition> attrList = new LinkedList<AttributeTypeDefinition>();
        for (FieldInfo fieldInfo : this.handler.getFields().values()) {
            attrList.add(fieldInfo.constructAttributeType(a));
        }
        for (GetterInfo getterInfo : this.handler.getGetters().values()) {
            attrList.add(getterInfo.constructAttributeType(a));
        }
        return Collections.unmodifiableList(attrList);
    }

    @NotNull
    public List<ObjectClassDefinition> constructObjectClasses() throws LDAPPersistException {
        return this.constructObjectClasses(DefaultOIDAllocator.getInstance());
    }

    @NotNull
    public List<ObjectClassDefinition> constructObjectClasses(@NotNull OIDAllocator a) throws LDAPPersistException {
        return this.handler.constructObjectClasses(a);
    }

    public boolean updateSchema(@NotNull LDAPInterface i) throws LDAPException {
        return this.updateSchema(i, DefaultOIDAllocator.getInstance());
    }

    public boolean updateSchema(@NotNull LDAPInterface i, @NotNull OIDAllocator a) throws LDAPException {
        Schema s = i.getSchema();
        List<AttributeTypeDefinition> generatedTypes = this.constructAttributeTypes(a);
        List<ObjectClassDefinition> generatedClasses = this.constructObjectClasses(a);
        LinkedList<String> newAttrList = new LinkedList<String>();
        for (AttributeTypeDefinition d : generatedTypes) {
            if (s.getAttributeType(d.getNameOrOID()) != null) continue;
            newAttrList.add(d.toString());
        }
        LinkedList<String> newOCList = new LinkedList<String>();
        for (ObjectClassDefinition d : generatedClasses) {
            ObjectClassDefinition existing = s.getObjectClass(d.getNameOrOID());
            if (existing == null) {
                newOCList.add(d.toString());
                continue;
            }
            Set<AttributeTypeDefinition> existingRequired = existing.getRequiredAttributes(s, true);
            Set<AttributeTypeDefinition> existingOptional = existing.getOptionalAttributes(s, true);
            LinkedHashSet<String> newOptionalNames = new LinkedHashSet<String>(0);
            LDAPPersister.addMissingAttrs(d.getRequiredAttributes(), existingRequired, existingOptional, newOptionalNames);
            LDAPPersister.addMissingAttrs(d.getOptionalAttributes(), existingRequired, existingOptional, newOptionalNames);
            if (newOptionalNames.isEmpty()) continue;
            LinkedHashSet<String> newOptionalSet = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(20));
            newOptionalSet.addAll(Arrays.asList(existing.getOptionalAttributes()));
            newOptionalSet.addAll(newOptionalNames);
            String[] newOptional = new String[newOptionalSet.size()];
            newOptionalSet.toArray(newOptional);
            ObjectClassDefinition newOC = new ObjectClassDefinition(existing.getOID(), existing.getNames(), existing.getDescription(), existing.isObsolete(), existing.getSuperiorClasses(), existing.getObjectClassType(), existing.getRequiredAttributes(), newOptional, existing.getExtensions());
            newOCList.add(newOC.toString());
        }
        LinkedList<Modification> mods = new LinkedList<Modification>();
        if (!newAttrList.isEmpty()) {
            String[] newAttrValues = new String[newAttrList.size()];
            mods.add(new Modification(ModificationType.ADD, "attributeTypes", newAttrList.toArray(newAttrValues)));
        }
        if (!newOCList.isEmpty()) {
            String[] newOCValues = new String[newOCList.size()];
            mods.add(new Modification(ModificationType.ADD, "objectClasses", newOCList.toArray(newOCValues)));
        }
        if (mods.isEmpty()) {
            return false;
        }
        i.modify(s.getSchemaEntry().getDN(), mods);
        return true;
    }

    private static void addMissingAttrs(@NotNull String[] names, @NotNull Set<AttributeTypeDefinition> required, @NotNull Set<AttributeTypeDefinition> optional, @NotNull Set<String> missing) {
        for (String name : names) {
            boolean found = false;
            for (AttributeTypeDefinition eA : required) {
                if (!eA.hasNameOrOID(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            for (AttributeTypeDefinition eA : optional) {
                if (!eA.hasNameOrOID(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(name);
        }
    }

    @NotNull
    public Entry encode(@NotNull T o, @Nullable String parentDN) throws LDAPPersistException {
        Validator.ensureNotNull(o);
        return this.handler.encode(o, parentDN);
    }

    @NotNull
    public T decode(@NotNull Entry entry) throws LDAPPersistException {
        Validator.ensureNotNull(entry);
        return this.handler.decode(entry);
    }

    public void decode(@NotNull T o, @NotNull Entry entry) throws LDAPPersistException {
        Validator.ensureNotNull(o, entry);
        this.handler.decode(o, entry);
    }

    @NotNull
    public LDAPResult add(@NotNull T o, @NotNull LDAPInterface i, @Nullable String parentDN, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(o, i);
        Entry e = this.encode(o, parentDN);
        try {
            AddRequest addRequest = new AddRequest(e);
            if (controls != null) {
                addRequest.setControls(controls);
            }
            return i.add(addRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @NotNull
    public LDAPResult delete(@NotNull T o, @NotNull LDAPInterface i, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(o, i);
        String dn = this.handler.getEntryDN(o);
        if (dn == null) {
            throw new LDAPPersistException(PersistMessages.ERR_PERSISTER_DELETE_NO_DN.get());
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            if (controls != null) {
                deleteRequest.setControls(controls);
            }
            return i.delete(deleteRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @NotNull
    public List<Modification> getModifications(@NotNull T o, boolean deleteNullValues, String ... attributes) throws LDAPPersistException {
        return this.getModifications(o, deleteNullValues, false, attributes);
    }

    @NotNull
    public List<Modification> getModifications(@NotNull T o, boolean deleteNullValues, boolean byteForByte, String ... attributes) throws LDAPPersistException {
        Validator.ensureNotNull(o);
        return this.handler.getModifications(o, deleteNullValues, byteForByte, attributes);
    }

    @NotNull
    public LDAPResult modify(@NotNull T o, @NotNull LDAPInterface i, @Nullable String dn, boolean deleteNullValues, String ... attributes) throws LDAPPersistException {
        return this.modify(o, i, dn, deleteNullValues, attributes, NO_CONTROLS);
    }

    @NotNull
    public LDAPResult modify(@NotNull T o, @NotNull LDAPInterface i, @Nullable String dn, boolean deleteNullValues, @Nullable String[] attributes, Control ... controls) throws LDAPPersistException {
        return this.modify(o, i, dn, deleteNullValues, false, attributes, controls);
    }

    @Nullable
    public LDAPResult modify(@NotNull T o, @NotNull LDAPInterface i, @Nullable String dn, boolean deleteNullValues, boolean byteForByte, @Nullable String[] attributes, Control ... controls) throws LDAPPersistException {
        String targetDN;
        Validator.ensureNotNull(o, i);
        List<Modification> mods = this.handler.getModifications(o, deleteNullValues, byteForByte, attributes);
        if (mods.isEmpty()) {
            return null;
        }
        if (dn == null) {
            targetDN = this.handler.getEntryDN(o);
            if (targetDN == null) {
                throw new LDAPPersistException(PersistMessages.ERR_PERSISTER_MODIFY_NO_DN.get());
            }
        } else {
            targetDN = dn;
        }
        try {
            ModifyRequest modifyRequest = new ModifyRequest(targetDN, mods);
            if (controls != null) {
                modifyRequest.setControls(controls);
            }
            return i.modify(modifyRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @NotNull
    public BindResult bind(@NotNull T o, @Nullable String baseDN, @NotNull String password, @NotNull LDAPConnection c, Control ... controls) throws LDAPException {
        Validator.ensureNotNull(o, password, c);
        String dn = this.handler.getEntryDN(o);
        if (dn == null) {
            String base = baseDN;
            if (base == null) {
                base = this.handler.getDefaultParentDN().toString();
            }
            SearchRequest r = new SearchRequest(base, SearchScope.SUB, this.handler.createFilter(o), "1.1");
            r.setSizeLimit(1);
            SearchResultEntry e = c.searchForEntry(r);
            if (e == null) {
                throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, PersistMessages.ERR_PERSISTER_BIND_NO_ENTRY_FOUND.get());
            }
            dn = e.getDN();
        }
        return c.bind(new SimpleBindRequest(dn, password, controls));
    }

    @Nullable
    public T get(@NotNull T o, @NotNull LDAPInterface i, @Nullable String parentDN) throws LDAPPersistException {
        SearchResultEntry entry;
        String dn = this.handler.constructDN(o, parentDN);
        try {
            entry = i.getEntry(dn, this.handler.getAttributesToRequest());
            if (entry == null) {
                return null;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
        return this.decode(entry);
    }

    @Nullable
    public T get(@NotNull String dn, @NotNull LDAPInterface i) throws LDAPPersistException {
        SearchResultEntry entry;
        try {
            entry = i.getEntry(dn, this.handler.getAttributesToRequest());
            if (entry == null) {
                return null;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
        return this.decode(entry);
    }

    public void lazilyLoad(@NotNull T o, @NotNull LDAPInterface i, FieldInfo ... fields) throws LDAPPersistException {
        SearchResultEntry entry;
        String[] attrs;
        Validator.ensureNotNull(o, i);
        if (fields == null || fields.length == 0) {
            attrs = this.handler.getLazilyLoadedAttributes();
        } else {
            ArrayList<String> attrList = new ArrayList<String>(fields.length);
            for (FieldInfo f : fields) {
                if (!f.lazilyLoad()) continue;
                attrList.add(f.getAttributeName());
            }
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        }
        if (attrs.length == 0) {
            return;
        }
        String dn = this.handler.getEntryDN(o);
        if (dn == null) {
            throw new LDAPPersistException(PersistMessages.ERR_PERSISTER_LAZILY_LOAD_NO_DN.get());
        }
        try {
            entry = i.getEntry(this.handler.getEntryDN(o), attrs);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
        if (entry == null) {
            throw new LDAPPersistException(PersistMessages.ERR_PERSISTER_LAZILY_LOAD_NO_ENTRY.get(dn));
        }
        boolean successful = true;
        ArrayList<String> failureReasons = new ArrayList<String>(5);
        Map<String, FieldInfo> fieldMap = this.handler.getFields();
        for (Attribute a : entry.getAttributes()) {
            String lowerName = StaticUtils.toLowerCase(a.getName());
            FieldInfo f = fieldMap.get(lowerName);
            if (f == null) continue;
            successful &= f.decode(o, entry, failureReasons);
        }
        if (!successful) {
            throw new LDAPPersistException(StaticUtils.concatenateStrings(failureReasons), o, null);
        }
    }

    @NotNull
    public PersistedObjects<T> search(@NotNull T o, @NotNull LDAPConnection c) throws LDAPPersistException {
        return this.search(o, c, null, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, null, NO_CONTROLS);
    }

    @NotNull
    public PersistedObjects<T> search(@NotNull T o, @NotNull LDAPConnection c, @Nullable String baseDN, @NotNull SearchScope scope) throws LDAPPersistException {
        return this.search(o, c, baseDN, scope, DereferencePolicy.NEVER, 0, 0, null, NO_CONTROLS);
    }

    @NotNull
    public PersistedObjects<T> search(@NotNull T o, @NotNull LDAPConnection c, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, @Nullable Filter extraFilter, Control ... controls) throws LDAPPersistException {
        LDAPEntrySource entrySource;
        Validator.ensureNotNull(o, c, scope, derefPolicy);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        Filter filter = extraFilter == null ? this.handler.createFilter(o) : Filter.createANDFilter(this.handler.createFilter(o), extraFilter);
        SearchRequest searchRequest = new SearchRequest(base, scope, derefPolicy, sizeLimit, timeLimit, false, filter, this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            entrySource = new LDAPEntrySource(c, searchRequest, false);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
        return new PersistedObjects(this, entrySource);
    }

    @NotNull
    public SearchResult search(@NotNull T o, @NotNull LDAPInterface i, @NotNull ObjectSearchListener<T> l) throws LDAPPersistException {
        return this.search(o, i, null, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, null, l, NO_CONTROLS);
    }

    @NotNull
    public SearchResult search(@NotNull T o, @NotNull LDAPInterface i, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull ObjectSearchListener<T> l) throws LDAPPersistException {
        return this.search(o, i, baseDN, scope, DereferencePolicy.NEVER, 0, 0, null, l, NO_CONTROLS);
    }

    @NotNull
    public SearchResult search(@NotNull T o, @NotNull LDAPInterface i, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, @Nullable Filter extraFilter, @NotNull ObjectSearchListener<T> l, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(o, i, scope, derefPolicy, l);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        Filter filter = extraFilter == null ? this.handler.createFilter(o) : Filter.simplifyFilter(Filter.createANDFilter(this.handler.createFilter(o), extraFilter), true);
        SearchListenerBridge<T> bridge = new SearchListenerBridge<T>(this, l);
        SearchRequest searchRequest = new SearchRequest(bridge, base, scope, derefPolicy, sizeLimit, timeLimit, false, filter, this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            return i.search(searchRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @NotNull
    public PersistedObjects<T> search(@NotNull LDAPConnection c, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, @NotNull Filter filter, Control ... controls) throws LDAPPersistException {
        LDAPEntrySource entrySource;
        Validator.ensureNotNull(c, scope, derefPolicy, filter);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        Filter f = Filter.createANDFilter(filter, this.handler.createBaseFilter());
        SearchRequest searchRequest = new SearchRequest(base, scope, derefPolicy, sizeLimit, timeLimit, false, f, this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            entrySource = new LDAPEntrySource(c, searchRequest, false);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
        return new PersistedObjects(this, entrySource);
    }

    @NotNull
    public SearchResult search(@NotNull LDAPInterface i, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, @NotNull Filter filter, @NotNull ObjectSearchListener<T> l, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(i, scope, derefPolicy, filter, l);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        Filter f = Filter.simplifyFilter(Filter.createANDFilter(filter, this.handler.createBaseFilter()), true);
        SearchListenerBridge<T> bridge = new SearchListenerBridge<T>(this, l);
        SearchRequest searchRequest = new SearchRequest(bridge, base, scope, derefPolicy, sizeLimit, timeLimit, false, f, this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            return i.search(searchRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @Nullable
    public T searchForObject(@NotNull T o, @NotNull LDAPInterface i) throws LDAPPersistException {
        return this.searchForObject(o, i, null, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, null, NO_CONTROLS);
    }

    @Nullable
    public T searchForObject(@NotNull T o, @NotNull LDAPInterface i, @Nullable String baseDN, @NotNull SearchScope scope) throws LDAPPersistException {
        return this.searchForObject(o, i, baseDN, scope, DereferencePolicy.NEVER, 0, 0, null, NO_CONTROLS);
    }

    @Nullable
    public T searchForObject(@NotNull T o, @NotNull LDAPInterface i, @Nullable String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, @Nullable Filter extraFilter, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(o, i, scope, derefPolicy);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        Filter filter = extraFilter == null ? this.handler.createFilter(o) : Filter.simplifyFilter(Filter.createANDFilter(this.handler.createFilter(o), extraFilter), true);
        SearchRequest searchRequest = new SearchRequest(base, scope, derefPolicy, sizeLimit, timeLimit, false, filter, this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            SearchResultEntry e = i.searchForEntry(searchRequest);
            if (e == null) {
                return null;
            }
            return this.decode(e);
        }
        catch (LDAPPersistException lpe) {
            Debug.debugException(lpe);
            throw lpe;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }

    @NotNull
    public SearchResult getAll(@NotNull LDAPInterface i, @Nullable String baseDN, @NotNull ObjectSearchListener<T> l, Control ... controls) throws LDAPPersistException {
        Validator.ensureNotNull(i, l);
        String base = baseDN == null ? this.handler.getDefaultParentDN().toString() : baseDN;
        SearchListenerBridge<T> bridge = new SearchListenerBridge<T>(this, l);
        SearchRequest searchRequest = new SearchRequest(bridge, base, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, false, this.handler.createBaseFilter(), this.handler.getAttributesToRequest());
        if (controls != null) {
            searchRequest.setControls(controls);
        }
        try {
            return i.search(searchRequest);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPPersistException(le);
        }
    }
}

