// SPDX-FileCopyrightText: 2025 The Pion community <https://pion.ly>
// SPDX-License-Identifier: MIT

package webrtc

const (
	// MimeTypeH264 H264 MIME type.
	// Note: Matching should be case insensitive.
	MimeTypeH264 = "video/H264"
	// MimeTypeH265 H265 MIME type
	// Note: Matching should be case insensitive.
	MimeTypeH265 = "video/H265"
	// MimeTypeOpus Opus MIME type
	// Note: Matching should be case insensitive.
	MimeTypeOpus = "audio/opus"
	// MimeTypeVP8 VP8 MIME type
	// Note: Matching should be case insensitive.
	MimeTypeVP8 = "video/VP8"
	// MimeTypeVP9 VP9 MIME type
	// Note: Matching should be case insensitive.
	MimeTypeVP9 = "video/VP9"
	// MimeTypeAV1 AV1 MIME type
	// Note: Matching should be case insensitive.
	MimeTypeAV1 = "video/AV1"
	// MimeTypeG722 G722 MIME type
	// Note: Matching should be case insensitive.
	MimeTypeG722 = "audio/G722"
	// MimeTypePCMU PCMU MIME type
	// Note: Matching should be case insensitive.
	MimeTypePCMU = "audio/PCMU"
	// MimeTypePCMA PCMA MIME type
	// Note: Matching should be case insensitive.
	MimeTypePCMA = "audio/PCMA"
	// MimeTypeRTX RTX MIME type
	// Note: Matching should be case insensitive.
	MimeTypeRTX = "video/rtx"
	// MimeTypeFlexFEC FEC MIME Type
	// Note: Matching should be case insensitive.
	MimeTypeFlexFEC = "video/flexfec"
	// MimeTypeFlexFEC03 FlexFEC03 MIME Type
	// Note: Matching should be case insensitive.
	MimeTypeFlexFEC03 = "video/flexfec-03"
	// MimeTypeUlpFEC UlpFEC MIME Type
	// Note: Matching should be case insensitive.
	MimeTypeUlpFEC = "video/ulpfec"
)
