// SPDX-FileCopyrightText: 2002-2025 PCSX2 Dev Team
// SPDX-License-Identifier: GPL-3.0+

#pragma once

/*
 * Table generator from Near, with credit to nocash and Ryphecha
 *
 * Modified to produce a two dimensional array indexed by [interp_idx][0..3]
 */

/*
static constexpr std::array<std::array<s16, 4>, 256> gaussianConstructTable()
{
	std::array<std::array<s16, 4>, 256> result = {};
	double table[512] = {};
	for (u32 n = 0; n < 512; n++)
	{
		double k = 0.5 + n;
		auto s = static_cast<double>((gcem::sin(GCEM_PI * k * 2.048 / 1024)));
		auto t = static_cast<double>((gcem::cos(GCEM_PI * k * 2.000 / 1023) - 1) * 0.50);
		auto u = static_cast<double>((gcem::cos(GCEM_PI * k * 4.000 / 1023) - 1) * 0.08);
		double r = s * (t + u + 1.0) / k;
		table[511 - n] = r;
	}
	double sum = 0.0;
	for (double n : table)
		sum += n;
	double scale = 0x7f80 * 128 / sum;
	for (double & n : table)
		n *= scale;
	for (u32 phase = 0; phase < 256; phase++)
	{
		double phase_sum = 0.0;
		phase_sum += table[phase + 0];
		phase_sum += table[phase + 256];
		phase_sum += table[511 - phase];
		phase_sum += table[255 - phase];
		double diff = (phase_sum - 0x7f80) / 4;

		result[255 - phase][0] = static_cast<s16>(gcem::round(table[phase + 0] - diff));
		result[255 - phase][1] = static_cast<s16>(gcem::round(table[phase + 256] - diff));
		result[255 - phase][2] = static_cast<s16>(gcem::round(table[511 - phase] - diff));
		result[255 - phase][3] = static_cast<s16>(gcem::round(table[255 - phase] - diff));
	}

	return result;
}
*/

static constexpr std::array<std::array<int16_t, 4>, 256> interpTable = {{
	{0x12C7, 0x59B3, 0x1307, -0x0001},
	{0x1288, 0x59B2, 0x1347, -0x0001},
	{0x1249, 0x59B0, 0x1388, -0x0001},
	{0x120B, 0x59AD, 0x13C9, -0x0001},
	{0x11CD, 0x59A9, 0x140B, -0x0001},
	{0x118F, 0x59A4, 0x144D, -0x0001},
	{0x1153, 0x599E, 0x1490, -0x0001},
	{0x1116, 0x5997, 0x14D4, -0x0001},
	{0x10DB, 0x598F, 0x1517, -0x0001},
	{0x109F, 0x5986, 0x155C, -0x0001},
	{0x1065, 0x597C, 0x15A0, -0x0001},
	{0x102A, 0x5971, 0x15E6, -0x0001},
	{0x0FF1, 0x5965, 0x162C, -0x0001},
	{0x0FB7, 0x5958, 0x1672, -0x0001},
	{0x0F7F, 0x5949, 0x16B9, -0x0001},
	{0x0F46, 0x593A, 0x1700, -0x0001},
	{0x0F0F, 0x592A, 0x1747, 0x0000},
	{0x0ED7, 0x5919, 0x1790, 0x0000},
	{0x0EA1, 0x5907, 0x17D8, 0x0000},
	{0x0E6B, 0x58F4, 0x1821, 0x0000},
	{0x0E35, 0x58E0, 0x186B, 0x0000},
	{0x0E00, 0x58CB, 0x18B5, 0x0000},
	{0x0DCB, 0x58B5, 0x1900, 0x0000},
	{0x0D97, 0x589E, 0x194B, 0x0001},
	{0x0D63, 0x5886, 0x1996, 0x0001},
	{0x0D30, 0x586D, 0x19E2, 0x0001},
	{0x0CFD, 0x5853, 0x1A2E, 0x0001},
	{0x0CCB, 0x5838, 0x1A7B, 0x0002},
	{0x0C99, 0x581C, 0x1AC8, 0x0002},
	{0x0C68, 0x57FF, 0x1B16, 0x0002},
	{0x0C38, 0x57E2, 0x1B64, 0x0003},
	{0x0C07, 0x57C3, 0x1BB3, 0x0003},
	{0x0BD8, 0x57A3, 0x1C02, 0x0003},
	{0x0BA9, 0x5782, 0x1C51, 0x0004},
	{0x0B7A, 0x5761, 0x1CA1, 0x0004},
	{0x0B4C, 0x573E, 0x1CF1, 0x0005},
	{0x0B1E, 0x571B, 0x1D42, 0x0005},
	{0x0AF1, 0x56F6, 0x1D93, 0x0006},
	{0x0AC4, 0x56D1, 0x1DE5, 0x0007},
	{0x0A98, 0x56AB, 0x1E37, 0x0007},
	{0x0A6C, 0x5684, 0x1E89, 0x0008},
	{0x0A40, 0x565B, 0x1EDC, 0x0009},
	{0x0A16, 0x5632, 0x1F2F, 0x0009},
	{0x09EB, 0x5609, 0x1F82, 0x000A},
	{0x09C1, 0x55DE, 0x1FD6, 0x000B},
	{0x0998, 0x55B2, 0x202A, 0x000C},
	{0x096F, 0x5585, 0x207F, 0x000D},
	{0x0946, 0x5558, 0x20D4, 0x000E},
	{0x091E, 0x5529, 0x2129, 0x000F},
	{0x08F7, 0x54FA, 0x217F, 0x0010},
	{0x08D0, 0x54CA, 0x21D5, 0x0011},
	{0x08A9, 0x5499, 0x222C, 0x0012},
	{0x0883, 0x5467, 0x2282, 0x0013},
	{0x085D, 0x5434, 0x22DA, 0x0015},
	{0x0838, 0x5401, 0x2331, 0x0016},
	{0x0813, 0x53CC, 0x2389, 0x0018},
	{0x07EF, 0x5397, 0x23E1, 0x0019},
	{0x07CB, 0x5361, 0x2439, 0x001B},
	{0x07A7, 0x532A, 0x2492, 0x001C},
	{0x0784, 0x52F3, 0x24EB, 0x001E},
	{0x0762, 0x52BA, 0x2545, 0x0020},
	{0x0740, 0x5281, 0x259E, 0x0021},
	{0x071E, 0x5247, 0x25F8, 0x0023},
	{0x06FD, 0x520C, 0x2653, 0x0025},
	{0x06DC, 0x51D0, 0x26AD, 0x0027},
	{0x06BB, 0x5194, 0x2708, 0x0029},
	{0x069B, 0x5156, 0x2763, 0x002C},
	{0x067C, 0x5118, 0x27BE, 0x002E},
	{0x065C, 0x50DA, 0x281A, 0x0030},
	{0x063E, 0x509A, 0x2876, 0x0033},
	{0x061F, 0x505A, 0x28D2, 0x0035},
	{0x0601, 0x5019, 0x292E, 0x0038},
	{0x05E4, 0x4FD7, 0x298B, 0x003A},
	{0x05C7, 0x4F95, 0x29E7, 0x003D},
	{0x05AA, 0x4F52, 0x2A44, 0x0040},
	{0x058E, 0x4F0E, 0x2AA1, 0x0043},
	{0x0572, 0x4EC9, 0x2AFF, 0x0046},
	{0x0556, 0x4E84, 0x2B5C, 0x0049},
	{0x053B, 0x4E3E, 0x2BBA, 0x004D},
	{0x0520, 0x4DF7, 0x2C18, 0x0050},
	{0x0506, 0x4DB0, 0x2C76, 0x0054},
	{0x04EC, 0x4D68, 0x2CD4, 0x0057},
	{0x04D2, 0x4D20, 0x2D33, 0x005B},
	{0x04B9, 0x4CD7, 0x2D91, 0x005F},
	{0x04A0, 0x4C8D, 0x2DF0, 0x0063},
	{0x0488, 0x4C42, 0x2E4F, 0x0067},
	{0x0470, 0x4BF7, 0x2EAE, 0x006B},
	{0x0458, 0x4BAC, 0x2F0D, 0x006F},
	{0x0441, 0x4B5F, 0x2F6C, 0x0074},
	{0x042A, 0x4B13, 0x2FCC, 0x0078},
	{0x0413, 0x4AC5, 0x302B, 0x007D},
	{0x03FC, 0x4A77, 0x308B, 0x0082},
	{0x03E7, 0x4A29, 0x30EA, 0x0087},
	{0x03D1, 0x49D9, 0x314A, 0x008C},
	{0x03BC, 0x498A, 0x31AA, 0x0091},
	{0x03A7, 0x493A, 0x3209, 0x0096},
	{0x0392, 0x48E9, 0x3269, 0x009C},
	{0x037E, 0x4898, 0x32C9, 0x00A1},
	{0x036A, 0x4846, 0x3329, 0x00A7},
	{0x0356, 0x47F4, 0x3389, 0x00AD},
	{0x0343, 0x47A1, 0x33E9, 0x00B3},
	{0x0330, 0x474E, 0x3449, 0x00BA},
	{0x031D, 0x46FA, 0x34A9, 0x00C0},
	{0x030B, 0x46A6, 0x3509, 0x00C7},
	{0x02F9, 0x4651, 0x3569, 0x00CD},
	{0x02E7, 0x45FC, 0x35C9, 0x00D4},
	{0x02D6, 0x45A6, 0x3629, 0x00DB},
	{0x02C4, 0x4550, 0x3689, 0x00E3},
	{0x02B4, 0x44FA, 0x36E8, 0x00EA},
	{0x02A3, 0x44A3, 0x3748, 0x00F2},
	{0x0293, 0x444C, 0x37A8, 0x00FA},
	{0x0283, 0x43F4, 0x3807, 0x0101},
	{0x0273, 0x439C, 0x3867, 0x010A},
	{0x0264, 0x4344, 0x38C6, 0x0112},
	{0x0255, 0x42EB, 0x3926, 0x011B},
	{0x0246, 0x4292, 0x3985, 0x0123},
	{0x0237, 0x4239, 0x39E4, 0x012C},
	{0x0229, 0x41DF, 0x3A43, 0x0135},
	{0x021B, 0x4185, 0x3AA2, 0x013F},
	{0x020D, 0x412A, 0x3B00, 0x0148},
	{0x0200, 0x40D0, 0x3B5F, 0x0152},
	{0x01F2, 0x4074, 0x3BBD, 0x015C},
	{0x01E5, 0x4019, 0x3C1B, 0x0166},
	{0x01D9, 0x3FBD, 0x3C79, 0x0171},
	{0x01CC, 0x3F62, 0x3CD7, 0x017B},
	{0x01C0, 0x3F05, 0x3D35, 0x0186},
	{0x01B4, 0x3EA9, 0x3D92, 0x0191},
	{0x01A8, 0x3E4C, 0x3DEF, 0x019C},
	{0x019C, 0x3DEF, 0x3E4C, 0x01A8},
	{0x0191, 0x3D92, 0x3EA9, 0x01B4},
	{0x0186, 0x3D35, 0x3F05, 0x01C0},
	{0x017B, 0x3CD7, 0x3F62, 0x01CC},
	{0x0171, 0x3C79, 0x3FBD, 0x01D9},
	{0x0166, 0x3C1B, 0x4019, 0x01E5},
	{0x015C, 0x3BBD, 0x4074, 0x01F2},
	{0x0152, 0x3B5F, 0x40D0, 0x0200},
	{0x0148, 0x3B00, 0x412A, 0x020D},
	{0x013F, 0x3AA2, 0x4185, 0x021B},
	{0x0135, 0x3A43, 0x41DF, 0x0229},
	{0x012C, 0x39E4, 0x4239, 0x0237},
	{0x0123, 0x3985, 0x4292, 0x0246},
	{0x011B, 0x3926, 0x42EB, 0x0255},
	{0x0112, 0x38C6, 0x4344, 0x0264},
	{0x010A, 0x3867, 0x439C, 0x0273},
	{0x0101, 0x3807, 0x43F4, 0x0283},
	{0x00FA, 0x37A8, 0x444C, 0x0293},
	{0x00F2, 0x3748, 0x44A3, 0x02A3},
	{0x00EA, 0x36E8, 0x44FA, 0x02B4},
	{0x00E3, 0x3689, 0x4550, 0x02C4},
	{0x00DB, 0x3629, 0x45A6, 0x02D6},
	{0x00D4, 0x35C9, 0x45FC, 0x02E7},
	{0x00CD, 0x3569, 0x4651, 0x02F9},
	{0x00C7, 0x3509, 0x46A6, 0x030B},
	{0x00C0, 0x34A9, 0x46FA, 0x031D},
	{0x00BA, 0x3449, 0x474E, 0x0330},
	{0x00B3, 0x33E9, 0x47A1, 0x0343},
	{0x00AD, 0x3389, 0x47F4, 0x0356},
	{0x00A7, 0x3329, 0x4846, 0x036A},
	{0x00A1, 0x32C9, 0x4898, 0x037E},
	{0x009C, 0x3269, 0x48E9, 0x0392},
	{0x0096, 0x3209, 0x493A, 0x03A7},
	{0x0091, 0x31AA, 0x498A, 0x03BC},
	{0x008C, 0x314A, 0x49D9, 0x03D1},
	{0x0087, 0x30EA, 0x4A29, 0x03E7},
	{0x0082, 0x308B, 0x4A77, 0x03FC},
	{0x007D, 0x302B, 0x4AC5, 0x0413},
	{0x0078, 0x2FCC, 0x4B13, 0x042A},
	{0x0074, 0x2F6C, 0x4B5F, 0x0441},
	{0x006F, 0x2F0D, 0x4BAC, 0x0458},
	{0x006B, 0x2EAE, 0x4BF7, 0x0470},
	{0x0067, 0x2E4F, 0x4C42, 0x0488},
	{0x0063, 0x2DF0, 0x4C8D, 0x04A0},
	{0x005F, 0x2D91, 0x4CD7, 0x04B9},
	{0x005B, 0x2D33, 0x4D20, 0x04D2},
	{0x0057, 0x2CD4, 0x4D68, 0x04EC},
	{0x0054, 0x2C76, 0x4DB0, 0x0506},
	{0x0050, 0x2C18, 0x4DF7, 0x0520},
	{0x004D, 0x2BBA, 0x4E3E, 0x053B},
	{0x0049, 0x2B5C, 0x4E84, 0x0556},
	{0x0046, 0x2AFF, 0x4EC9, 0x0572},
	{0x0043, 0x2AA1, 0x4F0E, 0x058E},
	{0x0040, 0x2A44, 0x4F52, 0x05AA},
	{0x003D, 0x29E7, 0x4F95, 0x05C7},
	{0x003A, 0x298B, 0x4FD7, 0x05E4},
	{0x0038, 0x292E, 0x5019, 0x0601},
	{0x0035, 0x28D2, 0x505A, 0x061F},
	{0x0033, 0x2876, 0x509A, 0x063E},
	{0x0030, 0x281A, 0x50DA, 0x065C},
	{0x002E, 0x27BE, 0x5118, 0x067C},
	{0x002C, 0x2763, 0x5156, 0x069B},
	{0x0029, 0x2708, 0x5194, 0x06BB},
	{0x0027, 0x26AD, 0x51D0, 0x06DC},
	{0x0025, 0x2653, 0x520C, 0x06FD},
	{0x0023, 0x25F8, 0x5247, 0x071E},
	{0x0021, 0x259E, 0x5281, 0x0740},
	{0x0020, 0x2545, 0x52BA, 0x0762},
	{0x001E, 0x24EB, 0x52F3, 0x0784},
	{0x001C, 0x2492, 0x532A, 0x07A7},
	{0x001B, 0x2439, 0x5361, 0x07CB},
	{0x0019, 0x23E1, 0x5397, 0x07EF},
	{0x0018, 0x2389, 0x53CC, 0x0813},
	{0x0016, 0x2331, 0x5401, 0x0838},
	{0x0015, 0x22DA, 0x5434, 0x085D},
	{0x0013, 0x2282, 0x5467, 0x0883},
	{0x0012, 0x222C, 0x5499, 0x08A9},
	{0x0011, 0x21D5, 0x54CA, 0x08D0},
	{0x0010, 0x217F, 0x54FA, 0x08F7},
	{0x000F, 0x2129, 0x5529, 0x091E},
	{0x000E, 0x20D4, 0x5558, 0x0946},
	{0x000D, 0x207F, 0x5585, 0x096F},
	{0x000C, 0x202A, 0x55B2, 0x0998},
	{0x000B, 0x1FD6, 0x55DE, 0x09C1},
	{0x000A, 0x1F82, 0x5609, 0x09EB},
	{0x0009, 0x1F2F, 0x5632, 0x0A16},
	{0x0009, 0x1EDC, 0x565B, 0x0A40},
	{0x0008, 0x1E89, 0x5684, 0x0A6C},
	{0x0007, 0x1E37, 0x56AB, 0x0A98},
	{0x0007, 0x1DE5, 0x56D1, 0x0AC4},
	{0x0006, 0x1D93, 0x56F6, 0x0AF1},
	{0x0005, 0x1D42, 0x571B, 0x0B1E},
	{0x0005, 0x1CF1, 0x573E, 0x0B4C},
	{0x0004, 0x1CA1, 0x5761, 0x0B7A},
	{0x0004, 0x1C51, 0x5782, 0x0BA9},
	{0x0003, 0x1C02, 0x57A3, 0x0BD8},
	{0x0003, 0x1BB3, 0x57C3, 0x0C07},
	{0x0003, 0x1B64, 0x57E2, 0x0C38},
	{0x0002, 0x1B16, 0x57FF, 0x0C68},
	{0x0002, 0x1AC8, 0x581C, 0x0C99},
	{0x0002, 0x1A7B, 0x5838, 0x0CCB},
	{0x0001, 0x1A2E, 0x5853, 0x0CFD},
	{0x0001, 0x19E2, 0x586D, 0x0D30},
	{0x0001, 0x1996, 0x5886, 0x0D63},
	{0x0001, 0x194B, 0x589E, 0x0D97},
	{0x0000, 0x1900, 0x58B5, 0x0DCB},
	{0x0000, 0x18B5, 0x58CB, 0x0E00},
	{0x0000, 0x186B, 0x58E0, 0x0E35},
	{0x0000, 0x1821, 0x58F4, 0x0E6B},
	{0x0000, 0x17D8, 0x5907, 0x0EA1},
	{0x0000, 0x1790, 0x5919, 0x0ED7},
	{0x0000, 0x1747, 0x592A, 0x0F0F},
	{-0x0001, 0x1700, 0x593A, 0x0F46},
	{-0x0001, 0x16B9, 0x5949, 0x0F7F},
	{-0x0001, 0x1672, 0x5958, 0x0FB7},
	{-0x0001, 0x162C, 0x5965, 0x0FF1},
	{-0x0001, 0x15E6, 0x5971, 0x102A},
	{-0x0001, 0x15A0, 0x597C, 0x1065},
	{-0x0001, 0x155C, 0x5986, 0x109F},
	{-0x0001, 0x1517, 0x598F, 0x10DB},
	{-0x0001, 0x14D4, 0x5997, 0x1116},
	{-0x0001, 0x1490, 0x599E, 0x1153},
	{-0x0001, 0x144D, 0x59A4, 0x118F},
	{-0x0001, 0x140B, 0x59A9, 0x11CD},
	{-0x0001, 0x13C9, 0x59AD, 0x120B},
	{-0x0001, 0x1388, 0x59B0, 0x1249},
	{-0x0001, 0x1347, 0x59B2, 0x1288},
	{-0x0001, 0x1307, 0x59B3, 0x12C7},
}};
