/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakeNodes implements NodeInterface
type fakeNodes struct {
	*gentype.FakeClientWithListAndApply[*v1.Node, *v1.NodeList, *corev1.NodeApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakeNodes(fake *FakeCoreV1) typedcorev1.NodeInterface {
	return &fakeNodes{
		gentype.NewFakeClientWithListAndApply[*v1.Node, *v1.NodeList, *corev1.NodeApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("nodes"),
			v1.SchemeGroupVersion.WithKind("Node"),
			func() *v1.Node { return &v1.Node{} },
			func() *v1.NodeList { return &v1.NodeList{} },
			func(dst, src *v1.NodeList) { dst.ListMeta = src.ListMeta },
			func(list *v1.NodeList) []*v1.Node { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.NodeList, items []*v1.Node) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
