/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;

public enum BinaryPrefix implements Prefix
{
    KIBI("Ki", 1),
    MEBI("Mi", 2),
    GIBI("Gi", 3),
    TEBI("Ti", 4),
    PEBI("Pi", 5),
    EXBI("Ei", 6),
    ZEBI("Zi", 7),
    YOBI("Yi", 8);

    private final String symbol;
    private final int exponent;

    private BinaryPrefix(String symbol, int exponent) {
        this.symbol = symbol;
        this.exponent = exponent;
    }

    public static <Q extends Quantity<Q>> Unit<Q> KIBI(Unit<Q> unit) {
        return unit.prefix(KIBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> MEBI(Unit<Q> unit) {
        return unit.prefix(MEBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> GIBI(Unit<Q> unit) {
        return unit.prefix(GIBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> TEBI(Unit<Q> unit) {
        return unit.prefix(TEBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> PEBI(Unit<Q> unit) {
        return unit.prefix(PEBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> EXBI(Unit<Q> unit) {
        return unit.prefix(EXBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> ZEBI(Unit<Q> unit) {
        return unit.prefix(ZEBI);
    }

    public static <Q extends Quantity<Q>> Unit<Q> YOBI(Unit<Q> unit) {
        return unit.prefix(YOBI);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getValue() {
        return 1024;
    }

    @Override
    public int getExponent() {
        return this.exponent;
    }

    @Override
    public String getName() {
        return this.name();
    }
}

