/*
 * WARNING: This file is autogenerated from scripts/gen_enums.py. If you would
 * like to access an enum that is currently missing, add it to the script
 * and run it from the root directory to update this file.
 */

use crate::compat::read_enum;

#[derive(Debug)]
#[allow(non_snake_case)]
pub struct Enums {
    pub SCX_OPS_NAME_LEN: u64,
    pub SCX_SLICE_DFL: u64,
    pub SCX_SLICE_INF: u64,
    pub SCX_RQ_ONLINE: u64,
    pub SCX_RQ_CAN_STOP_TICK: u64,
    pub SCX_RQ_BAL_PENDING: u64,
    pub SCX_RQ_BAL_KEEP: u64,
    pub SCX_RQ_BYPASSING: u64,
    pub SCX_RQ_CLK_VALID: u64,
    pub SCX_RQ_IN_WAKEUP: u64,
    pub SCX_RQ_IN_BALANCE: u64,
    pub SCX_DSQ_FLAG_BUILTIN: u64,
    pub SCX_DSQ_FLAG_LOCAL_ON: u64,
    pub SCX_DSQ_INVALID: u64,
    pub SCX_DSQ_GLOBAL: u64,
    pub SCX_DSQ_LOCAL: u64,
    pub SCX_DSQ_LOCAL_ON: u64,
    pub SCX_DSQ_LOCAL_CPU_MASK: u64,
    pub SCX_TASK_QUEUED: u64,
    pub SCX_TASK_RESET_RUNNABLE_AT: u64,
    pub SCX_TASK_DEQD_FOR_SLEEP: u64,
    pub SCX_TASK_STATE_SHIFT: u64,
    pub SCX_TASK_STATE_BITS: u64,
    pub SCX_TASK_STATE_MASK: u64,
    pub SCX_TASK_CURSOR: u64,
    pub SCX_TASK_NONE: u64,
    pub SCX_TASK_INIT: u64,
    pub SCX_TASK_READY: u64,
    pub SCX_TASK_ENABLED: u64,
    pub SCX_TASK_NR_STATES: u64,
    pub SCX_TASK_DSQ_ON_PRIQ: u64,
    pub SCX_KICK_IDLE: u64,
    pub SCX_KICK_PREEMPT: u64,
    pub SCX_KICK_WAIT: u64,
    pub SCX_ENQ_WAKEUP: u64,
    pub SCX_ENQ_HEAD: u64,
    pub SCX_ENQ_PREEMPT: u64,
    pub SCX_ENQ_REENQ: u64,
    pub SCX_ENQ_LAST: u64,
    pub SCX_ENQ_CLEAR_OPSS: u64,
    pub SCX_ENQ_DSQ_PRIQ: u64,
}

lazy_static::lazy_static! {
    pub static ref scx_enums: Enums = Enums {
        SCX_OPS_NAME_LEN: read_enum("scx_public_consts","SCX_OPS_NAME_LEN").unwrap_or(0),
        SCX_SLICE_DFL: read_enum("scx_public_consts","SCX_SLICE_DFL").unwrap_or(0),
        SCX_SLICE_INF: read_enum("scx_public_consts","SCX_SLICE_INF").unwrap_or(0),
        SCX_RQ_ONLINE: read_enum("scx_rq_flags","SCX_RQ_ONLINE").unwrap_or(0),
        SCX_RQ_CAN_STOP_TICK: read_enum("scx_rq_flags","SCX_RQ_CAN_STOP_TICK").unwrap_or(0),
        SCX_RQ_BAL_PENDING: read_enum("scx_rq_flags","SCX_RQ_BAL_PENDING").unwrap_or(0),
        SCX_RQ_BAL_KEEP: read_enum("scx_rq_flags","SCX_RQ_BAL_KEEP").unwrap_or(0),
        SCX_RQ_BYPASSING: read_enum("scx_rq_flags","SCX_RQ_BYPASSING").unwrap_or(0),
        SCX_RQ_CLK_VALID: read_enum("scx_rq_flags","SCX_RQ_CLK_VALID").unwrap_or(0),
        SCX_RQ_IN_WAKEUP: read_enum("scx_rq_flags","SCX_RQ_IN_WAKEUP").unwrap_or(0),
        SCX_RQ_IN_BALANCE: read_enum("scx_rq_flags","SCX_RQ_IN_BALANCE").unwrap_or(0),
        SCX_DSQ_FLAG_BUILTIN: read_enum("scx_dsq_id_flags","SCX_DSQ_FLAG_BUILTIN").unwrap_or(0),
        SCX_DSQ_FLAG_LOCAL_ON: read_enum("scx_dsq_id_flags","SCX_DSQ_FLAG_LOCAL_ON").unwrap_or(0),
        SCX_DSQ_INVALID: read_enum("scx_dsq_id_flags","SCX_DSQ_INVALID").unwrap_or(0),
        SCX_DSQ_GLOBAL: read_enum("scx_dsq_id_flags","SCX_DSQ_GLOBAL").unwrap_or(0),
        SCX_DSQ_LOCAL: read_enum("scx_dsq_id_flags","SCX_DSQ_LOCAL").unwrap_or(0),
        SCX_DSQ_LOCAL_ON: read_enum("scx_dsq_id_flags","SCX_DSQ_LOCAL_ON").unwrap_or(0),
        SCX_DSQ_LOCAL_CPU_MASK: read_enum("scx_dsq_id_flags","SCX_DSQ_LOCAL_CPU_MASK").unwrap_or(0),
        SCX_TASK_QUEUED: read_enum("scx_ent_flags","SCX_TASK_QUEUED").unwrap_or(0),
        SCX_TASK_RESET_RUNNABLE_AT: read_enum("scx_ent_flags","SCX_TASK_RESET_RUNNABLE_AT").unwrap_or(0),
        SCX_TASK_DEQD_FOR_SLEEP: read_enum("scx_ent_flags","SCX_TASK_DEQD_FOR_SLEEP").unwrap_or(0),
        SCX_TASK_STATE_SHIFT: read_enum("scx_ent_flags","SCX_TASK_STATE_SHIFT").unwrap_or(0),
        SCX_TASK_STATE_BITS: read_enum("scx_ent_flags","SCX_TASK_STATE_BITS").unwrap_or(0),
        SCX_TASK_STATE_MASK: read_enum("scx_ent_flags","SCX_TASK_STATE_MASK").unwrap_or(0),
        SCX_TASK_CURSOR: read_enum("scx_ent_flags","SCX_TASK_CURSOR").unwrap_or(0),
        SCX_TASK_NONE: read_enum("scx_task_state","SCX_TASK_NONE").unwrap_or(0),
        SCX_TASK_INIT: read_enum("scx_task_state","SCX_TASK_INIT").unwrap_or(0),
        SCX_TASK_READY: read_enum("scx_task_state","SCX_TASK_READY").unwrap_or(0),
        SCX_TASK_ENABLED: read_enum("scx_task_state","SCX_TASK_ENABLED").unwrap_or(0),
        SCX_TASK_NR_STATES: read_enum("scx_task_state","SCX_TASK_NR_STATES").unwrap_or(0),
        SCX_TASK_DSQ_ON_PRIQ: read_enum("scx_ent_dsq_flags","SCX_TASK_DSQ_ON_PRIQ").unwrap_or(0),
        SCX_KICK_IDLE: read_enum("scx_kick_flags","SCX_KICK_IDLE").unwrap_or(0),
        SCX_KICK_PREEMPT: read_enum("scx_kick_flags","SCX_KICK_PREEMPT").unwrap_or(0),
        SCX_KICK_WAIT: read_enum("scx_kick_flags","SCX_KICK_WAIT").unwrap_or(0),
        SCX_ENQ_WAKEUP: read_enum("scx_enq_flags","SCX_ENQ_WAKEUP").unwrap_or(0),
        SCX_ENQ_HEAD: read_enum("scx_enq_flags","SCX_ENQ_HEAD").unwrap_or(0),
        SCX_ENQ_PREEMPT: read_enum("scx_enq_flags","SCX_ENQ_PREEMPT").unwrap_or(0),
        SCX_ENQ_REENQ: read_enum("scx_enq_flags","SCX_ENQ_REENQ").unwrap_or(0),
        SCX_ENQ_LAST: read_enum("scx_enq_flags","SCX_ENQ_LAST").unwrap_or(0),
        SCX_ENQ_CLEAR_OPSS: read_enum("scx_enq_flags","SCX_ENQ_CLEAR_OPSS").unwrap_or(0),
        SCX_ENQ_DSQ_PRIQ: read_enum("scx_enq_flags","SCX_ENQ_DSQ_PRIQ").unwrap_or(0),
    };
}

#[rustfmt::skip]
#[macro_export]
macro_rules! import_enums {
    ($skel: ident) => { 'block : {
        let rodata = $skel.maps.rodata_data.as_mut().unwrap();
        rodata.__SCX_OPS_NAME_LEN = $crate::scx_enums.SCX_OPS_NAME_LEN;
        rodata.__SCX_SLICE_DFL = $crate::scx_enums.SCX_SLICE_DFL;
        rodata.__SCX_SLICE_INF = $crate::scx_enums.SCX_SLICE_INF;
        rodata.__SCX_RQ_ONLINE = $crate::scx_enums.SCX_RQ_ONLINE;
        rodata.__SCX_RQ_CAN_STOP_TICK = $crate::scx_enums.SCX_RQ_CAN_STOP_TICK;
        rodata.__SCX_RQ_BAL_PENDING = $crate::scx_enums.SCX_RQ_BAL_PENDING;
        rodata.__SCX_RQ_BAL_KEEP = $crate::scx_enums.SCX_RQ_BAL_KEEP;
        rodata.__SCX_RQ_BYPASSING = $crate::scx_enums.SCX_RQ_BYPASSING;
        rodata.__SCX_RQ_CLK_VALID = $crate::scx_enums.SCX_RQ_CLK_VALID;
        rodata.__SCX_RQ_IN_WAKEUP = $crate::scx_enums.SCX_RQ_IN_WAKEUP;
        rodata.__SCX_RQ_IN_BALANCE = $crate::scx_enums.SCX_RQ_IN_BALANCE;
        rodata.__SCX_DSQ_FLAG_BUILTIN = $crate::scx_enums.SCX_DSQ_FLAG_BUILTIN;
        rodata.__SCX_DSQ_FLAG_LOCAL_ON = $crate::scx_enums.SCX_DSQ_FLAG_LOCAL_ON;
        rodata.__SCX_DSQ_INVALID = $crate::scx_enums.SCX_DSQ_INVALID;
        rodata.__SCX_DSQ_GLOBAL = $crate::scx_enums.SCX_DSQ_GLOBAL;
        rodata.__SCX_DSQ_LOCAL = $crate::scx_enums.SCX_DSQ_LOCAL;
        rodata.__SCX_DSQ_LOCAL_ON = $crate::scx_enums.SCX_DSQ_LOCAL_ON;
        rodata.__SCX_DSQ_LOCAL_CPU_MASK = $crate::scx_enums.SCX_DSQ_LOCAL_CPU_MASK;
        rodata.__SCX_TASK_QUEUED = $crate::scx_enums.SCX_TASK_QUEUED;
        rodata.__SCX_TASK_RESET_RUNNABLE_AT = $crate::scx_enums.SCX_TASK_RESET_RUNNABLE_AT;
        rodata.__SCX_TASK_DEQD_FOR_SLEEP = $crate::scx_enums.SCX_TASK_DEQD_FOR_SLEEP;
        rodata.__SCX_TASK_STATE_SHIFT = $crate::scx_enums.SCX_TASK_STATE_SHIFT;
        rodata.__SCX_TASK_STATE_BITS = $crate::scx_enums.SCX_TASK_STATE_BITS;
        rodata.__SCX_TASK_STATE_MASK = $crate::scx_enums.SCX_TASK_STATE_MASK;
        rodata.__SCX_TASK_CURSOR = $crate::scx_enums.SCX_TASK_CURSOR;
        rodata.__SCX_TASK_NONE = $crate::scx_enums.SCX_TASK_NONE;
        rodata.__SCX_TASK_INIT = $crate::scx_enums.SCX_TASK_INIT;
        rodata.__SCX_TASK_READY = $crate::scx_enums.SCX_TASK_READY;
        rodata.__SCX_TASK_ENABLED = $crate::scx_enums.SCX_TASK_ENABLED;
        rodata.__SCX_TASK_NR_STATES = $crate::scx_enums.SCX_TASK_NR_STATES;
        rodata.__SCX_TASK_DSQ_ON_PRIQ = $crate::scx_enums.SCX_TASK_DSQ_ON_PRIQ;
        rodata.__SCX_KICK_IDLE = $crate::scx_enums.SCX_KICK_IDLE;
        rodata.__SCX_KICK_PREEMPT = $crate::scx_enums.SCX_KICK_PREEMPT;
        rodata.__SCX_KICK_WAIT = $crate::scx_enums.SCX_KICK_WAIT;
        rodata.__SCX_ENQ_WAKEUP = $crate::scx_enums.SCX_ENQ_WAKEUP;
        rodata.__SCX_ENQ_HEAD = $crate::scx_enums.SCX_ENQ_HEAD;
        rodata.__SCX_ENQ_PREEMPT = $crate::scx_enums.SCX_ENQ_PREEMPT;
        rodata.__SCX_ENQ_REENQ = $crate::scx_enums.SCX_ENQ_REENQ;
        rodata.__SCX_ENQ_LAST = $crate::scx_enums.SCX_ENQ_LAST;
        rodata.__SCX_ENQ_CLEAR_OPSS = $crate::scx_enums.SCX_ENQ_CLEAR_OPSS;
        rodata.__SCX_ENQ_DSQ_PRIQ = $crate::scx_enums.SCX_ENQ_DSQ_PRIQ;
    }};
}
