/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.FastDateParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FastDateParserSDFTest
extends AbstractLangTest {
    private static final TimeZone timeZone = TimeZone.getDefault();

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"z yyyy", "GMT 2010", Locale.UK, true}), Arguments.of((Object[])new Object[]{"z yyyy", "GMT-123 2010", Locale.UK, false}), Arguments.of((Object[])new Object[]{"z yyyy", "GMT-1234 2010", Locale.UK, false}), Arguments.of((Object[])new Object[]{"z yyyy", "GMT-12:34 2010", Locale.UK, true}), Arguments.of((Object[])new Object[]{"z yyyy", "GMT-1:23 2010", Locale.UK, true}), Arguments.of((Object[])new Object[]{"z yyyy", "-1234 2010", Locale.UK, true}), Arguments.of((Object[])new Object[]{"z yyyy", "-12:34 2010", Locale.UK, false}), Arguments.of((Object[])new Object[]{"z yyyy", "-123 2010", Locale.UK, false}), Arguments.of((Object[])new Object[]{"MM/dd/yyyy", "01/11/12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"MM/dd/yy", "01/11/12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "00", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "00", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "00", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "00", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "01", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "01", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "01", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "01", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "11", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "11", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "11", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "11", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "12", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "13", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "13", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "13", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "13", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "23", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "23", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "23", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "23", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "24", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "24", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "24", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "24", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "25", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "25", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "25", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "25", Locale.UK, true}), Arguments.of((Object[])new Object[]{"HH", "48", Locale.UK, true}), Arguments.of((Object[])new Object[]{"KK", "48", Locale.UK, true}), Arguments.of((Object[])new Object[]{"hh", "48", Locale.UK, true}), Arguments.of((Object[])new Object[]{"kk", "48", Locale.UK, true}));
    }

    private void checkParse(String formattedDate, String format, Locale locale, boolean valid) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        sdf.setTimeZone(timeZone);
        FastDateParser fdf = new FastDateParser(format, timeZone, locale);
        Date expectedTime = null;
        Class<?> sdfE = null;
        try {
            expectedTime = sdf.parse(formattedDate);
            if (!valid) {
                throw new RuntimeException("Test data error: expected SDF parse to fail, but got " + expectedTime);
            }
        }
        catch (ParseException e) {
            if (valid) {
                throw new RuntimeException("Test data error: expected SDF parse to succeed, but got " + e);
            }
            sdfE = e.getClass();
        }
        Date actualTime = null;
        Class<?> fdfE = null;
        try {
            actualTime = fdf.parse(formattedDate);
            Assertions.assertTrue((boolean)valid, (String)("Expected FDP parse to fail, but got " + actualTime));
        }
        catch (ParseException e) {
            Assertions.assertFalse((boolean)valid, (String)("Expected FDP parse to succeed, but got " + e));
            fdfE = e.getClass();
        }
        if (valid) {
            Assertions.assertEquals((Object)expectedTime, (Object)actualTime, (String)(locale + " " + formattedDate + "\n"));
        } else {
            Assertions.assertEquals(sdfE, fdfE, (String)(locale + " " + formattedDate + " expected same Exception "));
        }
    }

    private void checkParsePosition(String formattedDate, String format, Locale locale, boolean valid) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        sdf.setTimeZone(timeZone);
        FastDateParser fdf = new FastDateParser(format, timeZone, locale);
        ParsePosition sdfP = new ParsePosition(0);
        Date expectedTime = sdf.parse(formattedDate, sdfP);
        int sdferrorIndex = sdfP.getErrorIndex();
        if (valid) {
            Assertions.assertEquals((int)-1, (int)sdferrorIndex, (String)"Expected SDF error index -1 ");
            int endIndex = sdfP.getIndex();
            int length = formattedDate.length();
            if (endIndex != length) {
                throw new RuntimeException("Test data error: expected SDF parse to consume entire string; endindex " + endIndex + " != " + length);
            }
        } else {
            int errorIndex = sdfP.getErrorIndex();
            if (errorIndex == -1) {
                throw new RuntimeException("Test data error: expected SDF parse to fail, but got " + expectedTime);
            }
        }
        ParsePosition fdfP = new ParsePosition(0);
        Date actualTime = fdf.parse(formattedDate, fdfP);
        int fdferrorIndex = fdfP.getErrorIndex();
        if (valid) {
            Assertions.assertEquals((int)-1, (int)fdferrorIndex, (String)"Expected FDF error index -1 ");
            int endIndex = fdfP.getIndex();
            int length = formattedDate.length();
            Assertions.assertEquals((int)length, (int)endIndex, (String)("Expected FDF to parse full string " + fdfP));
            Assertions.assertEquals((Object)expectedTime, (Object)actualTime, (String)(locale + " " + formattedDate + "\n"));
        } else {
            Assertions.assertNotEquals((int)-1, (int)fdferrorIndex, (String)("Test data error: expected FDF parse to fail, but got " + actualTime));
            Assertions.assertTrue((sdferrorIndex - fdferrorIndex <= 4 ? 1 : 0) != 0, (String)("FDF error index (" + fdferrorIndex + ") should approximate SDF index (" + sdferrorIndex + ")"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLowerCase(String format, String input, Locale locale, boolean valid) {
        this.checkParse(input.toLowerCase(locale), format, locale, valid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLowerCasePP(String format, String input, Locale locale, boolean valid) {
        this.checkParsePosition(input.toLowerCase(locale), format, locale, valid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testOriginal(String format, String input, Locale locale, boolean valid) {
        this.checkParse(input, format, locale, valid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testOriginalPP(String format, String input, Locale locale, boolean valid) {
        this.checkParsePosition(input, format, locale, valid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUpperCase(String format, String input, Locale locale, boolean valid) {
        this.checkParse(input.toUpperCase(locale), format, locale, valid);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUpperCasePP(String format, String input, Locale locale, boolean valid) {
        this.checkParsePosition(input.toUpperCase(locale), format, locale, valid);
    }
}

