/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.time.AbstractFormatCache;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.TimeZones;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FastDateParserTest
extends AbstractLangTest {
    static final String DATE_PARSER_PARAMETERS = "dateParserParameters";
    static final String SHORT_FORMAT_NOERA = "y/M/d/h/a/m/s/E";
    static final String LONG_FORMAT_NOERA = "yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE";
    static final String SHORT_FORMAT = "G/y/M/d/h/a/m/s/E";
    static final String LONG_FORMAT = "GGGG/yyyy/MMMM/dddd/hhhh/mmmm/ss/aaaa/EEEE";
    private static final String yMdHmsSZ = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";
    private static final String DMY_DOT = "dd.MM.yyyy";
    private static final String YMD_SLASH = "yyyy/MM/dd";
    private static final String MDY_DASH = "MM-DD-yyyy";
    private static final String MDY_SLASH = "MM/DD/yyyy";
    private static final TimeZone REYKJAVIK = TimeZone.getTimeZone("Atlantic/Reykjavik");
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");
    private static final TimeZone INDIA = TimeZone.getTimeZone("Asia/Calcutta");
    private static final Locale SWEDEN = new Locale("sv", "SE");
    private final TriFunction<String, TimeZone, Locale, DateParser> dateParserProvider = (format, timeZone, locale) -> new FastDateParser(format, timeZone, locale, null);

    static void checkParse(Locale locale, Calendar cal, SimpleDateFormat simpleDateFormat, DateParser dateParser) {
        String formattedDate = simpleDateFormat.format(cal.getTime());
        FastDateParserTest.checkParse(locale, simpleDateFormat, dateParser, formattedDate, formattedDate);
        FastDateParserTest.checkParse(locale, simpleDateFormat, dateParser, formattedDate.toLowerCase(locale), formattedDate);
        FastDateParserTest.checkParse(locale, simpleDateFormat, dateParser, formattedDate.toUpperCase(locale), formattedDate);
    }

    static void checkParse(Locale locale, SimpleDateFormat simpleDateFormat, DateParser dateParser, String formattedDate, String originalFormattedDate) {
        try {
            Date expectedTime = simpleDateFormat.parse(formattedDate);
            Date actualTime = dateParser.parse(formattedDate);
            Assertions.assertEquals((Object)expectedTime, (Object)actualTime, (String)("locale: " + locale + ", formattedDate: '" + formattedDate + "', originalFormattedDate: '" + originalFormattedDate + ", simpleDateFormat.pattern: '" + simpleDateFormat + "', Java: " + SystemUtils.JAVA_RUNTIME_VERSION + "\n"));
        }
        catch (Exception e) {
            Assertions.fail((String)("locale: " + locale + ", formattedDate: '" + formattedDate + "', error : " + e + "\n"), (Throwable)e);
        }
    }

    static Stream<Arguments> dateParserParameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{(format, timeZone, locale) -> new FastDateParser(format, timeZone, locale, null)}), Arguments.of((Object[])new Object[]{FastDateFormat::getInstance}));
    }

    private static Calendar initializeCalendar(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(1, 2001);
        cal.set(2, 1);
        cal.set(5, 4);
        cal.set(11, 12);
        cal.set(12, 8);
        cal.set(13, 56);
        cal.set(14, 235);
        return cal;
    }

    private DateParser getDateInstance(int dateStyle, Locale locale) {
        return this.getInstance(null, AbstractFormatCache.getPatternForStyle((Integer)dateStyle, null, (Locale)locale), TimeZone.getDefault(), Locale.getDefault());
    }

    private Calendar getEraStart(int year, TimeZone zone, Locale locale) {
        Calendar cal = Calendar.getInstance(zone, locale);
        cal.clear();
        if (locale.equals(FastDateParser.JAPANESE_IMPERIAL)) {
            if (year < 1868) {
                cal.set(0, 0);
                cal.set(1, 1868 - year);
            }
        } else {
            if (year < 0) {
                cal.set(0, 0);
                year = -year;
            }
            cal.set(1, year / 100 * 100);
        }
        return cal;
    }

    DateParser getInstance(String format) {
        return this.getInstance(null, format, TimeZone.getDefault(), Locale.getDefault());
    }

    DateParser getInstance(String format, Locale locale) {
        return this.getInstance(null, format, TimeZone.getDefault(), locale);
    }

    private DateParser getInstance(String format, TimeZone timeZone) {
        return this.getInstance(null, format, timeZone, Locale.getDefault());
    }

    protected DateParser getInstance(TriFunction<String, TimeZone, Locale, DateParser> dpProvider, String format, TimeZone timeZone, Locale locale) {
        return (DateParser)(dpProvider == null ? this.dateParserProvider : dpProvider).apply((Object)format, (Object)timeZone, (Object)locale);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void test_Equality_Hash(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) {
        DateParser[] parsers = new DateParser[]{this.getInstance(dpProvider, yMdHmsSZ, NEW_YORK, Locale.US), this.getInstance(dpProvider, DMY_DOT, NEW_YORK, Locale.US), this.getInstance(dpProvider, YMD_SLASH, NEW_YORK, Locale.US), this.getInstance(dpProvider, MDY_DASH, NEW_YORK, Locale.US), this.getInstance(dpProvider, MDY_SLASH, NEW_YORK, Locale.US), this.getInstance(dpProvider, MDY_SLASH, REYKJAVIK, Locale.US), this.getInstance(dpProvider, MDY_SLASH, REYKJAVIK, SWEDEN)};
        HashMap<DateParser, Integer> map = new HashMap<DateParser, Integer>();
        int i = 0;
        for (DateParser parser : parsers) {
            map.put(parser, i++);
        }
        i = 0;
        for (DateParser parser : parsers) {
            Assertions.assertEquals((int)i++, (int)((Integer)map.get(parser)));
        }
    }

    @Test
    public void test1806() throws ParseException {
        String formatStub = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        String dateStub = "2001-02-04T12:08:56.235";
        for (Expected1806 trial : Expected1806.values()) {
            Calendar cal = FastDateParserTest.initializeCalendar(trial.zone);
            String message = trial.zone.getDisplayName() + ";";
            DateParser parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSX", trial.zone);
            Assertions.assertEquals((long)cal.getTime().getTime(), (long)(parser.parse("2001-02-04T12:08:56.235" + trial.one).getTime() - trial.offset), (String)(message + trial.one));
            parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXX", trial.zone);
            Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("2001-02-04T12:08:56.235" + trial.two), (String)(message + trial.two));
            parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", trial.zone);
            Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("2001-02-04T12:08:56.235" + trial.three), (String)(message + trial.three));
        }
    }

    @Test
    public void test1806Argument() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getInstance("XXXX"));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testAmPm(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        DateParser h = this.getInstance(dpProvider, "yyyy-MM-dd hh a mm:ss", NEW_YORK, Locale.US);
        DateParser K = this.getInstance(dpProvider, "yyyy-MM-dd KK a mm:ss", NEW_YORK, Locale.US);
        DateParser k = this.getInstance(dpProvider, "yyyy-MM-dd kk:mm:ss", NEW_YORK, Locale.US);
        DateParser H = this.getInstance(dpProvider, "yyyy-MM-dd HH:mm:ss", NEW_YORK, Locale.US);
        cal.set(2010, 7, 1, 0, 33, 20);
        Assertions.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 AM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 AM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 00:33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 00:33:20"));
        cal.set(2010, 7, 1, 3, 33, 20);
        Assertions.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 AM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 AM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 03:33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 03:33:20"));
        cal.set(2010, 7, 1, 15, 33, 20);
        Assertions.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 3 PM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 3 PM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 15:33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 15:33:20"));
        cal.set(2010, 7, 1, 12, 33, 20);
        Assertions.assertEquals((Object)cal.getTime(), (Object)h.parse("2010-08-01 12 PM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)K.parse("2010-08-01 0 PM 33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)k.parse("2010-08-01 12:33:20"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)H.parse("2010-08-01 12:33:20"));
    }

    @Test
    public void testDayNumberOfWeek() throws ParseException {
        DateParser parser = this.getInstance("u");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parser.parse("1"));
        Assertions.assertEquals((int)2, (int)calendar.get(7));
        calendar.setTime(parser.parse("6"));
        Assertions.assertEquals((int)7, (int)calendar.get(7));
        calendar.setTime(parser.parse("7"));
        Assertions.assertEquals((int)1, (int)calendar.get(7));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testDayOf(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10);
        DateParser fdf = this.getInstance(dpProvider, "W w F D y", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("3 7 2 41 03"));
    }

    @Test
    public void testEquals() {
        DateParser parser1 = this.getInstance(YMD_SLASH);
        DateParser parser2 = this.getInstance(YMD_SLASH);
        Assertions.assertEquals((Object)parser1, (Object)parser2);
        Assertions.assertEquals((int)parser1.hashCode(), (int)parser2.hashCode());
        Assertions.assertNotEquals((Object)parser1, (Object)new Object());
    }

    @Test
    public void testJpLocales() {
        Calendar cal = Calendar.getInstance(TimeZones.GMT);
        cal.clear();
        cal.set(2003, 1, 10);
        cal.set(0, 0);
        Locale locale = LocaleUtils.toLocale((String)"zh");
        SimpleDateFormat sdf = new SimpleDateFormat(LONG_FORMAT, locale);
        DateParser fdf = this.getInstance(LONG_FORMAT, locale);
        FastDateParserTest.checkParse(locale, cal, sdf, fdf);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testLANG_831(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testSdfAndFdp(dpProvider, "M E", "3  Tue", true);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testLANG_832(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testSdfAndFdp(dpProvider, "'d'd", "d3", false);
        this.testSdfAndFdp(dpProvider, "'d'd'", "d3", true);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testLang1121(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        TimeZone kst = TimeZone.getTimeZone("KST");
        DateParser fdp = this.getInstance(dpProvider, "yyyyMMdd", kst, Locale.KOREA);
        Assertions.assertThrows(ParseException.class, () -> fdp.parse("2015"));
        Date actual = fdp.parse("20150429");
        Calendar cal = Calendar.getInstance(kst, Locale.KOREA);
        cal.clear();
        cal.set(2015, 3, 29);
        Date expected = cal.getTime();
        Assertions.assertEquals((Object)expected, (Object)actual);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
        df.setTimeZone(kst);
        expected = df.parse("20150429113100");
        actual = fdp.parse("20150429113100");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testLang1380(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar expected = Calendar.getInstance(TimeZones.GMT, Locale.FRANCE);
        expected.clear();
        expected.set(2014, 3, 14);
        DateParser fdp = this.getInstance(dpProvider, "dd MMM yyyy", TimeZones.GMT, Locale.FRANCE);
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avril 2014"));
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avr. 2014"));
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14 avr 2014"));
    }

    @Test
    public void testLang303() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        Date date = parser.parse("2004/11/31");
        parser = (DateParser)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)parser)));
        Assertions.assertEquals((Object)date, (Object)parser.parse("2004/11/31"));
    }

    @Test
    public void testLang538() throws ParseException {
        DateParser parser = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZones.GMT);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("2009-10-16T16:42:16.000Z"));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testLang996(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar expected = Calendar.getInstance(NEW_YORK, Locale.US);
        expected.clear();
        expected.set(2014, 4, 14);
        DateParser fdp = this.getInstance(dpProvider, "ddMMMyyyy", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14may2014"));
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14MAY2014"));
        Assertions.assertEquals((Object)expected.getTime(), (Object)fdp.parse("14May2014"));
    }

    @Test
    public void testLocaleMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, SWEDEN);
        Assertions.assertEquals((Object)SWEDEN, (Object)parser.getLocale());
    }

    @Test
    public void testLowYearPadding() throws ParseException {
        DateParser parser = this.getInstance(YMD_SLASH);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("0001/01/01"));
        cal.set(10, 0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("0010/01/01"));
        cal.set(100, 0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("0100/01/01"));
        cal.set(999, 0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("0999/01/01"));
    }

    @Test
    public void testMilleniumBug() throws ParseException {
        DateParser parser = this.getInstance(DMY_DOT);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1000, 0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)parser.parse("01.01.1000"));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testParseLongShort(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        cal.setTimeZone(NEW_YORK);
        DateParser fdf = this.getInstance(dpProvider, "yyyy GGGG MMMM dddd aaaa EEEE HHHH mmmm ssss SSSS ZZZZ", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003 AD February 0010 PM Monday 0015 0033 0020 0989 GMT-05:00"));
        cal.set(0, 0);
        Date parse = fdf.parse("2003 BC February 0010 PM Saturday 0015 0033 0020 0989 GMT-05:00");
        Assertions.assertEquals((Object)cal.getTime(), (Object)parse);
        fdf = this.getInstance(null, "y G M d a E H m s S Z", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 BC 2 10 PM Sat 15 33 20 989 -0500"));
        cal.set(0, 1);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("03 AD 2 10 PM Saturday 15 33 20 989 -0500"));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testParseNumerics(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance(dpProvider, "yyyyMMddHHmmssSSS", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("20030210153320989"));
    }

    @Test
    public void testParseOffset() {
        DateParser parser = this.getInstance(YMD_SLASH);
        Date date = parser.parse("Today is 2015/07/04", new ParsePosition(9));
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2015, 6, 4);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
    }

    @Test
    public void testParses() throws Exception {
        for (String format : new String[]{LONG_FORMAT, SHORT_FORMAT}) {
            for (Locale locale : Locale.getAvailableLocales()) {
                for (TimeZone timeZone : new TimeZone[]{NEW_YORK, REYKJAVIK, TimeZones.GMT}) {
                    for (int year : new int[]{2003, 1940, 1868, 1867, 1, -1, -1940}) {
                        Calendar cal = this.getEraStart(year, timeZone, locale);
                        Date centuryStart = cal.getTime();
                        cal.set(2, 1);
                        cal.set(5, 10);
                        Date in = cal.getTime();
                        FastDateParser fastDateParser = new FastDateParser(format, timeZone, locale, centuryStart);
                        this.validateSdfFormatFdpParseEquality(format, locale, timeZone, fastDateParser, in, year, centuryStart);
                    }
                }
            }
        }
    }

    @Test
    public void testParsesKnownJava16Ea25Failure() throws Exception {
        String format = LONG_FORMAT;
        int year = 2003;
        Locale locale = new Locale.Builder().setLanguage("sq").setRegion("MK").build();
        Assertions.assertEquals((Object)"sq_MK", (Object)locale.toString());
        Assertions.assertNotNull((Object)locale);
        TimeZone timeZone = NEW_YORK;
        Calendar cal = this.getEraStart(2003, timeZone, locale);
        Date centuryStart = cal.getTime();
        cal.set(2, 1);
        cal.set(5, 10);
        Date in = cal.getTime();
        FastDateParser fastDateParser = new FastDateParser(LONG_FORMAT, timeZone, locale, centuryStart);
        this.validateSdfFormatFdpParseEquality(LONG_FORMAT, locale, timeZone, fastDateParser, in, 2003, centuryStart);
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testParseZone(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 6, 10, 16, 33, 20);
        DateParser fdf = this.getInstance(dpProvider, yMdHmsSZ, NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 -0500"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T15:33:20.000 GMT-05:00"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 Eastern Daylight Time"));
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-07-10T16:33:20.000 EDT"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT-3"));
        cal.set(2003, 1, 10, 9, 0, 0);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T09:00:00.000 -0300"));
        cal.setTimeZone(TimeZone.getTimeZone("GMT+5"));
        cal.set(2003, 1, 10, 15, 5, 6);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2003-02-10T15:05:06.000 +0500"));
    }

    @Test
    public void testPatternMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ);
        Assertions.assertEquals((Object)yMdHmsSZ, (Object)parser.getPattern());
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testQuotes(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws ParseException {
        Calendar cal = Calendar.getInstance(NEW_YORK, Locale.US);
        cal.clear();
        cal.set(2003, 1, 10, 15, 33, 20);
        cal.set(14, 989);
        DateParser fdf = this.getInstance(dpProvider, "''yyyyMMdd'A''B'HHmmssSSS''", NEW_YORK, Locale.US);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("'20030210A'B153320989'"));
    }

    private void testSdfAndFdp(TriFunction<String, TimeZone, Locale, DateParser> dbProvider, String format, String date, boolean shouldFail) throws Exception {
        Exception s;
        Exception f;
        Date dsdf;
        Date dfdp;
        block5: {
            block4: {
                dfdp = null;
                dsdf = null;
                f = null;
                s = null;
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
                    sdf.setTimeZone(NEW_YORK);
                    dsdf = sdf.parse(date);
                    Assertions.assertFalse((boolean)shouldFail, (String)("Expected SDF failure, but got " + dsdf + " for [" + format + ", " + date + "]"));
                }
                catch (Exception e) {
                    s = e;
                    if (shouldFail) break block4;
                    throw e;
                }
            }
            try {
                DateParser fdp = this.getInstance(dbProvider, format, NEW_YORK, Locale.US);
                dfdp = fdp.parse(date);
                Assertions.assertFalse((boolean)shouldFail, (String)("Expected FDF failure, but got " + dfdp + " for [" + format + ", " + date + "]"));
            }
            catch (Exception e) {
                f = e;
                if (shouldFail) break block5;
                throw e;
            }
        }
        Assertions.assertEquals((Object)(f == null ? 1 : 0), (Object)(s == null ? 1 : 0), (String)"Should both or neither throw Exceptions");
        Assertions.assertEquals((Object)dsdf, (Object)dfdp, (String)"Parsed dates should be equal");
    }

    @Test
    public void testShortDateStyleWithLocales() throws ParseException {
        DateParser fdf = this.getDateInstance(3, Locale.US);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2004, 1, 3);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2/3/04"));
        fdf = this.getDateInstance(3, SWEDEN);
        Assertions.assertEquals((Object)cal.getTime(), (Object)fdf.parse("2004-02-03"));
    }

    @ParameterizedTest
    @MethodSource(value={"dateParserParameters"})
    public void testSpecialCharacters(TriFunction<String, TimeZone, Locale, DateParser> dpProvider) throws Exception {
        this.testSdfAndFdp(dpProvider, "q", "", true);
        this.testSdfAndFdp(dpProvider, "Q", "", true);
        this.testSdfAndFdp(dpProvider, "$", "$", false);
        this.testSdfAndFdp(dpProvider, "?.d", "?.12", false);
        this.testSdfAndFdp(dpProvider, "''yyyyMMdd'A''B'HHmmssSSS''", "'20030210A'B153320989'", false);
        this.testSdfAndFdp(dpProvider, "''''yyyyMMdd'A''B'HHmmssSSS''", "''20030210A'B153320989'", false);
        this.testSdfAndFdp(dpProvider, "'$\\Ed'", "$\\Ed", false);
        this.testSdfAndFdp(dpProvider, "'QED'", "QED", false);
        this.testSdfAndFdp(dpProvider, "'QED'", "qed", true);
        this.testSdfAndFdp(dpProvider, "yyyy-MM-dd 'QED'", "2003-02-10 QED", false);
        this.testSdfAndFdp(dpProvider, "yyyy-MM-dd 'QED'", "2003-02-10 qed", true);
    }

    @Test
    public void testTimeZoneMatches() {
        DateParser parser = this.getInstance(yMdHmsSZ, REYKJAVIK);
        Assertions.assertEquals((Object)REYKJAVIK, (Object)parser.getTimeZone());
    }

    @Test
    public void testToStringContainsName() {
        DateParser parser = this.getInstance(YMD_SLASH);
        Assertions.assertTrue((boolean)parser.toString().startsWith("FastDate"));
    }

    @Test
    public void testTzParses() throws Exception {
        for (Locale locale : Locale.getAvailableLocales()) {
            FastDateParser fdp = new FastDateParser("yyyy/MM/dd z", TimeZone.getDefault(), locale);
            for (TimeZone timeZone : new TimeZone[]{NEW_YORK, REYKJAVIK, TimeZones.GMT}) {
                Calendar cal = Calendar.getInstance(timeZone, locale);
                cal.clear();
                cal.set(1, 2000);
                cal.set(2, 1);
                cal.set(5, 10);
                Date expected = cal.getTime();
                Date actual = fdp.parse("2000/02/10 " + timeZone.getDisplayName(locale));
                Assertions.assertEquals((Object)expected, (Object)actual, (String)("timeZone:" + timeZone.getID() + " locale:" + locale.getDisplayName()));
            }
        }
    }

    private void validateSdfFormatFdpParseEquality(String formatStr, Locale locale, TimeZone timeZone, FastDateParser dateParser, Date inDate, int year, Date csDate) throws ParseException {
        block3: {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStr, locale);
            sdf.setTimeZone(timeZone);
            if (formatStr.equals(SHORT_FORMAT)) {
                sdf.set2DigitYearStart(csDate);
            }
            String fmt = sdf.format(inDate);
            try {
                Date out = dateParser.parse(fmt);
                Assertions.assertEquals((Object)inDate, (Object)out, (String)("format: '" + formatStr + "', locale: '" + locale + "', time zone: '" + timeZone.getID() + "', year: " + year + ", parse: '" + fmt));
            }
            catch (ParseException pe) {
                if (year < 1868 && locale.getCountry().equals("JP")) break block3;
                throw pe;
            }
        }
    }

    static /* synthetic */ TimeZone access$000() {
        return INDIA;
    }

    static /* synthetic */ TimeZone access$100() {
        return NEW_YORK;
    }

    private static enum Expected1806 {
        India(FastDateParserTest.access$000(), "+05", "+0530", "+05:30", true),
        Greenwich(TimeZones.GMT, "Z", "Z", "Z", false),
        NewYork(FastDateParserTest.access$100(), "-05", "-0500", "-05:00", false);

        final TimeZone zone;
        final String one;
        final String two;
        final String three;
        final long offset;

        private Expected1806(TimeZone zone, String one, String two, String three, boolean hasHalfHourOffset) {
            this.zone = zone;
            this.one = one;
            this.two = two;
            this.three = three;
            this.offset = hasHalfHourOffset ? 1800000L : 0L;
        }
    }
}

