/*
 * steam.c
 *
 * Copyright (C) 2011-25 - ntop.org
 * Copyright (C) 2014 Tomasz Bujlow <tomasz@skatnet.dk>
 *
 * This file is part of nDPI, an open source deep packet inspection
 * library based on the OpenDPI and PACE technology by ipoque GmbH
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "ndpi_protocol_ids.h"

#define NDPI_CURRENT_PROTO NDPI_PROTOCOL_STEAM

#include "ndpi_api.h"
#include "ndpi_private.h"

static void ndpi_search_steam(struct ndpi_detection_module_struct *ndpi_struct,
                              struct ndpi_flow_struct *flow)
{
  struct ndpi_packet_struct const * const packet = &ndpi_struct->packet;

  NDPI_LOG_DBG(ndpi_struct, "search Steam\n");

  /* Steam In-Home Streaming Discovery */
  if (packet->payload_packet_len >= 40)
  {
    if (le64toh(get_u_int64_t(packet->payload, 0)) == 0xA05F4C21FFFFFFFF)
    {
      NDPI_LOG_INFO(ndpi_struct, "found Steam In-Home Streaming Discovery\n");
      ndpi_set_detected_protocol(ndpi_struct, flow, NDPI_PROTOCOL_STEAM,
                                 NDPI_PROTOCOL_UNKNOWN, NDPI_CONFIDENCE_DPI);
      return;
    }
  }

  /* TODO: implement Steam Remote Play detection */

  NDPI_EXCLUDE_PROTO(ndpi_struct, flow);
}

void init_steam_dissector(struct ndpi_detection_module_struct *ndpi_struct, u_int32_t *id)
{
  ndpi_set_bitmask_protocol_detection("Steam", ndpi_struct, *id,
                                      NDPI_PROTOCOL_STEAM,
                                      ndpi_search_steam,
                                      NDPI_SELECTION_BITMASK_PROTOCOL_V4_V6_UDP_WITH_PAYLOAD,
                                      SAVE_DETECTION_BITMASK_AS_UNKNOWN,
                                      ADD_TO_DETECTION_BITMASK);

  *id += 1;
}
