// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +experimental-zvabd -disable-O0-optnone \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vabd_vv_u8mf8_tu
// CHECK-RV64-SAME: (<vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vabd.nxv1i8.i64(<vscale x 1 x i8> [[VD]], <vscale x 1 x i8> [[VS2]], <vscale x 1 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vabd_vv_u8mf8_tu(vuint8mf8_t vd, vint8mf8_t vs2,
                                  vint8mf8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf8_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vabd_vv_u8mf4_tu
// CHECK-RV64-SAME: (<vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vabd.nxv2i8.i64(<vscale x 2 x i8> [[VD]], <vscale x 2 x i8> [[VS2]], <vscale x 2 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vabd_vv_u8mf4_tu(vuint8mf4_t vd, vint8mf4_t vs2,
                                  vint8mf4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf4_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vabd_vv_u8mf2_tu
// CHECK-RV64-SAME: (<vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vabd.nxv4i8.i64(<vscale x 4 x i8> [[VD]], <vscale x 4 x i8> [[VS2]], <vscale x 4 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vabd_vv_u8mf2_tu(vuint8mf2_t vd, vint8mf2_t vs2,
                                  vint8mf2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf2_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vabd_vv_u8m1_tu
// CHECK-RV64-SAME: (<vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vabd.nxv8i8.i64(<vscale x 8 x i8> [[VD]], <vscale x 8 x i8> [[VS2]], <vscale x 8 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vabd_vv_u8m1_tu(vuint8m1_t vd, vint8m1_t vs2, vint8m1_t vs1,
                                size_t vl) {
  return __riscv_vabd_vv_u8m1_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vabd_vv_u8m2_tu
// CHECK-RV64-SAME: (<vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vabd.nxv16i8.i64(<vscale x 16 x i8> [[VD]], <vscale x 16 x i8> [[VS2]], <vscale x 16 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vabd_vv_u8m2_tu(vuint8m2_t vd, vint8m2_t vs2, vint8m2_t vs1,
                                size_t vl) {
  return __riscv_vabd_vv_u8m2_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vabd_vv_u8m4_tu
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vabd.nxv32i8.i64(<vscale x 32 x i8> [[VD]], <vscale x 32 x i8> [[VS2]], <vscale x 32 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vabd_vv_u8m4_tu(vuint8m4_t vd, vint8m4_t vs2, vint8m4_t vs1,
                                size_t vl) {
  return __riscv_vabd_vv_u8m4_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vabd_vv_u8m8_tu
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vabd.nxv64i8.i64(<vscale x 64 x i8> [[VD]], <vscale x 64 x i8> [[VS2]], <vscale x 64 x i8> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vabd_vv_u8m8_tu(vuint8m8_t vd, vint8m8_t vs2, vint8m8_t vs1,
                                size_t vl) {
  return __riscv_vabd_vv_u8m8_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vabd_vv_u16mf4_tu
// CHECK-RV64-SAME: (<vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vabd.nxv1i16.i64(<vscale x 1 x i16> [[VD]], <vscale x 1 x i16> [[VS2]], <vscale x 1 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vabd_vv_u16mf4_tu(vuint16mf4_t vd, vint16mf4_t vs2,
                                    vint16mf4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16mf4_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vabd_vv_u16mf2_tu
// CHECK-RV64-SAME: (<vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vabd.nxv2i16.i64(<vscale x 2 x i16> [[VD]], <vscale x 2 x i16> [[VS2]], <vscale x 2 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vabd_vv_u16mf2_tu(vuint16mf2_t vd, vint16mf2_t vs2,
                                    vint16mf2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16mf2_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vabd_vv_u16m1_tu
// CHECK-RV64-SAME: (<vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vabd.nxv4i16.i64(<vscale x 4 x i16> [[VD]], <vscale x 4 x i16> [[VS2]], <vscale x 4 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vabd_vv_u16m1_tu(vuint16m1_t vd, vint16m1_t vs2,
                                  vint16m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m1_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vabd_vv_u16m2_tu
// CHECK-RV64-SAME: (<vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vabd.nxv8i16.i64(<vscale x 8 x i16> [[VD]], <vscale x 8 x i16> [[VS2]], <vscale x 8 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vabd_vv_u16m2_tu(vuint16m2_t vd, vint16m2_t vs2,
                                  vint16m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m2_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vabd_vv_u16m4_tu
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vabd.nxv16i16.i64(<vscale x 16 x i16> [[VD]], <vscale x 16 x i16> [[VS2]], <vscale x 16 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vabd_vv_u16m4_tu(vuint16m4_t vd, vint16m4_t vs2,
                                  vint16m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m4_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vabd_vv_u16m8_tu
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vabd.nxv32i16.i64(<vscale x 32 x i16> [[VD]], <vscale x 32 x i16> [[VS2]], <vscale x 32 x i16> [[VS1]], i64 [[VL]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vabd_vv_u16m8_tu(vuint16m8_t vd, vint16m8_t vs2,
                                  vint16m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m8_tu(vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vabd_vv_u8mf8_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vabd.mask.nxv1i8.i64(<vscale x 1 x i8> [[VD]], <vscale x 1 x i8> [[VS2]], <vscale x 1 x i8> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vabd_vv_u8mf8_tum(vbool64_t vm, vuint8mf8_t vd, vint8mf8_t vs2,
                                   vint8mf8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf8_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vabd_vv_u8mf4_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vabd.mask.nxv2i8.i64(<vscale x 2 x i8> [[VD]], <vscale x 2 x i8> [[VS2]], <vscale x 2 x i8> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vabd_vv_u8mf4_tum(vbool32_t vm, vuint8mf4_t vd, vint8mf4_t vs2,
                                   vint8mf4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf4_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vabd_vv_u8mf2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vabd.mask.nxv4i8.i64(<vscale x 4 x i8> [[VD]], <vscale x 4 x i8> [[VS2]], <vscale x 4 x i8> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vabd_vv_u8mf2_tum(vbool16_t vm, vuint8mf2_t vd, vint8mf2_t vs2,
                                   vint8mf2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf2_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vabd_vv_u8m1_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vabd.mask.nxv8i8.i64(<vscale x 8 x i8> [[VD]], <vscale x 8 x i8> [[VS2]], <vscale x 8 x i8> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vabd_vv_u8m1_tum(vbool8_t vm, vuint8m1_t vd, vint8m1_t vs2,
                                 vint8m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m1_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vabd_vv_u8m2_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vabd.mask.nxv16i8.i64(<vscale x 16 x i8> [[VD]], <vscale x 16 x i8> [[VS2]], <vscale x 16 x i8> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vabd_vv_u8m2_tum(vbool4_t vm, vuint8m2_t vd, vint8m2_t vs2,
                                 vint8m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m2_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vabd_vv_u8m4_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vabd.mask.nxv32i8.i64(<vscale x 32 x i8> [[VD]], <vscale x 32 x i8> [[VS2]], <vscale x 32 x i8> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vabd_vv_u8m4_tum(vbool2_t vm, vuint8m4_t vd, vint8m4_t vs2,
                                 vint8m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m4_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vabd_vv_u8m8_tum
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[VM:%.*]], <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vabd.mask.nxv64i8.i64(<vscale x 64 x i8> [[VD]], <vscale x 64 x i8> [[VS2]], <vscale x 64 x i8> [[VS1]], <vscale x 64 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vabd_vv_u8m8_tum(vbool1_t vm, vuint8m8_t vd, vint8m8_t vs2,
                                 vint8m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m8_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vabd_vv_u16mf4_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vabd.mask.nxv1i16.i64(<vscale x 1 x i16> [[VD]], <vscale x 1 x i16> [[VS2]], <vscale x 1 x i16> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vabd_vv_u16mf4_tum(vbool64_t vm, vuint16mf4_t vd,
                                     vint16mf4_t vs2, vint16mf4_t vs1,
                                     size_t vl) {
  return __riscv_vabd_vv_u16mf4_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vabd_vv_u16mf2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vabd.mask.nxv2i16.i64(<vscale x 2 x i16> [[VD]], <vscale x 2 x i16> [[VS2]], <vscale x 2 x i16> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vabd_vv_u16mf2_tum(vbool32_t vm, vuint16mf2_t vd,
                                     vint16mf2_t vs2, vint16mf2_t vs1,
                                     size_t vl) {
  return __riscv_vabd_vv_u16mf2_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vabd_vv_u16m1_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vabd.mask.nxv4i16.i64(<vscale x 4 x i16> [[VD]], <vscale x 4 x i16> [[VS2]], <vscale x 4 x i16> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vabd_vv_u16m1_tum(vbool16_t vm, vuint16m1_t vd, vint16m1_t vs2,
                                   vint16m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m1_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vabd_vv_u16m2_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vabd.mask.nxv8i16.i64(<vscale x 8 x i16> [[VD]], <vscale x 8 x i16> [[VS2]], <vscale x 8 x i16> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vabd_vv_u16m2_tum(vbool8_t vm, vuint16m2_t vd, vint16m2_t vs2,
                                   vint16m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m2_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vabd_vv_u16m4_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vabd.mask.nxv16i16.i64(<vscale x 16 x i16> [[VD]], <vscale x 16 x i16> [[VS2]], <vscale x 16 x i16> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vabd_vv_u16m4_tum(vbool4_t vm, vuint16m4_t vd, vint16m4_t vs2,
                                   vint16m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m4_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vabd_vv_u16m8_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vabd.mask.nxv32i16.i64(<vscale x 32 x i16> [[VD]], <vscale x 32 x i16> [[VS2]], <vscale x 32 x i16> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vabd_vv_u16m8_tum(vbool2_t vm, vuint16m8_t vd, vint16m8_t vs2,
                                   vint16m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m8_tum(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vabd_vv_u8mf8_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vabd.mask.nxv1i8.i64(<vscale x 1 x i8> [[VD]], <vscale x 1 x i8> [[VS2]], <vscale x 1 x i8> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vabd_vv_u8mf8_tumu(vbool64_t vm, vuint8mf8_t vd,
                                    vint8mf8_t vs2, vint8mf8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf8_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vabd_vv_u8mf4_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vabd.mask.nxv2i8.i64(<vscale x 2 x i8> [[VD]], <vscale x 2 x i8> [[VS2]], <vscale x 2 x i8> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vabd_vv_u8mf4_tumu(vbool32_t vm, vuint8mf4_t vd,
                                    vint8mf4_t vs2, vint8mf4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf4_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vabd_vv_u8mf2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vabd.mask.nxv4i8.i64(<vscale x 4 x i8> [[VD]], <vscale x 4 x i8> [[VS2]], <vscale x 4 x i8> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vabd_vv_u8mf2_tumu(vbool16_t vm, vuint8mf2_t vd,
                                    vint8mf2_t vs2, vint8mf2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf2_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vabd_vv_u8m1_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vabd.mask.nxv8i8.i64(<vscale x 8 x i8> [[VD]], <vscale x 8 x i8> [[VS2]], <vscale x 8 x i8> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vabd_vv_u8m1_tumu(vbool8_t vm, vuint8m1_t vd, vint8m1_t vs2,
                                  vint8m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m1_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vabd_vv_u8m2_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vabd.mask.nxv16i8.i64(<vscale x 16 x i8> [[VD]], <vscale x 16 x i8> [[VS2]], <vscale x 16 x i8> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vabd_vv_u8m2_tumu(vbool4_t vm, vuint8m2_t vd, vint8m2_t vs2,
                                  vint8m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m2_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vabd_vv_u8m4_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vabd.mask.nxv32i8.i64(<vscale x 32 x i8> [[VD]], <vscale x 32 x i8> [[VS2]], <vscale x 32 x i8> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vabd_vv_u8m4_tumu(vbool2_t vm, vuint8m4_t vd, vint8m4_t vs2,
                                  vint8m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m4_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vabd_vv_u8m8_tumu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[VM:%.*]], <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vabd.mask.nxv64i8.i64(<vscale x 64 x i8> [[VD]], <vscale x 64 x i8> [[VS2]], <vscale x 64 x i8> [[VS1]], <vscale x 64 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vabd_vv_u8m8_tumu(vbool1_t vm, vuint8m8_t vd, vint8m8_t vs2,
                                  vint8m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m8_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vabd_vv_u16mf4_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vabd.mask.nxv1i16.i64(<vscale x 1 x i16> [[VD]], <vscale x 1 x i16> [[VS2]], <vscale x 1 x i16> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vabd_vv_u16mf4_tumu(vbool64_t vm, vuint16mf4_t vd,
                                      vint16mf4_t vs2, vint16mf4_t vs1,
                                      size_t vl) {
  return __riscv_vabd_vv_u16mf4_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vabd_vv_u16mf2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vabd.mask.nxv2i16.i64(<vscale x 2 x i16> [[VD]], <vscale x 2 x i16> [[VS2]], <vscale x 2 x i16> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vabd_vv_u16mf2_tumu(vbool32_t vm, vuint16mf2_t vd,
                                      vint16mf2_t vs2, vint16mf2_t vs1,
                                      size_t vl) {
  return __riscv_vabd_vv_u16mf2_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vabd_vv_u16m1_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vabd.mask.nxv4i16.i64(<vscale x 4 x i16> [[VD]], <vscale x 4 x i16> [[VS2]], <vscale x 4 x i16> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vabd_vv_u16m1_tumu(vbool16_t vm, vuint16m1_t vd,
                                    vint16m1_t vs2, vint16m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m1_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vabd_vv_u16m2_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vabd.mask.nxv8i16.i64(<vscale x 8 x i16> [[VD]], <vscale x 8 x i16> [[VS2]], <vscale x 8 x i16> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vabd_vv_u16m2_tumu(vbool8_t vm, vuint16m2_t vd, vint16m2_t vs2,
                                    vint16m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m2_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vabd_vv_u16m4_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vabd.mask.nxv16i16.i64(<vscale x 16 x i16> [[VD]], <vscale x 16 x i16> [[VS2]], <vscale x 16 x i16> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vabd_vv_u16m4_tumu(vbool4_t vm, vuint16m4_t vd, vint16m4_t vs2,
                                    vint16m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m4_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vabd_vv_u16m8_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vabd.mask.nxv32i16.i64(<vscale x 32 x i16> [[VD]], <vscale x 32 x i16> [[VS2]], <vscale x 32 x i16> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vabd_vv_u16m8_tumu(vbool2_t vm, vuint16m8_t vd, vint16m8_t vs2,
                                    vint16m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m8_tumu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vabd_vv_u8mf8_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i8> [[VD:%.*]], <vscale x 1 x i8> [[VS2:%.*]], <vscale x 1 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vabd.mask.nxv1i8.i64(<vscale x 1 x i8> [[VD]], <vscale x 1 x i8> [[VS2]], <vscale x 1 x i8> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vabd_vv_u8mf8_mu(vbool64_t vm, vuint8mf8_t vd, vint8mf8_t vs2,
                                  vint8mf8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf8_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vabd_vv_u8mf4_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i8> [[VD:%.*]], <vscale x 2 x i8> [[VS2:%.*]], <vscale x 2 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vabd.mask.nxv2i8.i64(<vscale x 2 x i8> [[VD]], <vscale x 2 x i8> [[VS2]], <vscale x 2 x i8> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vabd_vv_u8mf4_mu(vbool32_t vm, vuint8mf4_t vd, vint8mf4_t vs2,
                                  vint8mf4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf4_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vabd_vv_u8mf2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i8> [[VD:%.*]], <vscale x 4 x i8> [[VS2:%.*]], <vscale x 4 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vabd.mask.nxv4i8.i64(<vscale x 4 x i8> [[VD]], <vscale x 4 x i8> [[VS2]], <vscale x 4 x i8> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vabd_vv_u8mf2_mu(vbool16_t vm, vuint8mf2_t vd, vint8mf2_t vs2,
                                  vint8mf2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8mf2_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vabd_vv_u8m1_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i8> [[VD:%.*]], <vscale x 8 x i8> [[VS2:%.*]], <vscale x 8 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vabd.mask.nxv8i8.i64(<vscale x 8 x i8> [[VD]], <vscale x 8 x i8> [[VS2]], <vscale x 8 x i8> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vabd_vv_u8m1_mu(vbool8_t vm, vuint8m1_t vd, vint8m1_t vs2,
                                vint8m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m1_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vabd_vv_u8m2_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i8> [[VD:%.*]], <vscale x 16 x i8> [[VS2:%.*]], <vscale x 16 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vabd.mask.nxv16i8.i64(<vscale x 16 x i8> [[VD]], <vscale x 16 x i8> [[VS2]], <vscale x 16 x i8> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vabd_vv_u8m2_mu(vbool4_t vm, vuint8m2_t vd, vint8m2_t vs2,
                                vint8m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m2_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vabd_vv_u8m4_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i8> [[VD:%.*]], <vscale x 32 x i8> [[VS2:%.*]], <vscale x 32 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vabd.mask.nxv32i8.i64(<vscale x 32 x i8> [[VD]], <vscale x 32 x i8> [[VS2]], <vscale x 32 x i8> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vabd_vv_u8m4_mu(vbool2_t vm, vuint8m4_t vd, vint8m4_t vs2,
                                vint8m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m4_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vabd_vv_u8m8_mu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[VM:%.*]], <vscale x 64 x i8> [[VD:%.*]], <vscale x 64 x i8> [[VS2:%.*]], <vscale x 64 x i8> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vabd.mask.nxv64i8.i64(<vscale x 64 x i8> [[VD]], <vscale x 64 x i8> [[VS2]], <vscale x 64 x i8> [[VS1]], <vscale x 64 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vabd_vv_u8m8_mu(vbool1_t vm, vuint8m8_t vd, vint8m8_t vs2,
                                vint8m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u8m8_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vabd_vv_u16mf4_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[VM:%.*]], <vscale x 1 x i16> [[VD:%.*]], <vscale x 1 x i16> [[VS2:%.*]], <vscale x 1 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vabd.mask.nxv1i16.i64(<vscale x 1 x i16> [[VD]], <vscale x 1 x i16> [[VS2]], <vscale x 1 x i16> [[VS1]], <vscale x 1 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vabd_vv_u16mf4_mu(vbool64_t vm, vuint16mf4_t vd,
                                    vint16mf4_t vs2, vint16mf4_t vs1,
                                    size_t vl) {
  return __riscv_vabd_vv_u16mf4_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vabd_vv_u16mf2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[VM:%.*]], <vscale x 2 x i16> [[VD:%.*]], <vscale x 2 x i16> [[VS2:%.*]], <vscale x 2 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vabd.mask.nxv2i16.i64(<vscale x 2 x i16> [[VD]], <vscale x 2 x i16> [[VS2]], <vscale x 2 x i16> [[VS1]], <vscale x 2 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vabd_vv_u16mf2_mu(vbool32_t vm, vuint16mf2_t vd,
                                    vint16mf2_t vs2, vint16mf2_t vs1,
                                    size_t vl) {
  return __riscv_vabd_vv_u16mf2_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vabd_vv_u16m1_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[VM:%.*]], <vscale x 4 x i16> [[VD:%.*]], <vscale x 4 x i16> [[VS2:%.*]], <vscale x 4 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vabd.mask.nxv4i16.i64(<vscale x 4 x i16> [[VD]], <vscale x 4 x i16> [[VS2]], <vscale x 4 x i16> [[VS1]], <vscale x 4 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vabd_vv_u16m1_mu(vbool16_t vm, vuint16m1_t vd, vint16m1_t vs2,
                                  vint16m1_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m1_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vabd_vv_u16m2_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[VM:%.*]], <vscale x 8 x i16> [[VD:%.*]], <vscale x 8 x i16> [[VS2:%.*]], <vscale x 8 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vabd.mask.nxv8i16.i64(<vscale x 8 x i16> [[VD]], <vscale x 8 x i16> [[VS2]], <vscale x 8 x i16> [[VS1]], <vscale x 8 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vabd_vv_u16m2_mu(vbool8_t vm, vuint16m2_t vd, vint16m2_t vs2,
                                  vint16m2_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m2_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vabd_vv_u16m4_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[VM:%.*]], <vscale x 16 x i16> [[VD:%.*]], <vscale x 16 x i16> [[VS2:%.*]], <vscale x 16 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vabd.mask.nxv16i16.i64(<vscale x 16 x i16> [[VD]], <vscale x 16 x i16> [[VS2]], <vscale x 16 x i16> [[VS1]], <vscale x 16 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vabd_vv_u16m4_mu(vbool4_t vm, vuint16m4_t vd, vint16m4_t vs2,
                                  vint16m4_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m4_mu(vm, vd, vs2, vs1, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vabd_vv_u16m8_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[VM:%.*]], <vscale x 32 x i16> [[VD:%.*]], <vscale x 32 x i16> [[VS2:%.*]], <vscale x 32 x i16> [[VS1:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vabd.mask.nxv32i16.i64(<vscale x 32 x i16> [[VD]], <vscale x 32 x i16> [[VS2]], <vscale x 32 x i16> [[VS1]], <vscale x 32 x i1> [[VM]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vabd_vv_u16m8_mu(vbool2_t vm, vuint16m8_t vd, vint16m8_t vs2,
                                  vint16m8_t vs1, size_t vl) {
  return __riscv_vabd_vv_u16m8_mu(vm, vd, vs2, vs1, vl);
}
