/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import jdk.internal.jimage.ImageReader;
import jdk.internal.jrtfs.JrtFileAttributes;
import jdk.internal.jrtfs.JrtFileStore;
import jdk.internal.jrtfs.JrtFileSystemProvider;
import jdk.internal.jrtfs.JrtPath;
import jdk.internal.jrtfs.JrtUtils;
import jdk.internal.jrtfs.SystemImage;

class JrtFileSystem
extends FileSystem {
    private final JrtFileSystemProvider provider;
    private final JrtPath rootPath = new JrtPath(this, "/");
    private volatile boolean isOpen;
    private volatile boolean isClosable;
    private SystemImage image;
    private static final Set<String> supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "jrt")));

    JrtFileSystem(JrtFileSystemProvider provider, Map<String, ?> env) throws IOException {
        this.provider = provider;
        this.image = SystemImage.open();
        this.isOpen = true;
        this.isClosable = env != null;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosable) {
            throw new UnsupportedOperationException();
        }
        this.cleanup();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singleton(this.getRootPath());
    }

    @Override
    public JrtPath getPath(String first, String ... more) {
        if (more.length == 0) {
            return new JrtPath(this, first);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        for (String path : more) {
            if (path.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(path);
        }
        return new JrtPath(this, sb.toString());
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterable<FileStore> getFileStores() {
        return Collections.singleton(this.getFileStore(this.getRootPath()));
    }

    @Override
    public final Set<String> supportedFileAttributeViews() {
        return supportedFileAttributeViews;
    }

    public final String toString() {
        return "jrt:/";
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw new IllegalArgumentException("pos is " + pos);
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if (syntax.equalsIgnoreCase("glob")) {
            expr = JrtUtils.toRegexPattern(input);
        } else if (syntax.equalsIgnoreCase("regex")) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        Pattern pattern = Pattern.compile(expr);
        return path -> pattern.matcher(path.toString()).matches();
    }

    JrtPath resolveLink(JrtPath path) throws IOException {
        ImageReader.Node node = this.checkNode(path);
        if (node.isLink()) {
            node = node.resolveLink();
            return new JrtPath(this, node.getName());
        }
        return path;
    }

    JrtFileAttributes getFileAttributes(JrtPath path, LinkOption ... options) throws IOException {
        ImageReader.Node node = this.checkNode(path);
        if (node.isLink() && JrtFileSystem.followLinks(options)) {
            return new JrtFileAttributes(node.resolveLink(true));
        }
        return new JrtFileAttributes(node);
    }

    Iterator<Path> iteratorOf(JrtPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        ImageReader.Node node = this.checkNode(path).resolveLink(true);
        if (!node.isDirectory()) {
            throw new NotDirectoryException(path.getName());
        }
        if (filter == null) {
            return node.getChildren().stream().map(child -> path.resolve(new JrtPath(this, child.getNameString()).getFileName())).iterator();
        }
        return node.getChildren().stream().map(child -> path.resolve(new JrtPath(this, child.getNameString()).getFileName())).filter(p -> {
            try {
                return filter.accept((Path)p);
            }
            catch (IOException iOException) {
                return false;
            }
        }).iterator();
    }

    byte[] getFileContent(JrtPath path) throws IOException {
        ImageReader.Node node = this.checkNode(path);
        if (node.isDirectory()) {
            throw new FileSystemException(path + " is a directory");
        }
        return this.image.getResource(node);
    }

    static ReadOnlyFileSystemException readOnly() {
        return new ReadOnlyFileSystemException();
    }

    static boolean followLinks(LinkOption ... options) {
        LinkOption[] linkOptionArray;
        int n;
        int n2;
        if (options != null && (n2 = 0) < (n = (linkOptionArray = options).length)) {
            LinkOption lo = linkOptionArray[n2];
            Objects.requireNonNull(lo);
            if (lo == LinkOption.NOFOLLOW_LINKS) {
                return false;
            }
            throw new AssertionError((Object)"should not reach here");
        }
        return true;
    }

    static void checkOptions(Set<? extends OpenOption> options) {
        for (OpenOption openOption : options) {
            Objects.requireNonNull(openOption);
            if (openOption instanceof StandardOpenOption) continue;
            throw new IllegalArgumentException("option class: " + openOption.getClass());
        }
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND)) {
            throw JrtFileSystem.readOnly();
        }
    }

    synchronized void cleanup() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            this.image.close();
            this.image = null;
        }
    }

    final void setTimes(JrtPath jrtPath, FileTime mtime, FileTime atime, FileTime ctime) throws IOException {
        throw JrtFileSystem.readOnly();
    }

    final void createDirectory(JrtPath jrtPath, FileAttribute<?> ... attrs) throws IOException {
        throw JrtFileSystem.readOnly();
    }

    final void deleteFile(JrtPath jrtPath, boolean failIfNotExists) throws IOException {
        throw JrtFileSystem.readOnly();
    }

    final OutputStream newOutputStream(JrtPath jrtPath, OpenOption ... options) throws IOException {
        throw JrtFileSystem.readOnly();
    }

    final void copyFile(boolean deletesrc, JrtPath srcPath, JrtPath dstPath, CopyOption ... options) throws IOException {
        throw JrtFileSystem.readOnly();
    }

    final FileChannel newFileChannel(JrtPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("newFileChannel");
    }

    final InputStream newInputStream(JrtPath path) throws IOException {
        return new ByteArrayInputStream(this.getFileContent(path));
    }

    final SeekableByteChannel newByteChannel(JrtPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        JrtFileSystem.checkOptions(options);
        byte[] buf = this.getFileContent(path);
        final ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream(buf));
        final long size = buf.length;
        return new SeekableByteChannel(){
            long read = 0L;

            @Override
            public boolean isOpen() {
                return rbc.isOpen();
            }

            @Override
            public long position() throws IOException {
                return this.read;
            }

            @Override
            public SeekableByteChannel position(long pos) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int n = rbc.read(dst);
                if (n > 0) {
                    this.read += (long)n;
                }
                return n;
            }

            @Override
            public SeekableByteChannel truncate(long size2) throws IOException {
                throw new NonWritableChannelException();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                throw new NonWritableChannelException();
            }

            @Override
            public long size() throws IOException {
                return size;
            }

            @Override
            public void close() throws IOException {
                rbc.close();
            }
        };
    }

    final JrtFileStore getFileStore(JrtPath path) {
        return new JrtFileStore(path);
    }

    final void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedFileSystemException();
        }
    }

    final JrtPath getRootPath() {
        return this.rootPath;
    }

    boolean isSameFile(JrtPath path1, JrtPath path2) throws IOException {
        return this.checkNode(path1) == this.checkNode(path2);
    }

    boolean isLink(JrtPath path) throws IOException {
        return this.checkNode(path).isLink();
    }

    boolean exists(JrtPath path) throws IOException {
        try {
            this.checkNode(path);
        }
        catch (NoSuchFileException exp) {
            return false;
        }
        return true;
    }

    boolean isDirectory(JrtPath path, boolean resolveLinks) throws IOException {
        ImageReader.Node node = this.checkNode(path);
        return resolveLinks && node.isLink() ? node.resolveLink(true).isDirectory() : node.isDirectory();
    }

    JrtPath toRealPath(JrtPath path, LinkOption ... options) throws IOException {
        ImageReader.Node node = this.checkNode(path);
        if (JrtFileSystem.followLinks(options) && node.isLink()) {
            node = node.resolveLink();
        }
        return new JrtPath(this, node.getName(), true);
    }

    private ImageReader.Node lookup(String path) {
        try {
            return this.image.findNode(path);
        }
        catch (IOException | RuntimeException ex) {
            throw new InvalidPathException(path, ex.toString());
        }
    }

    private ImageReader.Node lookupSymbolic(String path) {
        String prefix;
        ImageReader.Node node;
        int i = 1;
        while (i < path.length() && (i = path.indexOf(47, i)) != -1 && (node = this.lookup(prefix = path.substring(0, i))) != null) {
            if (node.isLink()) {
                ImageReader.Node link = node.resolveLink(true);
                String resPath = link.getName() + path.substring(i);
                return (node = this.lookup(resPath)) != null ? node : this.lookupSymbolic(resPath);
            }
            ++i;
        }
        return null;
    }

    ImageReader.Node checkNode(JrtPath path) throws IOException {
        this.ensureOpen();
        String p = path.getResolvedPath();
        ImageReader.Node node = this.lookup(p);
        if (node == null && (node = this.lookupSymbolic(p)) == null) {
            throw new NoSuchFileException(p);
        }
        return node;
    }
}

