/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.simple.ExcludeJsonHelper;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.internal.component.model.IvyArtifactName;

final class DefaultModuleIdSetExclude
implements ModuleIdSetExclude {
    private final Set<ModuleIdentifier> moduleIds;
    private final int hashCode;

    static ModuleIdSetExclude of(Set<ModuleIdentifier> ids) {
        return new DefaultModuleIdSetExclude((ImmutableSet<ModuleIdentifier>)ImmutableSet.copyOf(ids));
    }

    private DefaultModuleIdSetExclude(ImmutableSet<ModuleIdentifier> moduleIds) {
        this.moduleIds = moduleIds;
        this.hashCode = moduleIds.hashCode();
    }

    @Override
    public Set<ModuleIdentifier> getModuleIds() {
        return this.moduleIds;
    }

    @Override
    public boolean excludes(ModuleIdentifier module) {
        return this.moduleIds.contains(module);
    }

    @Override
    public boolean excludesArtifact(ModuleIdentifier module, IvyArtifactName artifactName) {
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleIdSetExclude that = (DefaultModuleIdSetExclude)o;
        return this.moduleIds.equals(that.moduleIds);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "{ \"module ids\" : [" + ExcludeJsonHelper.toJson(this.moduleIds) + "]}";
    }
}

