/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state;

import java.util.List;
import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.classfile.MethodSignature;

public class JvmAbstractState<StateT extends LatticeAbstractState<StateT>>
implements LatticeAbstractState<JvmAbstractState<StateT>>,
ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature> {
    protected final JvmFrameAbstractState<StateT> frame;
    protected final JvmHeapAbstractState<StateT> heap;
    protected final MapAbstractState<String, StateT> staticFields;
    protected JvmCfaNode programLocation;
    protected static final JvmCfaNode topLocation = new JvmCfaNode(null, -1, null);

    public JvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<StateT> frame, JvmHeapAbstractState<StateT> heap, MapAbstractState<String, StateT> staticFields) {
        this.programLocation = programLocation;
        this.frame = frame;
        this.heap = heap;
        this.staticFields = staticFields;
    }

    @Override
    public JvmAbstractState<StateT> join(JvmAbstractState<StateT> abstractState) {
        JvmAbstractState<StateT> answer = new JvmAbstractState<StateT>(this.programLocation.equals(abstractState.programLocation) ? this.programLocation : topLocation, this.frame.join(abstractState.frame), this.heap.join(abstractState.heap), this.staticFields.join(abstractState.staticFields));
        return this.equals(answer) ? this : answer;
    }

    @Override
    public boolean isLessOrEqual(JvmAbstractState<StateT> abstractState) {
        return (this.programLocation.equals(abstractState.programLocation) || abstractState.programLocation.equals(topLocation)) && this.frame.isLessOrEqual(abstractState.frame) && this.heap.isLessOrEqual(abstractState.heap) && this.staticFields.isLessOrEqual(abstractState.staticFields);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.programLocation;
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.programLocation = programLocation;
    }

    @Override
    public JvmAbstractState<StateT> copy() {
        return new JvmAbstractState<StateT>(this.programLocation, this.frame.copy(), this.heap.copy(), this.staticFields.copy());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmAbstractState)) {
            return false;
        }
        JvmAbstractState other = (JvmAbstractState)obj;
        return this.programLocation.equals(other.programLocation) && this.frame.equals(other.frame) && this.heap.equals(other.heap) && this.staticFields.equals(other.staticFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.frame, this.heap, this.staticFields, this.programLocation);
    }

    public StateT peek() {
        return this.peek(0);
    }

    public StateT peek(int index) {
        return this.frame.peek(index);
    }

    public StateT peekOrDefault(StateT defaultState) {
        return this.peekOrDefault(0, defaultState);
    }

    public StateT peekOrDefault(int index, StateT defaultState) {
        return this.frame.peekOrDefault(index, defaultState);
    }

    public StateT pop() {
        return this.frame.pop();
    }

    public StateT popOrDefault(StateT defaultState) {
        return this.frame.popOrDefault(defaultState);
    }

    public StateT push(StateT state) {
        return this.frame.push(state);
    }

    public List<StateT> pushAll(List<StateT> states) {
        states.forEach(this.frame::push);
        return states;
    }

    public void clearOperandStack() {
        this.frame.getOperandStack().clear();
    }

    public StateT getVariableOrDefault(int index, StateT defaultState) {
        return this.frame.getVariableOrDefault(index, defaultState);
    }

    public StateT setVariable(int index, StateT state, StateT defaultState) {
        return this.frame.setVariable(index, state, defaultState);
    }

    public StateT getStaticOrDefault(String fqn, StateT defaultState) {
        return (StateT)((LatticeAbstractState)this.staticFields.getOrDefault(fqn, defaultState));
    }

    public void setStatic(String fqn, StateT value) {
        this.staticFields.put(fqn, value);
    }

    public StateT getFieldOrDefault(StateT object, String descriptor, StateT defaultValue) {
        return this.heap.getField(object, descriptor, defaultValue);
    }

    public void setField(StateT object, String descriptor, StateT value) {
        this.heap.setField(object, descriptor, value);
    }

    public JvmFrameAbstractState<StateT> getFrame() {
        return this.frame;
    }

    public MapAbstractState<String, StateT> getStaticFields() {
        return this.staticFields;
    }

    public JvmHeapAbstractState<StateT> getHeap() {
        return this.heap;
    }

    public StateT newArray(String type, List<StateT> dimensions) {
        return this.heap.newArray(type, dimensions, this.programLocation);
    }

    public StateT newObject(String className) {
        return this.heap.newObject(className, this.programLocation);
    }

    public StateT getArrayElementOrDefault(StateT array, StateT index, StateT abstractDefault) {
        return this.heap.getArrayElementOrDefault(array, index, abstractDefault);
    }

    public void setArrayElement(StateT array, StateT index, StateT value) {
        this.heap.setArrayElement(array, index, value);
    }
}

