/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * JosLeys-Kleinian formula
 * @reference
 * http://www.fractalforums.com/3d-fractal-generation/an-escape-tim-algorithm-for-kleinian-group-limit-sets/msg98248/#msg98248
 * This formula contains aux.color and aux.DE

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_jos_kleinian.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 JosKleinianIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL oldZy = z.y;
	REAL oldDE = aux->DE;

	// sphere inversion slot#1 iter == 0
	if (fractal->transformCommon.sphereInversionEnabledFalse)
	{
		if (aux->i < 1)
		{
			REAL rr = 1.0f;
			z += fractal->transformCommon.offset000;
			rr = dot(z, z);
			z *= fractal->transformCommon.maxR2d1 / rr;
			z += fractal->transformCommon.additionConstant000 - fractal->transformCommon.offset000;
			aux->DE *= (fractal->transformCommon.maxR2d1 / rr) * fractal->analyticDE.scale1;
		}
	}

	REAL4 box_size = fractal->transformCommon.offset111;
	// kleinian
	if (aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		REAL a = fractal->transformCommon.foldingValue;
		REAL b = fractal->transformCommon.offset;
		REAL f = sign(b);

		REAL3 box1 = (REAL3){2.0f * box_size.x, a * box_size.y, 2.0f * box_size.z};
		REAL3 box2 = (REAL3){-box_size.x, -box_size.y + 1.0f, -box_size.z};
		REAL3 wrapped = wrap(z.xyz, box1, box2);

		z = (REAL4){wrapped.x, wrapped.y, wrapped.z, z.w};

		// If above the separation line, rotate by 180deg about (-b/2, a/2)
		if (z.y >= a * (0.5f + 0.2f * native_sin(f * M_PI_F * (z.x + b * 0.5f) / box_size.x)))
			z = (REAL4){-b, a, 0.f, z.w} - z; // z.xy = vec2(-b, a) - z.xy;

		REAL rr = dot(z, z);

		if (fractal->foldColor.auxColorEnabled)
		{
			REAL4 colorVector = (REAL4){z.x, z.y, z.z, rr};
			aux->color = min(aux->color, length(colorVector)); // For coloring
		}

		REAL iR = 1.0f / rr;
		z *= -iR;
		z.x = -b - z.x;
		z.y = a + z.y;

		aux->DE *= fabs(iR);
	}
	// color
	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL colorAdd = 0.0f;
		colorAdd += fractal->foldColor.difs0000.x * fabs(oldDE / aux->DE);
		colorAdd += fractal->foldColor.difs0000.y * fabs(z.y);
		colorAdd += fractal->foldColor.difs0000.z * fabs(z.y - oldZy);

		if (fractal->foldColor.auxColorEnabledAFalse
				&& aux->i >= fractal->transformCommon.startIterationsT
				&& aux->i < fractal->transformCommon.stopIterationsT)
		{
			REAL Size = box_size.x * fractal->transformCommon.scale3D222.x;
			REAL dd = ((aux->const_c.x + Size) / Size) + fractal->transformCommon.additionConstantP000.x;
			dd = fabs(dd - round(dd)) * fractal->transformCommon.constantMultiplierC111.x;

			Size = box_size.z * fractal->transformCommon.scale3D222.z;
			REAL ee = ((aux->const_c.z + Size) / Size) + fractal->transformCommon.additionConstantP000.z;
			ee = fabs(ee - round(ee)) * fractal->transformCommon.constantMultiplierC111.z;

			REAL bb = dd + ee;
			dd = dd * dd + ee * ee;

			if (fractal->transformCommon.functionEnabledAFalse)
			{
				Size = box_size.y * fractal->transformCommon.scale3D222.y;
				REAL ff =
					((aux->const_c.y + Size) / Size) + fractal->transformCommon.additionConstantP000.y;
				ff = fabs(ff - round(ff)) * fractal->transformCommon.constantMultiplierC111.y;
				dd = dd + ff;
			}
			dd = bb * (1.0f - fractal->foldColor.difs1) + dd * fractal->foldColor.difs1; // mix

			colorAdd += fractal->foldColor.difs0000.w * dd;
		}

		aux->color += colorAdd;
	}
	return z;
}