/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Blockify
 * based on a block of Fragmentarium code, from Adam Nixon
 * analytic aux.DE

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_blockify_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfBlockifyV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL master = fractal->transformCommon.scale / 100.0f;
	REAL4 bSize = fractal->transformCommon.constantMultiplier111 * master;
	if (!fractal->transformCommon.functionEnabledFalse)
	{
		if (!fractal->transformCommon.functionEnabledDFalse)
		{
			if (fractal->transformCommon.functionEnabledCx)
			{
				if (!fractal->transformCommon.functionEnabledAxFalse)
					z.x = (floor(z.x / bSize.x) + 0.5f) * bSize.x;
				else
					z.x = floor(z.x / bSize.x + 0.5f) * bSize.x;
			}
			if (fractal->transformCommon.functionEnabledCy)
			{
				if (!fractal->transformCommon.functionEnabledAyFalse)
					z.y = (floor(z.y / bSize.y) + 0.5f) * bSize.y;
				else
					z.y = floor(z.y / bSize.y + 0.5f) * bSize.y;
			}
			if (fractal->transformCommon.functionEnabledCz)
			{
				if (!fractal->transformCommon.functionEnabledAzFalse)
					z.z = (floor(z.z / bSize.z) + 0.5f) * bSize.z;
				else
					z.z = floor(z.z / bSize.z + 0.5f) * bSize.z;
			}
		}
		else // normalize
		{
			REAL rNorm = length(z);
			z /= rNorm;
			if (fractal->transformCommon.functionEnabledCx)
			{
				if (!fractal->transformCommon.functionEnabledAxFalse)
					z.x = (floor(z.x / bSize.x) + 0.5f) * bSize.x;
				else
					z.x = floor(z.x / bSize.x + 0.5f) * bSize.x;
			}
			if (fractal->transformCommon.functionEnabledCy)
			{
				if (!fractal->transformCommon.functionEnabledAyFalse)
					z.y = (floor(z.y / bSize.y) + 0.5f) * bSize.y;
				else
					z.y = floor(z.y / bSize.y + 0.5f) * bSize.y;
			}
			if (fractal->transformCommon.functionEnabledCz)
			{
				if (!fractal->transformCommon.functionEnabledAzFalse)
					z.z = (floor(z.z / bSize.z) + 0.5f) * bSize.z;
				else
					z.z = floor(z.z / bSize.z + 0.5f) * bSize.z;
			}
			z *= rNorm;
		}
	}
	else // radial
	{
		REAL4 zz = z * z;
		REAL rr = zz.x + zz.y + zz.z;
		if (fractal->transformCommon.functionEnabledRFalse) rr = native_sqrt(rr);
		if (fractal->transformCommon.functionEnabledBxFalse) rr = zz.x + zz.y;
		if (fractal->transformCommon.functionEnabledByFalse) rr = zz.y + zz.z;
		if (fractal->transformCommon.functionEnabledBzFalse) rr = zz.z + zz.x;
		if (!fractal->transformCommon.functionEnabledEFalse)
		{
			z /= rr;
			rr = floor(rr / master) * master;
			z *= rr;
		}
		else
		{
			z *= rr;
			rr = floor(rr / master) * master;
			z /= rr;
		}
	}

	// post scale
	z *= fractal->transformCommon.scale1;
	aux->DE = aux->DE * fractal->transformCommon.scale1 * fractal->analyticDE.scale1
						+ fractal->analyticDE.offset0;
	// aux->DE = aux->DE - 0.001f;
	// aux->DE *= length(z) / length(oldZ);
	return z;
}