/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * multiple angle

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_multiple_angle.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfMultipleAngleIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL th0 = asin(z.z / aux->r);
	REAL ph0 = atan2(z.y, z.x);
	REAL th = th0 * fractal->transformCommon.multiplication;
	REAL ph = ph0 * fractal->transformCommon.multiplication;
	REAL cth = native_cos(th);
	z = (REAL4){cth * native_cos(ph), cth * native_sin(ph), native_sin(th), 0.0f} * aux->r;
	return z;
}