// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "src/core/util/if_list.h"

#include <memory>

#include "gtest/gtest.h"

namespace grpc_core {

TEST(IfListTest, Works) {
  EXPECT_EQ(IfList(
                0, 42, [](int) { return -1; }, [](int x) { return x == 0; },
                [](int x) { return x; }),
            42);
  EXPECT_EQ(IfList(
                1, 42, [](int) { return -1; }, [](int x) { return x == 0; },
                [](int x) { return x; }),
            -1);
}

}  // namespace grpc_core

int main(int argc, char** argv) {
  ::testing::InitGoogleTest(&argc, argv);
  return RUN_ALL_TESTS();
}
